#include <dnpap.h>
#include <timer.h>
#include <memory.h>
#include "ip.h"

#define IP_REAS_TIMEOUT 60000L

typedef struct _IP_REAS_FRAG    IP_REAS_FRAG;
typedef struct _IP_REAS_DESCR   IP_REAS_DESCR;

struct _IP_REAS_FRAG
{
    IP_REAS_FRAG    *next;
    WORD            offset;
    WORD            length;
    BYTE            data[1];
};


struct _IP_REAS_DESCR
{
    TIMER_DESCR     *timer;
    IP_HDR          hdr;
    WORD            lengthReceived;
    WORD            lengthTotal;
    IP_REAS_FRAG    *fragList;
    IP_REAS_DESCR   *next;
};


IP_REAS_FRAG    *FragCreate(IP_REAS_DESCR *descr, CHAIN *chain, IP_HDR *hdr);
CHAIN           *FragList2Chain(IP_REAS_DESCR *descr);

IP_REAS_DESCR   *DescrCreate(IP_HDR *hdr);
IP_REAS_DESCR   *DescrFind(IP_HDR *hdr);
void            DescrRemove(IP_REAS_DESCR *descr);
void            DescrTimeout(TIMER_DESCR *timer, ULONG now, void *parm);




IP_REAS_DESCR *ipReasList = 0;


BOOLEAN IpReas(CHAIN *chain, CHAIN **reas, IP_HDR *hdr)
{
    BYTE            *options;
    IP_REAS_DESCR   *descr;
    IP_REAS_FRAG    *frag;
    BOOLEAN         success = FALSE;

    descr = DescrFind(hdr);
    if (descr == 0)
    {
        descr = DescrCreate(hdr);
        if (descr == 0)
            return 0;
    }
    frag = FragCreate(descr, chain, hdr);
    if (frag != 0)
    {
        if (hdr->offset==0)
        {
            memcpy(&(descr->hdr), hdr, sizeof(*hdr));
            if (hdr->iol != 0)
            {
                options             = DnpapMalloc(hdr->iol);
                memcpy(options, hdr->options, hdr->iol);
                descr->hdr.options  = options;
            }
        }
        if ((hdr->flags & IP_FLAG_MORE_FRAGMENTS) != IP_FLAG_MORE_FRAGMENTS)
        {
            descr->lengthTotal = frag->offset + frag->length;
        }
        descr->lengthReceived += frag->length;
        if (descr->lengthReceived >= descr->lengthTotal)
        {
            if (descr->lengthReceived == descr->lengthTotal)
            {
                memcpy(hdr, &(descr->hdr), sizeof(*hdr));
                hdr->offset = 0;
                hdr->flags &= ~IP_FLAG_MORE_FRAGMENTS;
                hdr->length = descr->lengthReceived + descr->hdr.ihl;
                *reas       = FragList2Chain(descr);
                success     = TRUE;
            }
            DescrRemove(descr);
        }
    }
    else
    {
        DescrRemove(descr);
    }

    return success;
}


IP_REAS_FRAG *FragCreate(IP_REAS_DESCR *descr, CHAIN *chain, IP_HDR *hdr)
{
    IP_REAS_FRAG *frag;
    WORD         length;
    
    length = ChainLength(chain);
    frag = DnpapMalloc(sizeof(IP_REAS_FRAG)-1+length);
    if (frag==0)
        return 0;
    ChainCopy(chain, frag->data, length);
    frag->offset    = hdr->offset * 8;
    frag->length    = length;
    frag->next      = descr->fragList;
    descr->fragList = frag;
    return frag;
}


CHAIN *FragList2Chain(IP_REAS_DESCR *descr)
{
    CHAIN           *chain;
    IP_REAS_FRAG    *frag;

    chain = ChainAlloc(0, 0, descr->lengthTotal, descr->lengthTotal, 0, 0);
    if (chain == 0)
        return 0;
    for (frag = descr->fragList; frag != 0; frag=frag->next)
    {
        if ((frag->offset + frag->length) > descr->lengthTotal)
        {
            ChainFree(chain);
            return 0;
        }
        memcpy(chain->buffer + frag->offset, frag->data, frag->length);
    }
    return chain;
}





IP_REAS_DESCR *DescrCreate(IP_HDR *hdr)
{
    IP_REAS_DESCR *descr;
   
    descr = DnpapMalloc(sizeof(IP_REAS_DESCR));
    if (descr == 0)
        return 0;
    
    descr->timer = TimerRegister(DescrTimeout, descr,
        IP_REAS_TIMEOUT, TIMER_FOREVER, TIMER_TYPE_SKIP);
    
    memcpy(&(descr->hdr), hdr, sizeof(*hdr));
    descr->hdr.iol = 0;

    descr->lengthTotal      = 0xffff;
    descr->lengthReceived   = 0;

    descr->fragList = 0;

    descr->next = ipReasList;
    ipReasList  = descr;

    return descr;
}

IP_REAS_DESCR *DescrFind(IP_HDR *hdr)
{
    IP_REAS_DESCR *descr;

    for (descr=ipReasList; descr!=0; descr=descr->next)
    {
        if (descr->hdr.src  == hdr->src  &&
            descr->hdr.dst  == hdr->dst  &&
            descr->hdr.prot == hdr->prot &&
            descr->hdr.id   == hdr->id)
        break;
    }
    return descr;
}

void DescrRemove(IP_REAS_DESCR *descr)
{
    IP_HDR          *h;
    IP_REAS_FRAG    *f, *frag;
    IP_REAS_DESCR   **d;
    
    TimerRemove(descr->timer);
    h=&(descr->hdr);
    if (h->iol!=0)
    {
        DnpapFree(h->options);
    }
    f=descr->fragList;
    while (f!=0)
    {
        frag = f;
        f = f->next;
        DnpapFree(frag);
    }
    for (d=&ipReasList; *d!=0 && *d!=descr; d=&(*d)->next);
    if (*d==descr)
    {
        *d = (*d)->next;
    }
    DnpapFree(descr);
}



void DescrTimeout(TIMER_DESCR *timer, ULONG now, void *parm)
{
    IP_REAS_DESCR *descr;

    descr = parm;
    DescrRemove(descr);
}



