#include <memory.h>
#include <string.h>
#include <stdio.h>
#include "snordef.h"
#include "snorsub.h"
#include "snorrqs.h"
#include "snorevt.h"
#include "snorsem.h"
#include "snorerr.h"
#include "snorseg.h"
#include "snorkel.h"
#include "snor.h"
#include <config.h>
 

SNOR_DESCR *snorDescrList = 0;

                  
static SNOR_DESCR   *Create(BYTE *iface, BYTE *driver, USHORT segments);
static void         Remove(SNOR_DESCR *snor);
static BOOLEAN      Check(BLOCK *block);
static BOOLEAN      Stat(MAC_IFACE *iface, MAC_STAT *stats);
static BOOLEAN      Send(MAC_IFACE *iface, CHAIN *chain);



ULONG SnorTime(void)
{
    ULONG           ticks;
    static ULONG    snorTime = -1L;

    if (snorDescrList!=0)
    {
        if (SnorRqsTime(snorDescrList, &ticks) == 0)
            snorTime = SNOR_TICKS_TO_MUSECS(ticks);
    }
    return snorTime;
}





BOOLEAN SnorInit(void)
{
    BYTE            name[255];
    BYTE            *descr;
    BYTE            *driver;
    USHORT          segments;
    SNOR_DESCR      *snor;
    WORD            i;
    static BOOLEAN  init = FALSE;
    
    if (!init)
    {
        i = 1;
        sprintf(name, "snor.iface.name.%d", i);
        while (ConfigGetString(name, &descr))
        {
            driver = descr;
            sprintf(name, "snor.iface.driver.%d", i);
            ConfigGetString(name, &driver);
            
            segments = SNOR_DEF_SEG;
            sprintf(name, "snor.iface.segments.%d", i);
            ConfigGetShort(name, &segments);
            
            snor = Create(descr, driver, segments);
            if (snor != 0)
            {
                snor->next = snorDescrList;
                snorDescrList = snor;
            }
            
            i++;
            sprintf(name, "snor.iface.name.%d", i);
        }
        
        DnpapAtExit(SnorExit);
        
        init = TRUE;
    }
    return init;
}


void SnorExit(void)
{
    SNOR_DESCR      *snor;
    
    while (snorDescrList!=0)
    {
        snor = snorDescrList;
        snorDescrList = snorDescrList->next;
        Remove(snor);
    }
}




static SNOR_DESCR *Create(BYTE *descr, BYTE *driver, USHORT segments)
{
    SNOR_DESCR  *snor;
    MAC_IFACE   *mac;
    BLOCK       *block;

    if ( (snor=DnpapMalloc(sizeof(SNOR_DESCR)))==0)
    {
        SnorErrPrint("No memory for neus descriptor");
        return 0;
    }
    memset(snor, 0, sizeof(SNOR_DESCR));

    if (!SnorSegMalloc(snor, segments+1))
    {
        SnorErrPrint("No memory for neus segments");
        return 0;
    }

	if (SnorSubInit(snor) != 0 )
    {
        SnorErrPrint("Init of first segment failed");
        return 0;
    }
   
    if (!SnorKelOpen(snor, driver, TRUE))
    {
        SnorErrPrint("Could not open %s", driver);
        return 0;
    }

    mac = &snor->mac;
    mac->specific       = snor;
    strcpy(mac->descr, descr);
    mac->type           = MAC_TYPE_ETHERNET_CSMACD;
    mac->speed          = (WORD)snor->tabs.mssc->mssc_speed;
    mac->mtu=snor->tabs.mssc->mssc_maxframe - 14;
    mac->statusOper     = TRUE;
    mac->statusAdmin    = TRUE;
    mac->arp            = MAC_ARP_ETHERNET_10MB;
    memcpy(mac->addr, snor->tabs.mssc->mssc_Perm_SA,6);
    memcpy(mac->addrBroadcast, "\xff\xff\xff\xff\xff\xff",6);
    mac->addrLength     = 6;
    mac->Send           = Send;
    mac->Stat           = Stat;
    if (!MacIfaceRegister(&snor->mac))
    {
        SnorErrPrint("Could not register to mac");
        return 0;
    }
    
    block           = &snor->block;
    block->specific = snor;
    block->hsem     = snor->tx->hsemRing3;
    block->Check    = Check;
    if (!BlockRegister(&snor->block))
    {
        SnorErrPrint("Could not register to block");
        return 0;
    }

    return snor;
}
    

static void Remove(SNOR_DESCR *snor)
{
    MacIfaceRemove(&snor->mac);

    SnorKelClose(snor);

    SnorSegFree(snor);

    DnpapFree(snor);
}


static BOOLEAN Check(BLOCK *block)
{
    SNOR_DESCR  *snor;
    PEVENT      event;
    BYTE        *frame;
    MAC_INFO    info;
    CHAIN       chain;
    ULONG       stamp1=0,stamp2=0;

    snor=(SNOR_DESCR *)block->specific;

    if ( SnorSemSet(snor) != 0)
        return FALSE;
    while((event=SnorEvtGet(snor))!=0)
    {
        switch ( event->usEventType )
	    {
		    case EVENT_FRAME:
                frame            = event->abData;
	            info.copied      = event->usRet2;
	            info.length      = event->usRet1;
	            info.time        = SNOR_TICKS_TO_MUSECS(event->ulTime);
                info.promiscuous = ((frame[0] & (BYTE)0x01)!=(BYTE)0x01 &&
                                    memcmp(frame, snor->mac.addr, 6)!=0);
			    if (event->usRet1 > event->usRet2)
				    snor->truncatedPkts++;
                if (!info.promiscuous)
                    snor->stackedPkts++;
            
                if (ChainAlloc(&chain, event->abData, event->usRet2, event->usRet2, 0, 0)==0)
                    return FALSE;
                
                MacRcve(&snor->mac, &chain, &info);
                
			    break;
		    case EVENT_LOST_FRAMES:
			    snor->discardedPkts += event->usRet1;
                break;
	    }
 	    SnorEvtFree(snor);
    }
    return TRUE;
}


static BOOLEAN Stat(MAC_IFACE *iface, MAC_STAT *stats)
{
    MSSS *msss;
    SNOR_DESCR *snor;

    snor=(SNOR_DESCR *)iface->specific;

    SnorRqsConfig(snor);
    msss=snor->tabs.msss;             
    stats->LostPkts         = msss->msss_NoBuf;
    stats->Octets           = msss->msss_Rcv_bytes;
    stats->Pkts             = msss->msss_Rcv; 
    stats->BroadcastPkts    = msss->msss_Rcv_B;    
    stats->MulticastPkts    = msss->msss_Rcv_M;
    stats->CRCAlignErrors   = msss->msss_CRC;                 
    stats->UndersizePkts    = msss->msss_Rcv_S;                  
    stats->OversizePkts     = msss->msss_Rcv_L;                   
    stats->Fragments        = msss->msss_Rcv_S;
    stats->Jabbers          = msss->msss_Rcv_L;               
    stats->Collisions       = msss->msss_Rcv_E;
    stats->BufferedPkts     = snor->tx->usRecsAvail;
    stats->StackedPkts      = snor->stackedPkts;
    stats->DiscardedPkts    = snor->discardedPkts;
    stats->TruncatedPkts    = snor->truncatedPkts;
    return TRUE;
}


static BOOLEAN Send(MAC_IFACE *iface, CHAIN *chain)
{
    SNOR_DESCR *snor;
    BYTE       *frame;
    WORD       length;
    
    snor=(SNOR_DESCR *)iface->specific;

    length = ChainLength(chain);
    frame = SnorSubMalloc(snor, length);
    if (frame==0)
    {
        return FALSE;
    }
    if (!ChainCopy(chain, frame, length))
    {
        SnorSubFree(snor, frame);
        return FALSE;
    }
    if (SnorRqsSend(snor, frame, length)==0xffff)
    {
        SnorSubFree(snor, frame);
        return FALSE;
    }
    return TRUE;
}
