#ifndef _SNOR_DEF_H_
#define _SNOR_DEF_H_


#define INCL_BASE 
#include <os2.h>
#include <dnpap.h>
#include <block.h>
#include <mac.h>
#include <neus.h>
#include <ndisdef.h>

#define SNOR_TICKS_TO_MUSECS(x) ((ULONG)(((double)(x)*1000.0)/1193.0))

#define	SNOR_MAX_HANDLE  20
#define SNOR_MIN_SEG     2
#define SNOR_DEF_SEG     8
#define SNOR_MAX_SEG     32


typedef struct _SNOR_DESCR SNOR_DESCR;
typedef struct _SNOR_TABS  SNOR_TABS;
typedef struct _SNOR_MH    SNOR_MH;


struct _SNOR_TABS
{
	CCT     *cct;
	MSSC    *mssc;
	MSSS    *msss;
};

struct _SNOR_MH
{
	USHORT	usMem1;
	USHORT	usMem2;
	ULONG	ulMem3;
};



struct _SNOR_DESCR
{
    BLOCK       block;
    MAC_IFACE   mac;
    TXSEG       *tx;
    SEL         sel[SNOR_MAX_SEG];
    USHORT      selCount;
    SNOR_TABS   tabs;
    HFILE       device;
    PEVENT      event;
    SNOR_MH     handle[SNOR_MAX_HANDLE];
    int         handleCount;
    ULONG       stackedPkts;
    ULONG       discardedPkts;
    ULONG       truncatedPkts;
    SNOR_DESCR  *next;
};


#endif

