#include "snordef.h"
#include "snorerr.h"
#include "snordev.h"

                
USHORT	SnorDevCall(HFILE device, PVOID pvData, PVOID pvParms, USHORT usFunction)
{
	USHORT	ret;

	if ( (ret=DosDevIOCtl(pvData, pvParms, usFunction, NEUS_CATEGORY,
			device)) != 0 )
	{
		if ( (ret & 0xff00) == 0xff00 )
		{
			/* NEUS error */
			SnorErrPrint("NEUS IOCtl (%s) error: %4.4Xh (%s)",
				SnorErrFunction(usFunction),
				ret, SnorErrError(ret)); 
		}
		else
		{
			SnorErrPrint("NEUS IOCtl (%s) error: %u",
				SnorErrFunction(usFunction), ret);
		}
	}

	return(ret);
}


HFILE	SnorDevOpen(char far *name)
{
	HFILE	device;
	USHORT	dummy;
	USHORT	rc;

	if ( (rc=DosOpen(name, &device, &dummy, 0L, 0, 1, 42, 0L)) != 0 )
    /* Open file (don't create), R/W compat */
	{
		/* Open error */
		SnorErrPrint("Open error: %u on %Fs", rc, name);
		return(0xffff);
	}
	else
	{
		return(device);
	}
}

VOID SnorDevClose(HFILE device)
{
    DosClose(device);
}





















