#include "snordef.h"
#include "snorerr.h"
#include "snorsem.h"



USHORT SnorSemSet(SNOR_DESCR *snor)
{
    USHORT	ret;

	if ( (ret=DosSemSet(snor->tx->hsemRing3)) != 0)
	{
		SnorErrPrint("DosSemSet failed rc: %u", ret);
	}

	return ret;
}

USHORT	SnorSemWait(SNOR_DESCR *snor, LONG lTimeout)
{
	USHORT	ret;

	if ( (ret=DosSemWait(snor->tx->hsemRing3, lTimeout)) != 0)
	{
		if ( ret == ERROR_SEM_TIMEOUT )
			SnorErrPrint("Wait for semaphore timed out (%d ms)",lTimeout);
		else
			SnorErrPrint("DosSemWait failed rc: %u", ret);
	}
	return ret;
}





