#ifdef PERFORMANCE_TEST


#include <stdlib.h>
#include <stdio.h>
#include <dnpap.h>
#include <mac.h>
#include <mibsup.h>

#include "perfm.h"


static MAC_PERF perf;


BOOLEAN PerfMInit(VOID)
{
    return TRUE;
}


WORD PerfDataControl(SNMP_OBJECT *obj, WORD idlen)
{
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
    case SNMP_PDU_GET:
        MacPerfStatistics(&perf);
        obj->Syntax.LngInt = (perf.on == FALSE ? 2 : 1);
        break;
    case SNMP_PDU_SET:
        if (obj->Syntax.LngInt != 1 && obj->Syntax.LngInt != 2)
            return SNMP_BADVALUE;
        MacPerfSwitch(obj->Syntax.LngInt == 1 ? TRUE : FALSE);
        break;
    }
    return SNMP_NOERROR;
}


WORD PerfPkts(SNMP_OBJECT *obj, WORD idlen)
{
    MacPerfStatistics(&perf);
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    obj->Syntax.LngUns = perf.pkts;
    return SNMP_NOERROR;
}


WORD PerfOctets(SNMP_OBJECT *obj, WORD idlen)
{
    MacPerfStatistics(&perf);
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    obj->Syntax.LngUns = perf.octets;
    return SNMP_NOERROR;
}


WORD PerfTimeTotal(SNMP_OBJECT *obj, WORD idlen)
{
    MacPerfStatistics(&perf);
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    obj->Syntax.LngUns = perf.timeTotal;
    return SNMP_NOERROR;
}


WORD PerfTimeMin(SNMP_OBJECT *obj, WORD idlen)
{
    MacPerfStatistics(&perf);
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    obj->Syntax.LngUns = perf.timeMin;
    return SNMP_NOERROR;
}


WORD PerfTimeMax(SNMP_OBJECT *obj, WORD idlen)
{
    MacPerfStatistics(&perf);
    if (MibSimple(obj, idlen) == FALSE)
        return SNMP_NOSUCHNAME;
    obj->Syntax.LngUns = perf.timeMax;
    return SNMP_NOERROR;
}


#else


#include <dnpap.h>


BOOLEAN PerfMInit(VOID)
{
    return TRUE;
}


#endif
