SYS     = dnpap
SYSLIB  = dnpap

CC = gcc
LN = gcc
RM = rm
CP = cp
MAN = type
AR = ar ru
LIBDIR 	= ../../lib
INCDIR	= ../../include
MANDIR  = ../../man
CFLAGS 	= -O4 -g -Wall -I$(INCDIR) -DOS2 -DGCC
LDFLAGS = -L$(LIBDIR) -lmibdf -lsnmp -lmgmt -ldnpap -los2
MAKE = make
SEP = &

OPTIONS = "CFLAGS=$(CFLAGS)"


all: dnpap.all config.all message.all hash.all maxmem.all timer.all string.all bitbyte.all

install: dnpap.all config.all message.all hash.all maxmem.all timer.all string.all bitbyte.all 

bitbyte.all:
	@cd bitbyte $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS) $(SEP) cd ..

dnpap.all:
	@cd dnpap $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS) $(SEP) cd ..

config.all:
	@cd config  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..

hash.all:
	@cd hash  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..

maxmem.all:
	@cd maxmem  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..

message.all:
	@cd message  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..

string.all:
	@cd string  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..

timer.all:
	@cd timer  $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS)  $(SEP) cd ..


clean: dnpap.clean config.clean hash.clean maxmem.clean message.clean timer.clean string.clean bitbyte.clean

string.clean:
	@cd string $(SEP)$(MAKE) -f gcc_os2.mak clean $(OPTIONS) $(SEP) cd ..

dnpap.clean:
	@cd dnpap $(SEP)$(MAKE) -f gcc_os2.mak clean $(OPTIONS) $(SEP) cd ..

config.clean:
	@cd config  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..

hash.clean:
	@cd hash  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..

maxmem.clean:
	@cd maxmem  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..

message.clean:
	@cd message  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..

string.clean:
	@cd string  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..

timer.clean:
	@cd timer  $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS)  $(SEP) cd ..



