!include ..\..\include\standard.mak

SYS     = message
SYS2    = message
SYSLIB  = dnpap

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: msgmain.obj msgtrans.obj msgfile.obj msgvio.obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+msgmain.obj -+msgtrans.obj -+msgfile.obj -+msgvio.obj;

obj: msgmain.obj msgtrans.obj msgfile.obj msgvio.obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: msgmain.c msgtrans.c msgfile.c msgvio.c
    $(MAN) -R:API  msgmain.c msgtrans.c msgfile.c msgvio.c > $(SYS).man

test.exe: test.obj test.ini
	$(LINK) test.obj dnpap.lib
	markexe windowcompat test.exe
