include ../include/gcc_unx.std

SYS     = mgmt
SYSLIB  = mgmt

OBJ = $(SYS).o udp.o

all: obj doc

install: all $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 
	ranlib $(LIBDIR)/lib$(SYSLIB).a

obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: $(SYS).c pipe.c
	$(MAN) $(SYS).c pipe.c > $(SYS).man

$(SYS).o: $(SYS).c $(SYS).h

udp.o: udp.c $(SYS).h

pipe.o: pipe.c $(SYS).h


test.exe: test
	emxbind -bs test

test: test.o $(INC)
	$(LN) $(CFLAGS) -o test test.o $(OBJ) $(LDFLAGS) -ldnpap
