#ifndef _LIST_H_
#define _LIST_H_

typedef struct _LIST_DESC LIST_DESC;
typedef struct _LIST_ELEM LIST_ELEM;
typedef USHORT (*LIST_HASH)(BYTE *key);

struct _LIST_ELEM
{
    LIST_ELEM *next;
    LIST_ELEM *nextHash;
    BYTE      key[1];
};

struct _LIST_DESC
{
    USHORT      listSize;
    USHORT      elemSize;
    USHORT      keySize;
    LIST_ELEM   **array;
    LIST_ELEM   *first;
    LIST_ELEM   *current;
};

LIST_DESC *ListCreate(USHORT listSize, USHORT elemSize, USHORT keySize);
BYTE *ListFind(LIST_DESC *list, BYTE *key, USHORT hash, BOOLEAN create, BOOLEAN *new);
VOID ListDestroy(LIST_DESC *list);
BYTE *ListFirst(LIST_DESC *list);
BYTE *ListNext(LIST_DESC *list);

#endif
