#define INCL_BASE
#define INCL_KBD
#define INCL_PM
#define INCL_VIO
#include <os2.h>
#include <process.h>
#include <stdlib.h>     
#include <conio.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <limits.h>
#include <string.h>
#include <dnpap.h>
#include <snor.h>
#include <mac.h>
#include <block.h>
#include <config.h>
#include "list.h"
                                                 
#define PIX_APPERTURE 10
#define PIX_WIDTH     16


typedef struct _PIX_HOST    PIX_HOST;
typedef struct _PIX_CONN    PIX_CONN;
typedef struct _PIX_MAT     PIX_MAT;
typedef struct _PIX_PIX     PIX_PIX;
typedef struct _PIX_TEXT    PIX_TEXT;
typedef struct _PIX_HASH    PIX_HASH;
typedef struct _PIX_FRAME   PIX_FRAME;



struct _PIX_HOST
{
    BYTE    address[6];
    USHORT  index;
    PIX_CONN    *firstConn;
};

struct _PIX_CONN
{
    PIX_HOST *host;
    PIX_CONN *nextConn;
    ULONG    bytes;
    ULONG    packets;
};

struct _PIX_MAT
{
    ULONG      hosts;
    ULONG      connections;
    ULONG      packets;
    ULONG      bytes;
    BOOLEAN    ok;
    LIST_DESC  *list;
    PIX_HOST   *source;
    PIX_HOST   *destination;
    PIX_CONN   *connection;
    BYTE       frame[1515];
    USHORT     frameLength;
    USHORT     frameCopied;
};

struct _PIX_PIX
{
    HWND       frame;
    HWND       canvas;
    HWND       scrollX;
    HWND       scrollY;
    SHORT      rangeX;
    SHORT      rangeY;
    SHORT      posX;
    SHORT      posY;
    SHORT      sizeWinX;
    SHORT      sizeWinY;
    SHORT      sizeMatX;
    SHORT      sizeMatY;
};

#define PIX_TEXT_SIZE 9
struct _PIX_TEXT
{
    HWND       frame;
    HWND       canvas;
};

struct _PIX_HASH
{
    HWND       frame;
    HWND       canvas;
};

struct _PIX_FRAME
{
    HWND       frame;
    HWND       canvas;
    HWND       scrollX;
    HWND       scrollY;
    SHORT      rangeX;
    SHORT      rangeY;
    SHORT      posX;
    SHORT      posY;
    SHORT      sizeWinX;
    SHORT      sizeWinY;
    SHORT      sizeFrameX;
    SHORT      sizeFrameY;
    SHORT      sizeCharX;
    SHORT      sizeCharY;
    SHORT      width;
};

#define PIX_PALETTE_SIZE 8
LONG palette[PIX_PALETTE_SIZE] =
{
    CLR_BROWN,
    CLR_RED,
    CLR_PINK,
    CLR_BLUE,
    CLR_CYAN,
    CLR_GREEN,
    CLR_YELLOW,
    CLR_WHITE
};



PIX_MAT         *pixMat;
PIX_PIX         *pixPix;
PIX_TEXT        *pixText;                        
PIX_FRAME       *pixFrame;

#ifdef _HASH_
PIX_HASH        *pixHash;
#endif


USHORT HashFunction(BYTE *key)
{
    USHORT i;

    i=key[0];
    i<<=1;
    i|=key[1];
    i<<=3;
    i|=key[2];
    i<<=3;
    i|=key[3];
    i<<=1;
    i|=key[4];
    i<<=5;
    i|=key[5];
    return i;
}

VOID MatReset(VOID)
{
    PIX_HOST *host;
    PIX_CONN *conn;
    
    for (host=(PIX_HOST *)ListFirst(pixMat->list);host!=0;host=(PIX_HOST *)ListNext(pixMat->list))
    {
        for (conn=host->firstConn;conn!=0;conn=conn->nextConn)
        {
            conn->packets=0;
            conn->bytes=0;
        }
    }
    pixMat->packets=0;
    pixMat->bytes=0;
}



PIX_HOST *MatFindHost(BYTE *address)
{
    BOOLEAN     new;
    PIX_HOST    *host;
    
    new=FALSE;
    host=(PIX_HOST *)ListFind(pixMat->list,address,HashFunction(address),TRUE,&new);
    if (host==0)
    {
        pixMat->ok=FALSE;
        return 0;
    }
    if (new)
    {
        pixMat->hosts++;
        host->firstConn=0;
        host->index=-1;
    }
    return host;
}


VOID MatCallback(MAC_COLL *coll, PROT_PKT *pkt)
{
    SHORT           cmp;
    PROT_BEHOLDER   *beholder;
    BYTE            *frame;
    PIX_HOST        *src,*dst;
    PIX_CONN        *conn,**p;

    beholder = &pkt->Frame->Beholder;
    frame = beholder->Data;
    if ((src=MatFindHost(frame+6))==0)
        return;
    if ((dst=MatFindHost(frame))==0)
        return;
    cmp=1;
    for (p=&src->firstConn;
        *p!=0 && (cmp=memcmp((*p)->host->address,dst->address,6))<0;
        p=&(*p)->nextConn);
    if (cmp!=0)
    {
        conn=(PIX_CONN *)malloc(sizeof(PIX_CONN));
        if (conn==0)
        {
            pixMat->ok=FALSE;
            return;
        }
        pixMat->connections++;
        conn->host=dst;
        conn->nextConn=*p;
        *p=conn;
        conn->packets=0;
        conn->bytes=0;
    }
    conn=*p;
    conn->packets++;
    conn->bytes+=beholder->Len;
    pixMat->packets++;
    pixMat->bytes+=beholder->Len;
    if (conn==pixMat->connection)
    {
        pixMat->frameLength=beholder->Size;
        memcpy(pixMat->frame,frame,beholder->Size);
        WinInvalidateRect(pixFrame->canvas,NULL,TRUE);
    }
}


MRESULT EXPENTRY PixTextWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    HPS           hps;
    RECTL         rect;
    LONG          height,color;
    USHORT        i;
    static BYTE   line[80];

    switch (msg)
    {
    case WM_PAINT:
        WinQueryWindowRect(hwnd,&rect);
        hps = WinBeginPaint(hwnd,NULL,NULL);
        GpiErase(hps);
        height=(rect.yTop-rect.yBottom)/PIX_TEXT_SIZE;
        for (i=0;i<PIX_TEXT_SIZE;i++)
        {
            switch(i)
            {
                case 0:
                    sprintf(line,"State: %s",(pixMat->ok)?"OK":"ERROR");
                    color = CLR_RED;
                    break;
                case 1:
                    sprintf(line,"Hosts: %lu",pixMat->hosts);
                    color = CLR_DARKGREEN;
                    break;
                case 2:
                    sprintf(line,"Connections: %lu",pixMat->connections);
                    color = CLR_DARKGREEN;
                    break;
                case 3:
                    sprintf(line,"Packets: %lu",pixMat->packets);
                    color = CLR_DARKGREEN;
                    break;
                case 4:
                    sprintf(line,"Bytes: %lu",pixMat->bytes);
                    color = CLR_DARKGREEN;
                    break;
                case 5:
                    if (pixMat->source!=0)
                        sprintf(line,"Source: %02x:%02x:%02x:%02x:%02x:%02x",
                            pixMat->source->address[0],
                            pixMat->source->address[1],
                            pixMat->source->address[2],
                            pixMat->source->address[3],
                            pixMat->source->address[4],
                            pixMat->source->address[5]);
                    else
                        strcpy(line,"Source: INVALID");
                    color = CLR_DARKBLUE;
                    break;
                case 6:
                    if (pixMat->destination!=0)
                        sprintf(line,"Destination: %02x:%02x:%02x:%02x:%02x:%02x",
                            pixMat->destination->address[0],
                            pixMat->destination->address[1],
                            pixMat->destination->address[2],
                            pixMat->destination->address[3],
                            pixMat->destination->address[4],
                            pixMat->destination->address[5]);
                    else
                        strcpy(line,"Destination: INVALID");
                    color = CLR_DARKBLUE;
                    break;
                case 7:
                    if (pixMat->connection!=0)
                        sprintf(line,"Packets: %lu",pixMat->connection->packets);
                    else
                        strcpy(line,"Packets: INVALID");
                    color = CLR_DARKBLUE;
                    break;
                case 8:
                    if (pixMat->connection!=0)
                        sprintf(line,"Bytes: %lu",pixMat->connection->bytes);
                    else
                        strcpy(line,"Bytes: INVALID");
                    color = CLR_DARKBLUE;
                    break;
            }
            rect.yTop=   (PIX_TEXT_SIZE-i)*height;
            rect.yBottom=(PIX_TEXT_SIZE-i-1)*height;
            WinDrawText(hps,-1,line,&rect,color,CLR_WHITE,
                DT_CENTER | DT_VCENTER | DT_ERASERECT);
        }
        WinEndPaint(hps);
        return 0;
    default:
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
}


MRESULT EXPENTRY PixHashWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    HPS           hps;
    POINTL        pix;
    USHORT        i,j;
    LIST_ELEM     *p;
    RECTL         rect;

    switch (msg)
    {
    case WM_PAINT:
        hps = WinBeginPaint(hwnd,NULL,&rect);
        WinFillRect(hps,&rect,CLR_BLACK);
        for (i=0;i<pixMat->list->listSize;i++)
        {
            j=0;
            for (p=pixMat->list->array[i];p!=0;p=p->nextHash)
                j++;
            if (j!=0)
            {
                pix.x=i % 500;
                pix.y=100 + 100*(i/500) + 5*j;
                if (j>=PIX_PALETTE_SIZE)
                    j=PIX_PALETTE_SIZE-1;
                GpiSetColor(hps,palette[j]);
                GpiSetPel(hps,&pix);                
            }
        }
        WinEndPaint(hps);
        return 0;
    default:
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
}


VOID PixFind(PPOINTL start, PPOINTL pix)
{
    LONG            d;
    HPS             hps;
    
    hps = WinBeginPaint(pixPix->canvas,NULL,NULL);
    if (GpiQueryPel(hps,start)!=CLR_BLACK)
    {
        pix->x=start->x;
        pix->y=start->y;
        WinEndPaint(hps);
        return;
    }
    for (d=1;d<10;d++)
    {
        pix->x=start->x-d;
        pix->y=start->y-d;

        while (pix->x < start->x+d)
        {
            if (GpiQueryPel(hps,pix)!=CLR_BLACK)
            {
                WinEndPaint(hps);
                return;
            }
            pix->x++;
        }
        while (pix->y < start->y+d)
        {
            if (GpiQueryPel(hps,pix)!=CLR_BLACK)
            {
                WinEndPaint(hps);
                return;
            }
            pix->y++;
        }
        while (pix->x > start->x-d)
        {
            if (GpiQueryPel(hps,pix)!=CLR_BLACK)
            {
                WinEndPaint(hps);
                return;
            }
            pix->x--;
        }
        while (pix->y > start->y-d)
        {
            if (GpiQueryPel(hps,pix)!=CLR_BLACK)
            {
                WinEndPaint(hps);
                return;
            }
            pix->y--;
        }
    }
    pix->x=start->x;
    pix->y=start->y;
    WinEndPaint(hps);
}



MRESULT EXPENTRY PixPixWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    HPS           hps;
    POINTL        pix;
    PIX_HOST      *host;
    PIX_CONN      *conn;
    USHORT        index,color;
    RECTL         rect;
    USHORT        x,y;
    SHORT         pX,pY,dX,dY,d,dMin;

    switch (msg)
    {
    case WM_CREATE:
        pixPix->posX=0;
        pixPix->posY=0;
        pixPix->scrollX=WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT, FALSE),
                                  FID_HORZSCROLL);
        pixPix->scrollY=WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT, FALSE),
                                  FID_VERTSCROLL);
        return 0;
    case WM_SIZE:
        pixPix->sizeWinX = SHORT1FROMMP(mp2);
        pixPix->sizeWinY = SHORT2FROMMP(mp2);
        return 0;
    case WM_PAINT:
        hps = WinBeginPaint(hwnd,NULL,&rect);
        WinFillRect(hps,&rect,CLR_BLACK);
        index=0;
        for (host=(PIX_HOST *)ListFirst(pixMat->list);host!=0;host=(PIX_HOST *)ListNext(pixMat->list))
            host->index=index++;
        for (host=(PIX_HOST *)ListFirst(pixMat->list);host!=0;host=(PIX_HOST *)ListNext(pixMat->list))
        {
            for (conn=host->firstConn;conn!=0;conn=conn->nextConn)
            {
                pix.x=host->index       - pixPix->posX;
                pix.y=conn->host->index - pixPix->posY;
                if (pix.x<0 || pix.x>pixPix->sizeWinX)
                    continue;
                if (pix.y<0 || pix.y>pixPix->sizeWinY)
                    continue;
                if (pixMat->bytes<pixMat->connections)
                    color=0;
                else
                    color=(USHORT)(conn->bytes/(pixMat->bytes/pixMat->connections));
                if (color>=PIX_PALETTE_SIZE)
                    color=PIX_PALETTE_SIZE-1;
                GpiSetColor(hps,palette[color]);
                GpiSetPel(hps,&pix);
            }
        }
        if (pixMat->source!=0 && pixMat->destination!=0)
        {
            if (pixMat->connection!=0)
                GpiSetColor(hps,CLR_GREEN);
            else
                GpiSetColor(hps,CLR_RED);
            for (x=pixMat->source->index-1;x<=pixMat->source->index+1;x++)
            {
                for (y=pixMat->destination->index-1;y<=pixMat->destination->index+1;y++)
                {
                    pix.x = x - pixPix->posX;
                    pix.y = y - pixPix->posY;
                    GpiSetPel(hps,&pix);
                }
            }         
        }
        pixPix->sizeMatX = pixPix->sizeMatY = index;
        pixPix->rangeX = pixPix->sizeMatX-pixPix->sizeWinX + 10;
        pixPix->rangeY = pixPix->sizeMatY-pixPix->sizeWinY + 10;
        if (pixPix->rangeX<0)
            pixPix->rangeX=0;
        if (pixPix->rangeY<0)
            pixPix->rangeY=0;
        if (pixPix->posX>pixPix->rangeX)
            pixPix->posX=pixPix->rangeX;
        if (pixPix->posY>pixPix->rangeY)
            pixPix->posY=pixPix->rangeY;
        WinSendMsg(pixPix->scrollX, SBM_SETSCROLLBAR,
                MPFROM2SHORT(pixPix->posX,0),
                MPFROM2SHORT(0,pixPix->rangeX));
        WinSendMsg(pixPix->scrollY, SBM_SETSCROLLBAR,
                MPFROM2SHORT(pixPix->rangeY - pixPix->posY,0),
                MPFROM2SHORT(0,pixPix->rangeY));
        WinEndPaint(hps);
        return 0;
    case WM_HSCROLL:
        switch (SHORT2FROMMP(mp2))                 
        {
        case SB_LINELEFT:
            pixPix->posX -= 10;
            break;
        case SB_LINERIGHT:
            pixPix->posX += 10;
            break;
        case SB_PAGELEFT:
            pixPix->posX -= pixPix->sizeWinX;
            break;
        case SB_PAGERIGHT:
            pixPix->posX += pixPix->sizeWinX;
            break;
        case SB_SLIDERPOSITION:
            pixPix->posX = SHORT1FROMMP(mp2);
            break;
        }
        if (pixPix->posX < 0)
            pixPix->posX = 0;
        if (pixPix->posX > pixPix->rangeX)
            pixPix->posX = pixPix->rangeX;
        WinSendMsg(pixPix->scrollX,SBM_SETPOS,
                    MPFROM2SHORT(pixPix->posX, 0), 0);
        WinInvalidateRect(pixPix->canvas,NULL,TRUE);              
        return 0;
    case WM_VSCROLL:
        switch (SHORT2FROMMP(mp2))                 
        {
        case SB_LINEDOWN:
            pixPix->posY -= 10;
            break;
        case SB_LINEUP:
            pixPix->posY += 10;
            break;
        case SB_PAGEDOWN:
            pixPix->posY -= pixPix->sizeWinY;
            break;
        case SB_PAGEUP:
            pixPix->posY += pixPix->sizeWinY;
            break;
        case SB_SLIDERPOSITION:
            pixPix->posY = pixPix->rangeY - SHORT1FROMMP(mp2);
            break;
        }
        if (pixPix->posY < 0)
            pixPix->posY = 0;
        if (pixPix->posY > pixPix->rangeY)
            pixPix->posY = pixPix->rangeY;
        WinSendMsg(pixPix->scrollY,SBM_SETPOS,
                    MPFROM2SHORT(pixPix->rangeY - pixPix->posY, 0), 0);
        WinInvalidateRect(pixPix->canvas,NULL,TRUE);              
        return 0;
    case WM_BUTTON1DOWN:
        pX=(SHORT)MOUSEMSG(&msg)->x + pixPix->posX;
        pY=(SHORT)MOUSEMSG(&msg)->y + pixPix->posY;
        dMin=2*(PIX_APPERTURE*PIX_APPERTURE)+1;
        for (host=(PIX_HOST *)ListFirst(pixMat->list);host!=0;host=(PIX_HOST *)ListNext(pixMat->list))
        {
            dX=(SHORT)host->index-(SHORT)pX;
            if ((USHORT)(dX + PIX_APPERTURE) < 2*PIX_APPERTURE)
            {
                for (conn=host->firstConn;conn!=0;conn=conn->nextConn)
                {
                    dY=(SHORT)conn->host->index-(SHORT)pY;
                    if ((USHORT)(dY + PIX_APPERTURE) < 2*PIX_APPERTURE)
                    {
                        d = dX*dX + dY*dY;
                        if (d < dMin)
                        {
                            dMin = d;
                            pixMat->source = host;
                            pixMat->destination = conn->host;
                            pixMat->connection = conn;
                        }
                    }
                }
            }
        }
        WinInvalidateRect(pixText->canvas,NULL,TRUE);
        return 0;
    default:
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
}

MRESULT EXPENTRY PixFrameWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    POINTL        ptl;
    RECTL         rect;
    USHORT        i,j;
    FONTMETRICS   fm;
    HPS           hps;
    static BYTE   line[33];
    static BYTE   octet[3];


    switch (msg)
    {
    case WM_CREATE:
        hps=WinGetPS(hwnd);
        pixFrame->posY=0;
        pixFrame->scrollY=WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT, FALSE),
                                  FID_VERTSCROLL);
        GpiQueryFontMetrics(hps,(LONG)sizeof(fm),&fm);
        pixFrame->sizeCharX=(SHORT)fm.lAveCharWidth+1;
        pixFrame->sizeCharY=(SHORT)fm.lMaxBaselineExt;
        WinReleasePS(hps);
        return 0;
    case WM_SIZE:
        pixFrame->sizeWinX = SHORT1FROMMP(mp2);
        pixFrame->sizeWinY = SHORT2FROMMP(mp2);
        pixFrame->width = (pixFrame->sizeWinX/pixFrame->sizeCharX)/4-4;
        if (pixFrame->width<1)
            pixFrame->width=1;
        if (pixFrame->width>32)
            pixFrame->width=32;
        return 0;
    case WM_PAINT:
        hps=WinBeginPaint(hwnd,NULL,&rect);
        GpiErase(hps);
        i=(pixFrame->posY/pixFrame->sizeCharY)*pixFrame->width;
        ptl.y = pixFrame->sizeWinY-pixFrame->sizeCharY;
        while (i<pixMat->frameLength && ptl.y>0)
        {
            ptl.x = pixFrame->sizeCharX;
            for (j=0;i<pixMat->frameLength && j<pixFrame->width;j++)
            {
                line[j]=(isprint(pixMat->frame[i]))?pixMat->frame[i]:'.';
                sprintf(octet,"%02x",pixMat->frame[i]);
                GpiCharStringAt(hps,&ptl,2,octet);
                ptl.x += 3*pixFrame->sizeCharX;
                i++;
            }
            ptl.x = (3*pixFrame->width + 3)*pixFrame->sizeCharX;
            GpiCharStringAt(hps,&ptl,j,line);
            ptl.y -= pixFrame->sizeCharY;
        }
        pixFrame->sizeFrameY=(pixMat->frameLength/pixFrame->width+1)*pixFrame->sizeCharY;
        pixFrame->rangeY = pixFrame->sizeFrameY-pixFrame->sizeWinY + pixFrame->sizeCharY;
        if (pixFrame->rangeY<0)
            pixFrame->rangeY=0;
        if (pixFrame->posY>pixFrame->rangeY)
            pixFrame->posY=pixFrame->rangeY;
        WinSendMsg(pixFrame->scrollY, SBM_SETSCROLLBAR,
                MPFROM2SHORT(pixFrame->posY,0),
                MPFROM2SHORT(0,pixFrame->rangeY));
        WinEndPaint(hps);
        return 0;
    case WM_VSCROLL:
        switch (SHORT2FROMMP(mp2))                 
        {
        case SB_LINEUP:
            pixFrame->posY -= pixFrame->sizeCharY;
            break;
        case SB_LINEDOWN:
            pixFrame->posY += pixFrame->sizeCharY;
            break;
        case SB_PAGEUP:
            pixFrame->posY -= pixFrame->sizeWinY;
            break;
        case SB_PAGEDOWN:
            pixFrame->posY += pixFrame->sizeWinY;
            break;
        case SB_SLIDERPOSITION:
            pixFrame->posY = SHORT1FROMMP(mp2);
            break;
        }
        if (pixFrame->posY < 0)
            pixFrame->posY = 0;
        if (pixFrame->posY > pixFrame->rangeY)
            pixFrame->posY = pixFrame->rangeY;
        WinSendMsg(pixFrame->scrollY,SBM_SETPOS,
                    MPFROM2SHORT(pixFrame->posY, 0), 0);
        WinInvalidateRect(pixFrame->canvas,NULL,TRUE);              
        return 0;
    default:
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
}





VOID main(int argc, char **argv)
{
    HAB         hab;
    QMSG        qmsg;
    HMQ         hmq;
    ULONG       creation;
    USHORT      i,size,update;
    MAC_COLL    coll;

    if (argc>=2)
        size=atoi(argv[1]);
    else
        size=1001;
    if (argc>=3)
        update=atoi(argv[2]);
    else
        update=5000;
    
    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, DEFAULT_QUEUE_SIZE);

    
    if ((pixMat=malloc(sizeof(PIX_MAT)))==0)
    {
        printf("Error: malloc pixMat\n");
        exit(1);
    }
    memset(pixMat,0,sizeof(PIX_MAT));
    if ((pixMat->list=ListCreate(size,sizeof(PIX_HOST),6))==0)
    {
        printf("Error: ListCreate\n");
        exit(1);
    }
    pixMat->ok=TRUE;

    if ((pixText=malloc(sizeof(PIX_TEXT)))==0)
    {
        printf("Error: malloc pixText\n");
        exit(1);
    }
    memset(pixText,0,sizeof(PIX_TEXT));
    WinRegisterClass(hab,"_PIX_TEXT_",PixTextWndProc,CS_SIZEREDRAW,0);
    creation=FCF_MINMAX        |
             FCF_SHELLPOSITION |
             FCF_SIZEBORDER    |
             FCF_SYSMENU       |
             FCF_TASKLIST      |
             FCF_TITLEBAR;
    pixText->frame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &creation,
                                "_PIX_TEXT_",                
                                "",
                                WS_SYNCPAINT,                                       
                                0,                                 
                                0,                 
                                &pixText->canvas);
    WinSetWindowPos(pixText->frame,
                    NULL,
                    0,
                    0,
                    300,
                    200,
                    SWP_MOVE | SWP_SIZE);
    

#ifdef _HASH_                
    if ((pixHash=malloc(sizeof(PIX_HASH)))==0)
    {
        printf("Error: malloc pixHash\n");
        exit(1);
    }
    memset(pixHash,0,sizeof(PIX_HASH));
    WinRegisterClass(hab,"_PIX_HASH_",PixHashWndProc,CS_SIZEREDRAW,0);
    creation=FCF_MINMAX        |
             FCF_SHELLPOSITION |
             FCF_SIZEBORDER    |
             FCF_SYSMENU       |
             FCF_TASKLIST      |
             FCF_TITLEBAR;
    pixHash->frame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &creation,
                                "_PIX_HASH_",
                                "",
                                WS_SYNCPAINT,                                       
                                0,                                 
                                0,                 
                                &pixHash->canvas);
#endif  
  
    if ((pixPix=malloc(sizeof(PIX_PIX)))==0)
    {
        printf("Error: malloc pixPix\n");
        exit(1);
    }
    memset(pixPix,0,sizeof(PIX_PIX));
    WinRegisterClass(hab,"_PIX_PIX_",PixPixWndProc,CS_SIZEREDRAW,0);
    creation=FCF_MINMAX        |
             FCF_SHELLPOSITION |
             FCF_SIZEBORDER    |
             FCF_SYSMENU       |
             FCF_TASKLIST      |
             FCF_HORZSCROLL    |
             FCF_VERTSCROLL    |
             FCF_TITLEBAR;
    pixPix->frame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &creation,
                                "_PIX_PIX_",
                                "",
                                WS_SYNCPAINT,                                       
                                0,                                 
                                0,                 
                                &pixPix->canvas);
    
    if ((pixFrame=malloc(sizeof(PIX_FRAME)))==0)
    {
        printf("Error: malloc pixFrame\n");
        exit(1);
    }
    memset(pixFrame,0,sizeof(PIX_FRAME));
    WinRegisterClass(hab,"_PIX_FRAME_",PixFrameWndProc,CS_SIZEREDRAW,0);
    creation=FCF_MINMAX        |
             FCF_SHELLPOSITION |
             FCF_SIZEBORDER    |
             FCF_SYSMENU       |
             FCF_TASKLIST      |
             FCF_VERTSCROLL    |
             FCF_TITLEBAR;
    pixFrame->frame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &creation,
                                "_PIX_FRAME_",
                                "",
                                WS_SYNCPAINT,                                       
                                0,                                 
                                0,                 
                                &pixFrame->canvas);
    
    if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
    {
        printf("Error: ConfigInit\n");
        exit(1);
    }
    if (!BlockInit())
    {
        printf("Error: BlockInit\n");
        exit(1);
    }
    if (!SnorInit())
    {
        printf("Error: SnorInit\n");
        exit(1);
    }
    if (!MacInit())
    {
        printf("Error: MacInit\n");
        exit(1);
    }
    coll.Rcve = MatCallback;
    coll.specific = 0;
    if (!MacCollRegister(&coll))
    {
        printf("Error: MacInit\n");
        exit(1);
    }

    i=0;
    while (1)
    {
        if (WinPeekMsg(hab, &qmsg, 0, 0, 0, PM_REMOVE))
        {
            if (qmsg.msg == WM_QUIT)
                break;
            WinDispatchMsg(hab, &qmsg);
        }
        if (!BlockCheck())
        {
            printf("Error: BlockCheck()\n");
        }
        if (++i>=update)
        {
#ifdef _HASH_
            WinInvalidateRect(pixHash->canvas,NULL,TRUE);
#endif
            WinInvalidateRect(pixPix->canvas,NULL,TRUE);              
            WinInvalidateRect(pixText->canvas,NULL,TRUE);
            MatReset();
            i=0;
        }
    }
    
    MacCollRemove(&coll);
   
    WinDestroyWindow(pixFrame->frame);
    free(pixFrame);

#ifdef _HASH_
    WinDestroyWindow(pixHash->frame);
    free(pixHash);
#endif

    WinDestroyWindow(pixPix->frame);
    free(pixPix);

    WinDestroyWindow(pixText->frame);
    free(pixText);
    
    ListDestroy(pixMat->list);
    free(pixMat);

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    exit(1);
}

