!include ..\include\standard.mak

MCFLAGS = -Zi -G2ws  

SYS  = pix
LIBS = $(LIBDIR)\dnpap.lib  $(LIBDIR)\stack.lib  $(LIBDIR)\b2.lib

all: exe doc

install: all $(BINDIR)\$(SYS).exe $(MANDIR)\$(SYS).man 

$(BINDIR)\$(SYS).exe: $(SYS).exe 
	$(CP) $(SYS).exe $(BINDIR)\$(SYS).exe

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

exe: $(SYS).exe

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: mat.c list.c
    $(MAN) -R:API  mat.c list.c > $(SYS).man

$(SYS).exe: mat.obj list.obj $(LIBS)
    link /CO mat.obj list.obj, $(SYS).exe /align:16,NUL,/NOD: $(LIBS) llibcep os2,$(SYS).def
