!include ..\include\standard.mak

SYS     = snmp
SYSLIB  = snmp

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj asn1.obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+asn1.obj;

obj: $(SYS).obj asn1.obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c asn1.c
    $(MAN) -R:API  $(SYS).c asn1.c > $(SYS).man

test.exe: test.obj 
	$(LINK) test.obj dnpap.lib snmp.lib
	markexe windowcompat test.exe
