!include ..\..\include\standard.mak

MCFLAGS = /F 8000

SYS     = tricklet
SYSLIB  = tricklet

LIBS = $(LIBDIR)\mibdf.lib $(LIBDIR)\snmp.lib $(LIBDIR)\mgmt.lib $(LIBDIR)\dnpap.lib

all: snmp-get.exe snmp-set.exe snmp-tbl.exe snmp-nxt.exe npspook.exe stdspook.exe snmp-inf.exe

snmp-get.exe: get.obj parse.obj exec.obj 
	$(LINK) $(CFLAGS) get.obj parse.obj exec.obj $(LIBS) tcpip.lib /Fesnmp-get.exe
	markexe windowcompat snmp-get.exe
			  
snmp-nxt.exe: next.obj parse.obj exec.obj 
	$(LINK) $(CFLAGS) next.obj parse.obj exec.obj $(LIBS) tcpip.lib /Fesnmp-nxt.exe
	markexe windowcompat snmp-nxt.exe
			  
snmp-inf.exe: info.obj parse.obj
	$(LINK) $(CFLAGS) info.obj parse.obj $(LIBS) tcpip.lib /Fesnmp-inf.exe
	markexe windowcompat snmp-inf.exe
			  
stdspook.exe: stdspook.obj spook.obj parse.obj
	$(LINK) $(CFLAGS) stdspook.obj spook.obj parse.obj $(LIBS) tcpip.lib /Festdspook.exe
	markexe windowcompat stdspook.exe
			  
npspook.exe: npspook.obj spook.obj parse.obj
	link npspook.obj+spook.obj+parse.obj,npspook.exe,,$(LIBS) os2.lib llibcmt.lib tcpipmt.lib,/ST:8192/NOI/NOD
	markexe windowcompat npspook.exe

# npspook.c implements a multithreaded TCP/IP applic. Needs special flags
npspook.obj: npspook.c spook.h
        cl /DOS2 /DMSC /c /Alfw /Gs npspook.c

snmp-set.exe: set.obj parse.obj exec.obj 
	$(LINK) $(CFLAGS) set.obj parse.obj exec.obj $(LIBS) tcpip.lib /Fesnmp-set.exe
	markexe windowcompat snmp-set.exe
			  
snmp-tbl.exe: table.obj parse.obj exec.obj 
	$(LINK) $(CFLAGS) table.obj parse.obj exec.obj $(LIBS) tcpip.lib /Fesnmp-tbl.exe
	markexe windowcompat snmp-tbl.exe
			  
clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

install: $(BINDIR)\snmp-get.exe $(BINDIR)\snmp-set.exe $(BINDIR)\snmp-tbl.exe \
        $(BINDIR)\npspook.exe $(BINDIR)\stdspook.exe $(BINDIR)\snmp-inf.exe \
        $(BINDIR)\snmp-nxt.exe $(BINDIR)\npspook.ico

$(BINDIR)\snmp-get.exe: snmp-get.exe
        $(CP) snmp-get.exe $(BINDIR)\snmp-get.exe

$(BINDIR)\snmp-set.exe: snmp-set.exe
        $(CP) snmp-set.exe $(BINDIR)\snmp-set.exe

$(BINDIR)\snmp-tbl.exe: snmp-tbl.exe
        $(CP) snmp-tbl.exe $(BINDIR)\snmp-tbl.exe

$(BINDIR)\snmp-nxt.exe: snmp-nxt.exe
        $(CP) snmp-nxt.exe $(BINDIR)\snmp-nxt.exe

$(BINDIR)\stdspook.exe: stdspook.exe
        $(CP) stdspook.exe $(BINDIR)\stdspook.exe

$(BINDIR)\npspook.exe: npspook.exe
        $(CP) npspook.exe $(BINDIR)\npspook.exe

$(BINDIR)\npspook.ico: npspook.ico
        $(CP) npspook.ico $(BINDIR)\npspook.ico

$(BINDIR)\snmp-inf.exe: snmp-inf.exe
        $(CP) snmp-inf.exe $(BINDIR)\snmp-inf.exe
