/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dp.h
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/10/26
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DP.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DP.H_V  $
**              
**                 Rev 1.1   01 Feb 1991 14:21:42   etstjan
**              
**                 Rev 1.0   26 Oct 1990 12:28:28   etstjan
**              Initial revision.
*************************************************************************/
#include <dnpap.h>                          /* for BYTE                    */

#ifndef DPE_RECEIVEPKT                      /* Do NOT define twice         */

#define DPERR_MISC      0x1001              /* NPD error return codes      */
#define DPERR_NOMEM     0x1002
#define DPERR_RFILE     0x1004
#define DPERR_WFILE     0x1008
#define DPERR_TOOMANY   0x1010

#define DPE_SHOW        0x0001              /* Dispatcher Events           */
#define DPE_START       0x0002
#define DPE_STOP        0x0004
#define DPE_HIDE        0x0008
#define DPE_RESET       0x0010
#define DPE_KEYPRESSED  0x0020
#define DPE_INIT        0x0040
#define DPE_END         0x0080
#define DPE_RECEIVEPKT  0x0100
#define DPE_FREETIME    0x0200
#define DPE_EVERYSECOND 0x0400
#define DPE_TIMER       0x0800
#define DPE_DEFAULT     (DPE_INIT | DPE_START | DPE_SHOW | DPE_RESET | \
                         DPE_END  | DPE_STOP  | DPE_HIDE)

#define DPMAXDEV        4                   /* Max. # of netw. devices     */
#define DPNAMELEN       10                  /* Max. size of Dp names       */
#define DPMAXFILT       8                   /* Max. # of Filters/Apps      */
#define DPMAXTYPEFILT   8                   /* Max. # of Type Filters/Dev  */

#define DP_FUNC_PKTMISSED       1

typedef unsigned int DPKEY;
typedef unsigned int DPEVENT;

/* Packet header description structure */
typedef struct _DPHDRINFO {                 /* Ethernet headers: */
   int DestOff;                             /*     0 */
   int SrcOff;                              /*     6 */
   int TypOff;                              /*    12 */
   int DatOff;                              /*    14 */
   int AddrLen;                             /*     6 */
   int TypLen;                              /*     2 */
} far DPHDRINFO;

extern DPHDRINFO *hdrinfo;

/* Packet buffer description structure */
typedef struct _DPBUF {
    int Dev;                                /* Logic dev# [0..DPMAXDEV-1]  */
    unsigned long ClockMs;                  /* Timestamp in micro seconds  */
    unsigned Status;                        /* Status bits - internal use  */
    unsigned Size;                          /* Packet length in bytes      */
    BYTE far *pBuf;                         /* Pointer to packet's content */
    struct _DPBUF far *pNext;               /* Pointer - internal use      */
} far DPBUF;

/* Dispatcher Filter description structure */
typedef struct _DPFILT {
    char *Name;                             /* Dispatcher Filter name      */
    int (*pProcessEventFunction)(DPEVENT);  /* Event process function      */
    unsigned int Status;                    /* Status bits - internal use  */
    struct _DPFILT *pNext;                  /* Pointer - internal use      */
} DPFILT;

/* Dispatcher Application description structure */
typedef struct _DPAPPS {
    char *Name;                             /* Dispatcher Filter name      */
    int (*pProcessEventFunction)(DPEVENT);  /* Event process function      */
    unsigned int Status;                    /* Status bits - internal use  */
    DPEVENT EventMask;                      /* Accept event mask           */
    DPEVENT StartMask;                      /* Start event mask            */
    DPEVENT TimerMask;                      /* Timer event mask            */    
    unsigned long TimerValue;               /* Timer value                 */
    unsigned long TimerStart;               /* Timer start - internal use  */
    unsigned long TimerStop;                /* Timer stop  - internal use  */
    unsigned long Timer;                    /* Timer timer - internal use  */      
    int FiltCount;                          /* Number of active filters    */
    int FiltActive [DPMAXFILT];             /* List of active filters      */
    unsigned long Profile [15];             /* Data for profiling          */
} DPAPPS;

/* Type Filter description structure */
typedef struct _DPTYPEFILT {
    char *Name;                             /* Type Filter name            */
    int TypeLen;                            /* Type field length in bytes  */
    unsigned char *TypeData;                /* Ptr to protocol type string */
} DPTYPEFILT;

/* Type Filter handle structure */
typedef struct _DPFILTHANDLE {
    unsigned Filt;
    unsigned Handle;
} DPFILTHANDLE;

typedef struct _DPSTAT {
    unsigned long TotalPackets;
    unsigned long TotalBytes;
    unsigned long MissedPackets;
    unsigned long MissedBytes;
} DPSTAT;

typedef struct _DPDEV {
    char Name[DPNAMELEN+1];                    /* Device driver name         */
    int Class;                                 /* Device driver class        */
    int Type;                                  /* Device driver type         */
    int PktInt;                                /* Interrupt# [0x60-0x80]     */
    DPSTAT Stat;                               /* Device driver error counts */
    int TypeFiltCount;                         /* Number of active TypeFilters */
    DPFILTHANDLE TypeFiltActive[DPMAXTYPEFILT]; /* List of active TypeFilters */
} DPDEV;

/* NPD buffer management description structure */
typedef struct _DPINIT {
    unsigned int nSmall;                    /* # of small buffers          */
    unsigned int SmallSize;                 /* Size of small buffers       */
    unsigned int nLarge;                    /* # of large buffers          */
    unsigned int LargeSize;                 /* Size of large buffers       */
} DPINIT;

extern DPTYPEFILT DptAll;
extern DPTYPEFILT DptIP;

#define FR_DUMP_APPEND      1               /* modes for DpDumpInit() */
#define FR_DUMP_CREATE      2
#define FR_DUMP_READ        3

extern  DPINIT      DpInitTable;
extern  DPAPPS     *DpAppsAvailable[];
extern  DPAPPS     *DpAppsActive[];
extern  DPFILT     *DpFiltAvailable[];
extern  DPTYPEFILT *DpTypeFiltAvailable[];
extern  DPDEV       DpDevActive[DPMAXDEV];

extern  int     DpDevInit (void);
extern  void    DpDevEnd (void);
extern  int     DpDevStart (void);
extern  int     DpDevStop (void);
extern  int     DpDevStartDevice (int Dev, int Mode);
extern  int     DpDevStopDevice (int Dev);
extern  int     DpDevAddTypeFilt (int Dev, int Filt);
extern  int     DpDevRemoveTypeFilt (int Dev, int Filt);
extern  int     DpDevGetTypeFiltCount (int Dev);
extern  int     DpDevGetTypeFilt (int Dev, int Filt);
extern  DPSTAT  *DpDevGetStatistics (int Dev);
extern  int     DpDevResetStatistics (int Dev);
extern  char    *DpDevGetName (int Dev);
extern  int     DpDevGetClass (int Dev);
extern  int     DpDevGetType (int Dev);
extern  int     DpDevGetIntr (int Dev);
extern  int     DpDevGetCount (void);

extern  int     DpTypeFiltInit (void);
extern  void    DpTypeFiltEnd (void);
extern  int     DpTypeFiltGetCount (void);
extern  char    *DpTypeFiltGetName (int Filt);
extern  int     DpTypeFiltGetLength (int Filt);
extern  char    *DpTypeFiltGetData (int Filt);

extern  int     DpAppsInit (void);
extern  int     DpAppsEnd (void);
extern  int     DpAppsStart (void);
extern  int     DpAppsStop (void);
extern  int     DpAppsReceivePkt (void);
extern  int     DpAppsFreeTime (void);
extern  int     DpAppsEverySecond (void);
extern  int     DpAppsTimer (int Apps);
extern  int     DpAppsEvent (int Apps, DPEVENT Event);
extern  int     DpAppsGetCount (void);
extern  int     DpAppsGetApps (char *Name);
extern  char    *DpAppsGetName (int Apps);
extern  int     *DpAppsGetStatus (int Apps);
extern  unsigned long DpAppsGetTimer (int Apps);
extern  long    *DpAppsGetProfile (int Apps);

extern  int     DpFiltInit (void);
extern  void    DpFiltEnd (void);
extern  int     DpFiltFilter (int Filt);
extern  int     DpFiltEvent (int Filt, int Event);
extern  int     DpFiltGetCount (void);
extern  char    *DpFiltGetName (int Filt);
extern  int     *DpFiltGetStatus (int Filt);

extern  void    DpEnd(void);
extern  int     DpEvent(int apps, DPEVENT Event);
extern  DPBUF  *DpReceivePkt(void);
extern  DPKEY   DpGetKey(void);
extern  int     DpInit(void);
extern  void    DpLoop(void );
extern  int     DpStart(void);
extern  void    DpStop(void );
extern  void    DpQuit(void );

extern unsigned long clock_ms(void);     /* defined in clocka.asm */
extern unsigned long clock_us(void);     /* defined in clocka.asm */
extern void          clock_init(void);   /* defined in clocka.asm */
extern void          clock_exit(void);   /* defined in clocka.asm */

#endif

