!include ..\include\standard.mak

LIBS    = dnpap.lib
EXPLIB  = vip.lib
EXPINC  = vip.h	      
EXPMAN  = vip.man

SYS     = viptest
SRC     = vip2win.c  vipdial.c  vipexcep.c vipfont.c vipframe.c \
          vipgraph.c vipimage.c vipinput.c vipkeys.c viplabel.c \
          vipmenu.c  vipmeter.c vipprint.c vippush.c vipscrol.c \
          viptext.c  viptimer.c viptrans.c    
OBJS1   = vipdial.obj vipframe.obj vippush.obj viptext.obj 
OBJS2   = viplabel.obj vipgraph.obj vipfont.obj vip2win.obj 
OBJS3   = vipmenu.obj vipprint.obj viptrans.obj vipscrol.obj
OBJS4   = viptimer.obj vipinput.obj vipkeys.obj vipexcep.obj vipmeter.obj
OBJS    = $(OBJS1) $(OBJS2) $(OBJS3) $(OBJS4) 
LOBJS1  = -+vip2win.obj  -+vipdial.obj  -+vipframe.obj -+vippush.obj 
LOBJS2  = -+viptext.obj  -+viplabel.obj -+vipgraph.obj -+vipfont.obj 
LOBJS3  = -+vipmenu.obj  -+vipprint.obj -+viptrans.obj -+vipscrol.obj 
LOBJS4  = -+viptimer.obj -+vipinput.obj -+vipkeys.obj -+vipexcep.obj -+vipmeter.obj
LOBJS   = $(LOBJS1) $(LOBJS2) $(LOBJS3) $(LOBJS4)

# CFLAGS  = -DOS2 -DMSC -Zip -G2ws -W4 -Oxaz -Fm -DDEBUG #-Od
CFLAGS  = -DOS2 -DMSC -G2ws -W4 -Oxaz -Fm # -Zi -DDEBUG -Od
LFLAGS  = /ST:4000 /CO
LIBS    = dnpap.lib


all: $(EXPLIB) $(EXPMAN) test

install: all $(LIBDIR)\$(EXPLIB) $(INCDIR)\$(EXPINC) $(MANDIR)\$(EXPMAN)

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak
    - $(RM) *.res

$(EXPLIB): $(OBJS)
    $(AR) $(EXPLIB) $(LOBJS);

$(LIBDIR)\$(EXPLIB): $(EXPLIB)
    $(CP) $(EXPLIB) $(LIBDIR)

$(INCDIR)\$(EXPINC): $(EXPINC)
    $(CP) $(EXPINC) $(INCDIR)

$(MANDIR)\$(EXPMAN): $(EXPMAN)
    $(CP) $(EXPMAN) $(MANDIR)

man: $(EXPMAN)

$(EXPMAN): $(SRC)
    $(MAN) -R:API vip*.c > $(EXPMAN)


test: $(SYS).exe 

$(SYS).exe: viptest.obj viptest.res viptest.ini $(LIBDIR)\vip.lib 
    link $(LFLAGS) /m /align:16 viptest.obj,$(SYS),viptest.map, /NOD $(LIBDIR)\VIP $(LIBDIR)\DNPAP LLIBCEP OS2, viptest.def
    mapsym viptest
    $(RC) viptest.res viptest.exe

viptest.obj: viptest.c viptest.h

viptest.res: viptest.rc
    $(RC) -r viptest.rc

viptest.ini: viptest.cfg
    $(CI) viptest.cfg
				
session.exe: session.obj
    link /F /align:16 session.obj,session,NUL, /NOD LLIBCEP OS2
    markexe WINDOWCOMPAT session.exe
    
