/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipbutton.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Empty Button Module.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#define LIBRARY
#include "vipinc.h"

PRIVAT LONG VipButtonHandler(VIPINFO *wip, USHORT msg, MPARAM mp1, MPARAM mp2);
PRIVAT void VipButtonUpdate(VIPINFO *wip, HPS hps, BOOLEAN all);
PRIVAT void DefCallBack(VIPINFO *wip, void *p, BOOLEAN pressed);
PRIVAT void FlagCallBack(VIPINFO *wip, void *p, BOOLEAN pressed);
PRIVAT BOOLEAN ButtonKeyHandler(VIPINFO *wip, void *p, int keyCode);


/**************************************************************
** NAME:        VipOpenButton                             [API]
** SYNOPSIS:    VIPINFO *VipOpenButton(VIPINFO *parent,
**                  int x, int y, int w, int h)
** DESCRIPTION: Opens a normal button button.
** RETURNS:     VIPINFO pointer
**************************************************************/
VIPINFO *
VipOpenButton(VIPINFO *parent, int x, int y, int w, int h)
{
    VIPINFO *wip;

    if (!(wip = VipOpenSimple(parent, x,y,w,h)))
        return NULL;

    wip->callback = (VIP_CALLBACK)DefCallBack;
    wip->type = T_PUSH;
    wip->border = 2;
    wip->btype = VIP_RISE;
 
    /* Change Update function to a button draw function... */
    wip->update=VipButtonUpdate;
    wip->handler=VipButtonHandler;
    return wip;
}


/**************************************************************
** NAME:        VipSetButtonFlag                          [API]
** SYNOPSIS:    void VipSetButtonFlag(VIPINFO *wip,
**                  BOOLEAN *flagptr)
** DESCRIPTION: Installs a flag pointer. The button will update
**              the flag with the buttonstatus.
** RETURNS:     void
**************************************************************/
EXPORT void
VipSetButtonFlag(VIPINFO *wip, BOOLEAN *flagptr)
{
    TYPETEST(wip,T_PUSH,return);
    wip->callback = (VIP_CALLBACK)FlagCallBack;
    wip->pointer = flagptr;
}


/**************************************************************
** NAME:        VipSetButtonCallBack                      [API]
** SYNOPSIS:    void VipSetButtonCallBack(VIPINFO *wip,
**                  VIP_BUTTCALL callback, void *ptr)
** DESCRIPTION: Installs a callback function. This function
**              will be called when the button is buttoned
**              or released. The function must have the
**              following syntax:
**              void callback(VIPINFO *wip, void *ptr, BOOLEAN f);
**              The pointer <ptr> can point to anything, the
**              argument <f> will be true when the button is
**              pressed.
** RETURNS:     void
**************************************************************/
EXPORT void
VipSetButtonCallBack(VIPINFO *wip, VIP_BUTTCALL callback, void *ptr)
{
    TYPETEST(wip,T_PUSH,return);
    wip->callback = (VIP_CALLBACK)callback;
    wip->pointer = ptr;
}


PRIVAT LONG
VipButtonHandler(VIPINFO *wip, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    POINTL pp;
    HPS hps;

	switch(msg)
	{
	case WM_BUTTON1DOWN:
        wip->active=TRUE;
        WinSetFocus(HWND_DESKTOP, wip->win); 
        WinSetCapture(HWND_DESKTOP, wip->win);
        hps=WinGetPS(wip->win);
        GpiSetColor(hps, BACKGROUND(wip));
        MOVE(wip->border-1, wip->border-1); 
        BOX(wip->cx-wip->border, wip->cy-wip->border);
        WinReleasePS(hps);

        if (wip->callback)
            wip->callback(wip, wip->pointer, (int)TRUE);
		return TRUE;

	case WM_BUTTON1UP:
        wip->active=FALSE;
        WinSetCapture(HWND_DESKTOP, NULL);
        hps=WinGetPS(wip->win);
        GpiSetColor(hps, SHADOW1(wip));
        MOVE(wip->border-1, wip->border);
        LINE(wip->border-1, wip->cy-wip->border);
        LINE(wip->cx-wip->border-1, wip->cy-wip->border);

        GpiSetColor(hps, SHADOW2(wip));
        MOVE(wip->cx-wip->border, wip->cy-wip->border-1);
        LINE(wip->cx-wip->border, wip->border-1);
        LINE(wip->border, wip->border-1);
        WinReleasePS(hps);
        if (wip->callback)
            wip->callback(wip, wip->pointer, FALSE);
		return TRUE;
	}
	return VipSimpleHandler(wip, msg, mp1, mp2);
}


PRIVAT void
VipButtonUpdate(VIPINFO *wip, HPS hps, BOOLEAN all)
{
    RECTL rect;

    rect.xLeft=0;
    rect.yBottom=0;
    rect.xRight=wip->cx;
    rect.yTop=wip->cy;
    if (all)
    {
        wip->border = 3 - wip->active;
        VipBorder(wip, hps);
        VipUseFont(hps, wip->font);
        if (wip->title)
            WinDrawText(hps, -1, wip->title, &rect,
                FOREGROUND(wip), BACKGROUND(wip), DT_VCENTER|DT_CENTER);
        VipReleaseFont(hps, wip->font);
    }
    else
        VipDrawBorder(wip, &rect, hps, wip->btype, 3 - wip->active);
}


PRIVAT void
DefCallBack(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    VipBell();
}


PRIVAT void
FlagCallBack(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    *(BOOLEAN *)(p)=pressed;
}

PRIVAT BOOLEAN
ButtonKeyHandler(VIPINFO *wip, void *p, int keyCode)
{
    BOOLEAN newState;
    if (VIPKEY_CODE(keyCode)!=(int)(long)p) return FALSE;
    if (keyCode&VIP_KEYRELEASE)
        newState=FALSE;
    else
        newState=TRUE;
    if ((newState!=wip->active) && wip->update)
    {
        HPS hps=WinGetPS(wip->win);
        wip->active=newState;
        wip->update(wip,hps,FALSE);
        WinReleasePS(hps);
    }
    wip->active=newState;
    if (wip->callback)
        wip->callback(wip, wip->pointer, wip->active);
    return TRUE;
}


EXPORT void
VipSetButtonKey(VIPINFO *wip, int key)
{
    TYPETEST(wip,T_PUSH,return);
    VipSetLooseKeys(wip,vipAllSet);
    VipSetKeyHandler(wip, ButtonKeyHandler, (void*)key);
}

