/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       viptest.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Test file for VIP.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h> 
#include <string.h> 
#include <dnpap.h>
#include <config.h>
#include <message.h>
#include "vip.h"

PRIVAT VIPINFO *winframe=NULL, *winframe2, *winnumb, *winmeter;
PRIVAT VIPINFO *winlogo, *windial, *winbut1, *winbut2, *winlabel, *wingraph;
PRIVAT VIPINFO *winmenu, *winmenu2, *topmenu, *winchild, *winscrol, *wininput;
PRIVAT void AboutVip(VIPINFO *win, VOID *p, int value);
PRIVAT VIPTIMER *timer;

PRIVAT int tabs[]={100, 300};

PRIVAT void
Init(int argc,char **argv)
{
    /* Initialize Config System */
    ConfigInit(argc,argv);
    ConfigLoad();

    /* Initialize Message System, with FILE and VIP device */
    MessageInit("viptest", MSGFILE, MSGVIP, NULL);

    /* Initialize the VIP System! */
    if (!VipInit(argc,argv))
        DnpapMessage(DMC_ERROR,1,"Failed to initialize VIP!");
}


PRIVAT VOID
FileMenu(VIPINFO *wip, void *p, int selection)
{
    switch(selection)
    {
    case 4:VipClose(winframe);break;
    case 8:AboutVip(winframe, NULL, 0);break;
    }
}


PRIVAT void
PrintMenu(VIPINFO *wip, void *p, int selection)
{
    switch(selection)
    {
    case 1:VipPrintWindow(winframe,TRUE);break;
    case 2:VipPrinterSetup();break;
    case 3:VipPrinterQuery(winframe);break;
    }
}


PRIVAT void
TimeMeas(VIPTIMER *wip, VOID *p)
{
    VipSetGraphLast(wingraph, 1, 10+rand()%50);
    VipSetGraphLast(wingraph, 0, 50+rand()%60);
    VipSetDialCurrent(windial, rand()%125);
    VipSetMeterCurrent(winmeter, rand()%125);
    VipUpdate(wingraph, 0);
    VipUpdate(windial, 0);
    VipUpdate(winmeter, 0);
}


int a;

PRIVAT void
Measure(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    if (!pressed)
/*        TimeMeas(NULL, NULL); */
         a=(int)wip / (int)p;
}


PRIVAT void
SetNumber(VIPINFO *wip, void *p, int current)
{
    static char buf[12];
    sprintf(buf,"%d%%", current);
    VipSetTextLine ((VIPINFO*)p,  buf, 0, VIP_RIGHT);
    VipUpdate((VIPINFO*)p, 0);
}


PRIVAT void
StartTimer(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    if (!pressed)
    {
        if (timer)
        {
            VipDestroyTimer(timer);
            VipSetTitle(winbut1, "Start Timer!");
            timer=NULL;
        }
        else                     
        {
            timer = VipCreateTimer(1000, TimeMeas, NULL);
            VipSetTitle(winbut1, "Stop Timer!");
        }
        VipUpdate(wip,TRUE);
    }
}

void main(int argc, char **argv)
{
	int i, num;
    int sizes[20];
    char buf[255];
    char getal[12];

    Init(argc,argv);               /* Initialize VIP system */

    winframe = VipOpenFrame  (NULL,100,100,800,800);       /* Open a frame */
    if (!winframe)
    {
        DnpapMessage(DMC_FATAL, 1, "Failed to open frame window!");
        DnpapExit(1);
    }
    topmenu   = VipOpenMenu   (winframe,  0,0,1000,0);     /* Open a menu */
    winframe2 = VipOpenFrame  (winframe,  0,0,1000,1000);  /* Remaining space */
    winscrol  = VipOpenVScroll(winframe2, 0,0,0,0);
    winchild  = VipOpenSimple (winframe2, 0,0,1000,1000);

    VipSetMenuType (topmenu, VIP_HMENU|VIP_FIXMENU);
    VipSetMenuEntry(topmenu, "~Files", 0, 0, NULL);
    VipSetMenuEntry(topmenu, "~Edit",  1, 0, NULL);
    VipSetMenuEntry(topmenu, NULL,     2, VIP_MENUBAR, NULL);
    VipSetMenuEntry(topmenu, "~Help",  3, 0, NULL);

    VipSetFrameSplit(winframe, topmenu, VIP_HSPLIT|VIP_FIXTOP);
    VipSetFrameSplit(winframe2, winscrol, VIP_VSPLIT);

    wininput = VipOpenInput  (winchild,50,500,425,75);   /* Open a input window */

    VipSelectFont(windial,  FONTFACE_TIMES, 10, 0);
    windial  = VipOpenDial   (winchild,525,50,425,425);   /* Open a dial */

    wingraph = VipOpenGraph  (winchild,50,50,425,425);    /* Open a graph */
    VipSelectFont(wingraph, FONTFACE_TIMES, 10, 0);

    /* Open two buttons */
    winbut1  = VipOpenButton (winchild,50,875,200,100);   /* Open a button */
    winbut2  = VipOpenButton (winchild,300,875,200,100);  /* Open a button */
    VipSetTitle  (winbut1, "Start Timer!");
    VipSetTitle  (winbut2, "Measure!");
    VipSelectFont(winbut1, FONTFACE_HELV,  16, 0);
    VipSelectFont(winbut2, FONTFACE_HELV,  20, 0);

    VipSetAbout     (winframe, AboutVip);
    VipSetTitle     (winframe, "VipTest");
    

    VipSetTitle     (windial,  "Packet/s");
    VipSetDialRange (windial,  0,100,10);

    winmeter = VipOpenMeter  (winchild,525,500,425,75);    /* Open a meter */
    VipSetTitle (winmeter, "%ld%%");
    VipSetMeterRange (winmeter,  0,100,10);
    VipSetForeground (winmeter, VIP_RED);
    VipSetBackground (winmeter, VIP_BLUE);

    winlogo = VipOpenList(winchild, 50, 650, 850, 200);   /* Open a text box */
    VipSetTextScrollbars (winlogo,
        VipOpenVScroll(winchild, 900, 650,   0, 200),
        VipOpenHScroll(winchild,  50, 600, 850,  50));

    VipSelectFont (winlogo,  FONTFACE_TIMES, 24, 0);
    VipSetTextTabs (winlogo, 2, tabs, VIP_TABLINES);
    VipSetTextLine (winlogo,  "1\tNAME\tVirtual Interface Protocol", 0, VIP_CENTER);
    VipSetTextLine (winlogo,  "2\tDATE\tby Alfred Kayser, May 1992", 1, VIP_CENTER);
    VipSetTextLine (winlogo,  "3", 2, VIP_CENTER);
    VipSetTextLine (winlogo,  "4\tOS/2\tAvailable for OS/2 and XWindows", 3, VIP_CENTER);
    VipSetTextLine (winlogo,  "5\tMSDOS\tSoon on MSDOS!", 4, VIP_CENTER);

    winnumb  = VipOpenText   (winchild,800,925,100,50);   /* Open a input window */
    VipSetTextLine (winnumb,  "0%", 0, VIP_RIGHT);
    VipSetScrollCallBack(winscrol, SetNumber, winnumb);

#ifdef TEST
    VipSetDialRange (winlogo,  0,0,0);               /* Force an error! */
#endif

    strcpy(buf,"Font Sizes (Roman) : ");
    num=VipQueryFontSizes(FONTFACE_TIMES,sizes,20);
    for (i=0;i<num;i++)
    {
        sprintf(getal,"%d ",sizes[i]);
        strcat(buf,getal);
    }
    VipSetTextLine  (winlogo, buf, 5, VIP_LEFT);
    strcpy(buf,"Font Sizes (Helv) : ");
    num=VipQueryFontSizes(FONTFACE_HELV,sizes,20);
    for (i=0;i<num;i++)
    {
        sprintf(getal,"%d ",sizes[i]);
        strcat(buf,getal);
    }
    VipSetTextLine  (winlogo, buf, 6, VIP_LEFT);

    VipSetGraphDataSet(wingraph, 1, 20, 0, 100, "Tokenring", VIP_BLUE);
    VipSetGraphDataSet(wingraph, 0, 20, 0, 100, "Ethernet",  VIP_RED);

    VipSetButtonCallBack(winbut1, StartTimer, NULL);
    VipSetButtonCallBack(winbut2, Measure, NULL);

    for (i=0; i<15; i++)
    {
        VipSetGraphLast(wingraph, 0, 40+rand()%30);
        VipSetGraphLast(wingraph, 1, 10+rand()%50);
    }

    winlabel = VipOpenLabel  (winchild,500,500,0,0);      /* Open a label */
    VipSelectFont(winlabel, FONTFACE_TIMES, 12, 0);
    VipSetTitle (winlabel, "Moveable Label");

    VipSetInputBuffer(wininput, buf, sizeof(buf));
    VipShow(winframe);

    winmenu  = VipOpenMenu(winchild,500,500,0,0);      /* Open a menu */
    VipSelectFont(winmenu, FONTFACE_HELV,  10, 0);
    VipSetMenuEntry (winmenu,  "~New",       0, 0, NULL);
    VipSetMenuEntry (winmenu,  "~Open",      1, 0, NULL);
    VipSetMenuEntry (winmenu,  "~Save",      2, 0, NULL);
    VipSetMenuEntry (winmenu,  "Save ~As",   3, 0, NULL);
    VipSetMenuEntry (winmenu,  "~Close",     4, 0, NULL);
    VipSetMenuEntry (winmenu,  NULL,         5, VIP_MENUBAR, NULL);
    VipSetMenuEntry (winmenu,  "~Print ...", 6, 0, NULL);
    VipSetMenuEntry (winmenu,  NULL,         7, VIP_MENUBAR, NULL);
    VipSetMenuEntry (winmenu,  "A~bout",     8, 0, NULL);
    VipSetMenuType  (winmenu, VIP_POPMENU);
    VipSetMenuCallBack(winmenu, FileMenu);

    VipSetMenuEntry (topmenu, "~Files", 0, VIP_MENUSUB, winmenu);

    /* After the show, create the invisible windows: */
    winmenu2 = VipOpenMenu(winchild,600,400,0,0); /* Open a submenu */
    VipSetMenuEntry (winmenu,  "~Print ...", 6, VIP_MENUSUB, winmenu2);
    VipSetMenuEntry (winmenu2, "~Info",      3, 0, NULL);
    VipSetMenuEntry (winmenu2, "~Setup",     2, 0, NULL);
    VipSetMenuEntry (winmenu2, "~All",       1, 0, NULL);
    VipSetMenuEntry (winmenu2, "Print",      0, VIP_CENTER|VIP_MENUTITLE, NULL);
    VipSetMenuCallBack(winmenu2, PrintMenu);
    VipSetMenuType  (winmenu2, VIP_POPMENU);
    VipSelectFont (winmenu2,  FONTFACE_TIMES,  12, 0);

    VipCheck(TRUE);
    DnpapExit(0);

#ifdef NEW
	while(1)
	{
		VipCheck(FALSE);
    	current += (rand()%21)-10;
    	VipSetDialCurrent(windial, current);
		VipUpdate(windial,FALSE);
    	if (current<0) current=0;
    	if (current>125) current=100;
	}
#endif
}


PRIVAT void
MessageFun(VIPINFO *win, void *p, BOOLEAN flag)
{
    if (flag==FALSE) /* RELEASED */
        VipDestroy((VIPINFO *)p);
    else
        VipUpdate(win,TRUE);
}


PRIVAT void
AboutVip(VIPINFO *frame, VOID *p, int value)
{
    VIPINFO *twin, *pwin, *aboutWin;

    if (!(aboutWin = VipOpenSimple(NULL,250,250,500,500)))
        return;
    twin= VipOpenText(aboutWin, 50,300,900,650);
    pwin= VipOpenButton(aboutWin, 300,50,400,200);
    if (!twin || !pwin)
    {
        VipDestroy(aboutWin);
        return;
    }
    VipSetTitle(aboutWin, "About VIP ...");
    if (!frame) VipSetSystemMenu(aboutWin, FALSE);
    else VipSetBorder(aboutWin, 2, VIP_RISE);
    VipSetTitle(pwin, "Okay");
    VipSetTextLine(twin, "T.U.Delft, CARDIT, DNPAP", 5, VIP_CENTER);
    VipSetTextLine(twin, "Authors: Alfred Kayser",   4, VIP_CENTER);
    VipSetTextLine(twin, "Version: 1.00, May 1992",  3, VIP_CENTER);
    VipSetTextLine(twin, "The Great Virtual Interface Protocol!", 1, VIP_CENTER);
    VipSetButtonCallBack(pwin, MessageFun, aboutWin);
    VipSelectFont(twin, FONTFACE_TIMES, 16, 0);
    VipSelectFont(pwin, FONTFACE_TIMES, 16, 0);
    VipShow(aboutWin);
}


