/*
  Traffic Visor III Utilites  05.12.2006

  "-?" for help
*/


parse upper arg fname1 "/CP:" cp fname
if fname = "" then fname = fname1

if left(strip(fname),1) = '"' then
do
  parse var fname '"' fname '"'
  fname = strip(fname)
end

if fname = "" | fname = "-?" | fname = "-H" then
do
  say "USAGE:"
  say "  setfilter.cmd [/cp:encoding] file"
  say
  say "EXAMPLE USAGE:";
  say "  setfilter.cmd /cp:koi8-r myfilter.xml";
  exit
end

ReqPipeName = "\PIPE\TV3REQ"
LF = x2c('0A')

rc = stream(ReqPipeName,'C','OPEN')
parse value rc with PipeState ':' OS2RC
if OS2RC\='' then
do
  say 'Cannot open a pipe'
  exit
end

rc = stream(fname,'c','open read')
if rc\='READY:' then
do
  say 'Cannot open file "'fname'"'
  exit
end
size = stream(fname,'c','query size')

/* --- send file --- */
boundary = "24815163842"
call send "POST /filter"
call send "Content-Type: multipart/form-data; boundary=---------------------------" || boundary
call send "Content-Length: " || size
call send ""
call send "-----------------------------" || boundary
line = "Content-Disposition: form-data; name=""filter.xml"""
if cp\="" then line = line || "; charset=""" || cp || """"
call send line
call send ""

do while (lines(fname)\=0)
  line = linein(fname)
  call send line
end
rc = stream(fname,'C','CLOSE')

call send "-----------------------------" || boundary || "--"

/* --- recv. answer --- */
result = ''
do forever
 line = charin(ReqPipeName,,1024)
 if line = '' then leave 
 result = result || line
end
rc = stream(ReqPipeName,'C','CLOSE')

do forever
  rpos = pos(LF,result)
  if rpos=0 then
  do
    say result
    leave
  end
  else do
    say left(result,rpos-1)
    result = substr(result,rpos+1) 
  end
end

EXIT

send: procedure expose ReqPipeName
/*expose (Globals)*/
  line = arg(1)
  rc = lineout(ReqPipeName,line)
return