/*
	Traffic Visor III NDIS driver 
	Install/uninstall script

					Vasilkin Andrey, 2007
*/



fname_driver = 'TV3CAP.SYS'
fname_NIF = 'TV3CAP.NIF'

say 'TrafficVisor III NDIS driver installer/uninstaller'
say

boot_drive = left(GetOS2BootDrive(),1)
arg_remove = ''
arg_install = ''
arg_view = 0
mptn_drive = boot_drive

parse upper arg param

param = strip(param)
do while left(param,1) = '/'
  parse var param '/' key '/' -1 param
  key = space(translate(key,' ',','),0);
  val = strip(substr(key,2),'L',':')
  key = left(key,1)
  select
    when key='I' then
      if val = '' then arg_install = '*'
      else
        do
          i = verify(val, xrange(0,9), 'N')
          if i \= 0 then
            call fail 'invalid interface for installing: "' || substr(val,i,1) || '"'
          arg_install = val
        end
    when key='U' then
      if val = '' then arg_remove = '*'
      else
        do
          i = verify(val, xrange(0,9), 'N')
          if i \= 0 then
            call fail 'invalid interface for uninstalling: "' || substr(val,i,1) || '"'
          arg_remove = val
        end
    when key='V' then arg_view = 1
    when key='D' then mptn_drive = val
    when key='?' | key='H' then nop
    otherwise
      call fail 'unknown switch "'key'"'
  end
  param = strip(param)
end

if arg_remove = '' & arg_install = '' & \arg_view then
do
  say 'Usage: INSTALL.CMD [/I[list]] [/U[list]] [/V] [/D:<drive>]'
  say '  /I	Install/update driver (def. all interfaces)'
  say '  /U	Remove driver (def. all interfaces)'
  say '  /V	Print current drivers'
  say '  /D:d	Disk drive where MPTN is installed'
  say '  list	List of interfaces in any forms: "[:]0,1,2" or "[:]0 1 2" or "[:]012"'
  say
  say 'Examples:'
  say '  install.cmd /i - install on all interfaces'
  say '  install.cmd /i:0,2 /u 1 3 - install on interfaces: 0,2 and uninsall from: 1,3'
  say '  install.cmd /v /u01 - print current drivers and uninstall from 0 and 1'
  exit
end

if arg_remove\='*' & arg_install\='*' & verify(arg_remove,arg_install,'M') \= 0 then
  call fail 'the interface cannot be specified for both switches /I and /U at the same time'

i = verify(mptn_drive, xrange('C','Z'), 'N')
if i \= 0 then
  call fail 'invalid MPTN drive: "' || substr(mptn_drive,i,1) || '"'

protocol_ini_path = mptn_drive':\IBMCOM'
path_driver = protocol_ini_path'\MACS\'
fname_protocol_ini = protocol_ini_path'\PROTOCOL.INI'

/* --- Read protocol.ini --- */

rc = readFile(fname_protocol_ini, 'protocol_ini')
call failRC rc,"can't read the file "fname_protocol_ini". Option /D: must be specified."

rc = getBindings('TCPIP_NIF','MAC_sections')
call failRC rc,"can't find a keyword BINDINGS, section [TCPIP_NIF] ("fname_protocol_ini")"

call getIBMLXCFG 'NIF_list'

ready_for_install = ''
ready_for_remove = ''
i = 0
do k = 1 to MAC_sections.0
  if MAC_sections.k = '' then iterate

  i = i+1
  j = 0
  cur_section = MAC_sections.k
  Interface.i.installed = 0
  prot_section = 'TCPIP_NIF'
  do forever
    j = j+1
    DriverName = getDriver(cur_section)
    Interface.i.j.section = cur_section
    Interface.i.j.uplink_prot_section = prot_section
    Interface.i.j.driver_name = DriverName
    Interface.i.j.title = getTitle('NIF_list',cur_section)
    Interface.i.j.is_tv3 = IsTV3MACDriverName(DriverName)
    if Interface.i.j.is_tv3 then
      Interface.i.installed = 1

    cur_section = getLowBindSection(DriverName)
    if cur_section = '' then leave
    parse var cur_section prot_section' 'cur_section
  end
  Interface.i.0 = j

  if Interface.i.installed then ready_for_remove = ready_for_remove || (i-1)
  else ready_for_install = ready_for_install || (i-1)
end
Interface.0 = i

if arg_view then
do
  /* --- Print state --- */

  do i = 1 to Interface.0
    line = 'Interface ' || (i-1)
    if Interface.i.installed then line = line || ' - installed'
    say line

    do j = 1 to Interface.i.0
      if Interface.i.j.section = '' then iterate
      line = Interface.i.j.driver_name || ', ' || Interface.i.j.title
      if Interface.i.j.is_tv3 then line = '  -> ' || line
      else line = '     ' || line
      say line
    end
    say
  end
end

if arg_remove = '' & arg_install = '' then exit

if arg_remove = '*' then
 if ready_for_remove = '' then
   call fail 'tv3cap was not installed'
 else
   arg_remove = ready_for_remove

if arg_install = '*' then
 if ready_for_install = '' then
   call fail 'there is no new interfaces for installing tv3cap'
 else
   arg_install = ready_for_install

/* --- Clearing --- */

do i = 1 to Interface.0
  if \Interface.i.installed then iterate

  do j = 1 to Interface.i.0
    if Interface.i.j.is_tv3 then leave
  end
  uplink_section = Interface.i.j.uplink_prot_section
  target_section = Interface.i.j.section
  next = j+1
  replace_with_section = Interface.i.next.section
  call RemoveFromBindings uplink_section, target_section, replace_with_section
  call RemoveFromBindings 'TCPBEUI_NIF', target_section, replace_with_section

  Interface.i.j.section = ''
  Interface.i.next.uplink_prot_section = uplink_section
end
call RemoveAllTV3Sections

/* --- Mark target interfaces ---  */

do i = 1 to length(arg_remove)
  j = substr(arg_remove,i,1)+1
  if symbol('Interface.j.installed') \= 'VAR' then
    call fail 'invalid interface ' || (j-1) || ' is specified for /U switch'
  if Interface.j.installed then
    Interface.j.installed = 0
  else
    call fail 'tv3cap is not installed on the interface ' || (j-1)
end

do i = 1 to length(arg_install)
  j = substr(arg_install,i,1)+1
  if symbol('Interface.j.installed') \= 'VAR' then
    call fail 'invalid interface ' || (j-1) || ' is specified for /I switch'
  if \Interface.j.installed then
    Interface.j.installed = 1
  else
    call fail 'tv3cap is already installed on the interface ' || (j-1)
end

/* --- Correct bindings ---  */

tv3cap_count = 0
do i = 1 to Interface.0
  if \Interface.i.installed then iterate

  found = 0
  do j = 1 to Interface.i.0
    if (Interface.i.j.section \= '') & \IsVPCMACDriver(Interface.i.j.driver_name) then
    do
      found = 1
      leave
    end
  end
  if \found then
    call fail 'tv3cap cannot be installed on the interface 'i

  uplink_section = Interface.i.j.uplink_prot_section
  tv3cap_count = tv3cap_count+1
  target_section.tv3cap_count = Interface.i.j.section
  replace_with_section = 'TV3' || tv3cap_count || 'CAP_nif'

  call RemoveFromBindings uplink_section, target_section.tv3cap_count, replace_with_section
  call RemoveFromBindings 'TCPBEUI_NIF', target_section.tv3cap_count, replace_with_section
end
if tv3cap_count > 7 then
  call fail 'too many interfaces for tv3cap installation'

if arg_install \= '' then
do
  /* --- Copy driver ---  */

  say 'Copy 'fname_driver' to 'path_driver || fname_driver
  if stream(fname_driver,'c','query exists') = '' then
    call fail "can't find file "fname_driver
  '@copy 'fname_driver' 'path_driver' >nul'

  if stream(fname_NIF,'c','query exists') \= '' then
    '@copy 'fname_NIF' 'path_driver' >nul'
end

/* --- Output protocol.ini ---  */

save_fname = getProtocolIniSaveFN()
say 'Save 'fname_protocol_ini' to 'fname_protocol
'@ren 'fname_protocol_ini' 'save_fname

last_section = ''
section = ''
IBMLXCFG_done = 0
do i = 1 to protocol_ini.0
  section_line = left(strip(protocol_ini.i),1) = '['
  if section_line then
  do
    last_section = section
    parse upper var protocol_ini.i . '[' section . ']'
    if last_section = 'TCPIP_NIF' then
      do j = 1 to tv3cap_count
        call lineout fname_protocol_ini, '[TV3'j'PR_nif]'
        call lineout fname_protocol_ini, ''
        call lineout fname_protocol_ini, '   DriverName = TV3'j'PR$'
        call lineout fname_protocol_ini, '   Bindings = 'target_section.j
        call lineout fname_protocol_ini, ''
      end
  end
  if section = 'IBMLXCFG' then 
  do
    if protocol_ini.i \= '' & \section_line then
    do
      if \IBMLXCFG_done then
      do
        IBMLXCFG_done = 1
        do j = 1 to tv3cap_count
          call lineout fname_protocol_ini, '   TV3'j'CAP_nif = tv3cap.nif'
        end
      end
      parse upper var protocol_ini.i 'TV3'N'CAP_NIF'
      if length(N)=1 & datatype(N,'W') & N>=1 & N<=8 then iterate
    end
  end
  call lineout fname_protocol_ini, protocol_ini.i
end

do j = 1 to tv3cap_count
  call lineout fname_protocol_ini, '[TV3'j'CAP_nif]'
  call lineout fname_protocol_ini, ''
  call lineout fname_protocol_ini, '   DriverName = TV3'j'CAP$'
  call lineout fname_protocol_ini, ''
end
say 'File 'fname_protocol_ini' is changed'


/* --- Test and change config.sys ---  */

fname_config_sys = boot_drive':\config.sys'
changed = 0;
i = 0
do while lines(fname_config_sys)
  line = linein(fname_config_sys)
  parse upper var line key . '=' val .
  if (key = 'DEVICE') & (filespec("name",val) = 'TV3CAP.SYS') then
  do
    path = filespec("drive",val) || filespec("path",val)
    if path \= path_driver then
    do
      line = 'REM ' || line
      changed = 1
    end
    else do
      if tv3cap_count > 0 then
        tv3cap_count = tv3cap_count - 1
      else do
        changed = 1
        iterate
      end
    end
  end
  i = i+1
  config_sys.i = line
end
call stream fname_config_sys, 'c', 'close'
config_sys.0 = i

if changed | (tv3cap_count > 0) then
do
  save_fname = substr(fname_config_sys,1, lastpos('.',fname_config_sys) ) || 'tv'

  say 'Save 'fname_config_sys' to 'save_fname
  if stream(save_fname,'c','query exists') \= '' then
    '@del 'save_fname
  '@ren 'fname_config_sys' *.tv'

  do i=1 to config_sys.0
    call lineout fname_config_sys, config_sys.i
  end
  do while(tv3cap_count > 0)
    call lineout fname_config_sys, 'DEVICE=' || path_driver || fname_driver
    tv3cap_count = tv3cap_count-1
  end
  call lineout fname_config_sys
  say 'File 'fname_config_sys' is changed'
end

EXIT


getProtocolIniSaveFN:
  i = lastpos('.',fname_protocol_ini)
  fname_protocol = substr(fname_protocol_ini,1,i)
  save_fname = fname_protocol || 'tv'
  do j=0 while stream(fname_protocol || 'tv' || j, 'c', 'query exists')\=''
  end
  fname_protocol = fname_protocol || 'tv' || j
return '*.tv' || j

IsVPCMACDriver: procedure
  parse upper value translate(arg(1)) with 'DSWCH'N'$'
return length(N)=2 & datatype(N,'W') & N>=0 & N<=9

RemoveAllTV3Sections: procedure expose protocol_ini.
  j = 0
  do i = 1 to protocol_ini.0
    if left(protocol_ini.i,1) = '[' then
    do
      parse var protocol_ini.i '[' scan_section . ']'
      iterate
    end

    parse var protocol_ini.i param '=' val .
    param = translate(param)
    if param = 'DRIVERNAME' & (IsTV3ProtoDriverName(val) | IsTV3MACDriverName(val)) then
    do
      j = j+1
      sections_list.j = translate(scan_section)
    end
  end
  sections_list.0 = j

  in_tv3_section = 0
  k = 0
  do i = 1 to protocol_ini.0
    line = translate(strip(protocol_ini.i))
    if left(line,1) = '[' then
    do
      parse var line '[' section_name . ']'
      in_tv3_section = 0
      do j = 1 to sections_list.0
        if section_name = sections_list.j then
        do
          in_tv3_section = 1
          leave
        end
      end
    end
    else
      if section_name = 'IBMLXCFG' then
      do
        parse var line param '=' val
        found = 0
        do j = 1 to sections_list.0
          if param = sections_list.j then
          do
            found = 1
            leave
          end
        end
        if found then iterate
      end

    if in_tv3_section then iterate

    k = k+1
    if k \= i then
    do
      protocol_ini.k = protocol_ini.i
      drop protocol_ini.i
    end
  end
  protocol_ini.0 = k
return

IsTV3ProtoDriverName: procedure
  parse upper value translate(arg(1)) with 'TV3'N'PR$'
return length(N)=1 & datatype(N,'W') & N>=1 & N<=8

RemoveFromBindings: procedure expose protocol_ini. BindingsLineNumb BindingsLine
  section = arg(1)
  target_section = translate(arg(2))
  replace_with_section = arg(3)

  if getBindings(section,'target_sections') = 0 then return
  line = '';
  do i = 1 to target_sections.0
    if line\='' then line = line || ','
    if translate(target_sections.i) = target_section then
      line = line || replace_with_section
    else
      line = line || target_sections.i
  end

  protocol_ini.BindingsLineNumb = BindingsLine || '= ' || line
return

IsTV3MACDriverName: procedure
  parse upper value translate(arg(1)) with 'TV3'N'CAP$'
return length(N)=1 & datatype(N,'W') & N>=1 & N<=8

getLowBindSection: procedure expose protocol_ini.
  mac_driver_name = translate(arg(1))

  parse value mac_driver_name with 'DSWCH'N'$'
  proto_driver_name = 'PSWCH'N'$'
  if ( length(N)=2 & datatype(N,'W') & N>=0 & N<=9 ) then signal l00

  parse value mac_driver_name with 'TV3'N'CAP$'
  proto_driver_name = 'TV3'N'PR$'
  if ( length(N)=1 & datatype(N,'W') & N>=1 & N<=8 ) then signal l00

  proto_driver_name = 'SFPROT$'
  if mac_driver_name = 'SFMAC$' then signal l00

  return ''

l00:
  DriverName = ''
  Bindings = ''
  do i = 1 to protocol_ini.0
    line = strip(protocol_ini.i)
    if left(line,1) = '[' then
    do
      if DriverName = proto_driver_name & Bindings \= '' then
        return section' 'Bindings
      parse upper var line '[' section . ']'
      iterate
    end

    parse var protocol_ini.i param '=' val .
    param = translate(param)
    if param = 'DRIVERNAME' then
      DriverName = val
    else if param = 'BINDINGS' then
      Bindings = val
  end

  if DriverName = proto_driver_name & Bindings \= '' then
    return section' 'Bindings
return ''

getDriver: procedure expose protocol_ini.
  mac_section = arg(1)
  i = getSectionLine(mac_section)
  if i = 0 then
    call fail 'section ['mac_section'] not found'

  do i = i+1 to protocol_ini.0
    if left(protocol_ini.i,1) = '[' then
      leave

    parse var protocol_ini.i param '=' val .
    if translate(strip(param)) = 'DRIVERNAME' then
      return val
  end
  call fail 'keyword DriverName not found in section ['mac_section']'
return

getTitle:
  nif_list_base = arg(1)
  nif_section = arg(2)
  getTitle_result = '['nif_section']'
  if symbol(nif_list_base || '.' || translate(nif_section)) = 'VAR' then
  do
    file = protocol_ini_path || '\MACS\' || value(nif_list_base || '.' || translate(nif_section))
    if stream(file,'c','query exists') \= '' then
    do
      do while lines(file)
        parse value linein(file) with param . '=' val
        if translate(param) = 'TITLE' then
        do
          getTitle_result = strip(strip(val),'B','"')
          leave
        end
      end
      call stream file,'c','close'
    end
  end
return getTitle_result

getIBMLXCFG:
  i = getSectionLine('IBMLXCFG');
  if i = 0 then return 0

  output = arg(1)
  do i = i+1 to protocol_ini.0
    if left(protocol_ini.i,1) = '[' then leave
    parse upper var protocol_ini.i param '=' val .
    param = strip(param)
    if param \= '' & val \= '' then
      call value output || '.' || param, val
  end
return

getBindings:
  i = getSectionLine(arg(1));
  if i = 0 then return 0

  found = 0
  do i = i+1 to protocol_ini.0
    if left(protocol_ini.i,1) = '[' then leave
    parse var protocol_ini.i param '=' val
    if translate(strip(param)) = 'BINDINGS' then
    do
      found = 1
      val = strip(val)
      leave
    end
  end
  if \found then return 0
  BindingsLineNumb = i
  BindingsLine = param

  output = arg(2)
  parse var val . "" -1 lastChar
  do i=1 by 1 while val\=''
    parse var val bindings_list_item ',' val .
    call value output || '.' || i, bindings_list_item
  end
  if lastChar = ',' then
    call value output || '.' || i, ''
  else
    i = i-1
  call value output'.0', i
return i

getSectionLine: procedure expose protocol_ini.
  section = '[' || translate(arg(1)) || ']'

  do i = 1 to protocol_ini.0
    if translate(strip(protocol_ini.i)) = section then
      return i
  end
return 0

readFile:
  fname = arg(1)
  output = arg(2)
  i = 0
  do while lines(fname)
    i = i+1
    call value output'.'i, linein(fname)
  end
  call value output'.0', i
  call stream fname,'c','close'
return i

GetOS2BootDrive: procedure expose (exposeList)
                    /* load the REXXUTIL functions                    */
  call rxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
  call SysLoadFuncs

                    /* install a local error handler                  */
  signal on Syntax name GetOS2BootDrive1

  boot_drive = ''
  boot_drive = SysBootDrive()

GetOS2BootDrive1:
                    /* if SysBootDrive() failed, boot_drive is still  */
                    /* empty                                          */
                    /* SysBootDrive() is only in the newer versions   */
                    /* of REXXUTIL!                                   */
  if boot_drive = '' then
  do
                    /* You should do further tests to ensure that     */
                    /* the result of this method is correct!          */
    parse upper value VALUE( "PATH",, prog.__env ) with "\OS2\SYSTEM" -2,
                        boot_drive +2
  end /* if boot_drive = '' then */

return boot_drive

failRC:
  if arg(1) > 0 then return
  call fail arg(2)
fail:
  say 'Error: 'arg(1)
  exit