/* RxSLibp
   search the current libpath for a module
   returns the fully qualified path if found or null if not found
   Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
   mckinnis@attglobal.net */
Trace('N')
If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Parse Arg dll
boot_drive = SysBootDrive()
config_sys = boot_drive || '\config.sys'
xrc = SysFileSearch('libpath', config_sys, 'lib_path.')
If xrc = 0 & lib_path.0 <> 0 Then
   Do i = 1 To lib_path.0
      lib_test = Space(Translate(lib_path.i))
      If Abbrev(lib_test, 'REM') Then
         Iterate i
      If \Abbrev(lib_test, 'LIBPATH') Then
         Iterate i
      lib_equal = Space(Substr(lib_test, 8))
      If \Abbrev(lib_equal, '=') Then
         Iterate i
      Parse Var lib_test . '=' lib_path
   End
lib_path = Space(lib_path)
our_path = SysTempFileName('lib????')
old_value = Value(our_path, lib_path, 'os2environment')
dll_path = SysSearchPath(our_path, dll)
old_value = Value(our_path, old_value, 'os2environment')
Return dll_path
