/* */

/* ========================================= */
/* Default output if no parameters are given */
/* ========================================= */

'@echo off'

parse upper arg month
if month="" then do
  say
  say "Usage:"
  say "READ_LOG[.CMD] <month>|DEFAULT"
  say
  say "<mon> is a three-letter abbreviation of the month from which you want to"
  say "process the logfile. The logfile is deleted after processing."
  say
  say "DEFAULT can be used to use the current month as parameter."
  say
  say "Examples:"
  say "READ_LOG jan               - Reads the log from january"
  say "READ_LOG.CMD nov           - Reads the log from november"
  say "READ_LOG DEFAULT           - Reads the log from current month"
  say
  exit
end

/* Get current month */
if month='DEFAULT' then do
        month=date('M')
        month=substr(month,1,3)
end

/* =================== */
/* Start the real work */
/* =================== */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ----------------------------------------------------- */
/* Read config-file, declare variables, delete old files */
/* ----------------------------------------------------- */

configfile = 'logread.cfg'
call stream configfile, 'command', 'open read'
injoy_home = linein(configfile)
datafiles_home = linein(configfile)
call stream configfile, 'command', 'close'

logfile = injoy_home'\firewall\acc\ip-usage.'month
logfile_clean = injoy_home'\firewall\acc\ip-usage_clean.'month
tempfile = datafiles_home'\temp.fil'
userfile = datafiles_home'\users.lst'
currentusers = datafiles_home'\currentusers.fil'

call SysFileDelete logfile_clean
call SysFileDelete tempfile
call SysFileDelete currentusers

/* ------------------------------------------- */
/* Clean up log, extract the parts we want for */
/* ------------------------------------------- */

call stream logfile, 'command', 'open read'
call stream logfile_clean, 'command', 'open write'

/* Get down to [MONTHLY TOTAL] */
do until substr(dataline,1,5)="[MONT"
    dataline=linein(logfile)
end

/* Jump further to IP-address list */
do until substr(dataline,1,5)="IP-AD"
    dataline=linein(logfile)
end
dataline=linein(logfile)

/* Read first line of valuable information, continue reading until "other" */
/* Write interesting information to new logfile */
dataline=linein(logfile)
do until substr(dataline,1,5)="other"
    res=lineout(logfile_clean,dataline)
    dataline=linein(logfile)
end
call stream logfile, 'command', 'close'
call stream logfile_clean, 'command', 'close'

/* =========================================== */
/* Get information from new, clean logfile     */
/* Generate info, update userfile if necessary */
/* =========================================== */

call stream logfile_clean, 'command', 'open read'

/* ---------------------------------------------------------------------------- */
/* I'll create one file per ip-address, containing two lines of information:    */
/*  - Incoming traffic                                                          */
/*  - Outgoing traffic                                                          */
/* This will be used to find out if there has been activity since the last time */
/* we checked                                                                   */
/* ---------------------------------------------------------------------------- */

do while lines(logfile_clean) > 0
    dataline = linein(logfile_clean)
    ip_address = left(dataline,15)
    space_exists = 1
    do while space_exists = 1
        lastspace = lastpos(' ',ip_address)
        if lastspace = 0 then do
            space_Exists = 0
        end
        else do
            ip_address = left(ip_address,lastspace-1)
            space_exists = 1
        end
    end
    traffic = substr(dataline,474)
    slashpos = lastpos('/',traffic)
    traffic_in = substr(traffic,1,slashpos-1)
    traffic_out = substr(traffic,slashpos+1)

/* Compare new and old data, call update of userfile if necessary */ 
    ip_file1 = datafiles_home'\'ip_address'.total'
    call stream ip_file1, 'command', 'open read'
    dataline_1 = linein(ip_file1)
    dataline_2 = linein(ip_file1)
    call stream ip_file1, 'command', 'close'

    if (dataline_1 = traffic_in) = 0 then do
        call UserfileUpdate
    end
    else do
        if (dataline_2 = traffic_out) = 0 then do
            call UserfileUpdate
        end
    end

/* Write new files */
    call SysFileDelete ip_file1
    call stream ip_file1, 'command', 'open write'
    res=lineout(ip_file1,traffic_in)
    res=lineout(ip_file1,traffic_out)
    call stream ip_file1, 'command', 'close'

end

call stream logfile_clean, 'command', 'close'
call stream tempfile, 'command', 'close'
call SysFileDelete logfile_clean
call SysFileDelete tempfile
say "Done processing files. Hope it worked."
exit

/* =============================================================== */
/* End of first part. Second part deals with updating the userfile */
/* based upon info from part 1 of the program. Cross yer fingers.. */
/* =============================================================== */
  

UserfileUpdate:
    arg n
    call stream userfile, 'command', 'open read'
    call stream tempfile, 'command', 'open write'

    do while lines(userfile) > 0
        dataline_userfile = linein(userfile)
        res=lineout(tempfile,dataline_userfile)
        dataline_userfile = linein(userfile)
        if dataline_userfile = ip_address then do
            res=lineout(tempfile,dataline_userfile)
            res=linein(userfile)
            res=lineout(tempfile,res)
            res=linein(userfile)
            res=lineout(tempfile,res)
            res=linein(userfile)
            res=lineout(tempfile,res)
            old_hours=linein(userfile)
            hours=old_hours+1
            res=lineout(tempfile,hours)
        end
        else do
            res=lineout(tempfile,dataline_userfile)
            res=linein(userfile)
            res=lineout(tempfile,res)
            res=linein(userfile)
            res=lineout(tempfile,res)
            res=linein(userfile)
            res=lineout(tempfile,res)
            res=linein(userfile)
            res=lineout(tempfile,res)
        end
    end
    call stream tempfile, 'command', 'close'
    call stream userfile, 'command', 'close'
    'copy 'tempfile' 'userfile' >nul'
    call SysFileDelete tempfile
    call stream currentusers, 'command', 'open write'
    res=lineout(currentusers,ip_address)
    call stream currentusers, 'command', 'close'
return 
    