/* */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse upper arg type

run_type = 0

if type = "INSTALL" then do
    run_type = 1
end

if type = "CONFIGURE" then do
    run_type = 2
end

if run_type = 0 then do
    say "Missing or invalid parameter encountered."
    say "Type 'setup install' to install this software, or"
    say "type 'setup configure' to re-configure it after installation."
    exit
end

configfile = 'logread.cfg'

say
say "This program will install and/or configure the log reading"
say "system. The following software is required:"
say " - In-Joy version 2.0 with firewall enabled"
say " - Some WEB-server running on the same machine,"
say "   capable of running REXX scripts as cgi-bin's"
say " - Some scheduling program able to run the read_log.cmd"
say "   script at certain intervals"
say
say "MAKE SURE YOU READ THE FILE "README.TXT" PRIOR TO INSTALL OR USE!!"
say
if run_type = 1 then do
    say "You have selected to INSTALL this software for the first time."
    call install
    exit
end
if run_type = 2 then do
    say "You have selected to re-CONFIGURE this software."
    call configure
    exit
end

install:
    say
    say
    say "You will now be asked a few questions about where files are to be placed."
    say "All questions are to be answered with FULLY QUALIFIED path names, but"
    say "WITHOUT trailing backslash ( \ ). All paths must also exist."
    say
    say "Enter the directory containing In-Joy 2.0."
    say "(default: c:\in-joy)"
    pull injoy_home
    if injoy_home = "" then injoy_home = "c:\in-joy"
    say
    say "Enter the full path to where you want to store the base program"
    say "and the HTML files."
    say "(default: "injoy_home"\logread)"
    pull base_home
    if base_home = "" then base_home = injoy_home'\logread'
    say
    say "Enter the directory where you want to store the datafiles."
    say "(default: "injoy_home"\logread\data)"
    pull datafiles_home
    if datafiles_home = "" then datafiles_home = injoy_home'\logread\data'
    say
    say "Enter the full path to the cgi-bin directory of the web server"
    say "running on this machine."
    say "(default: c:\servers\web\cgi-bin)"
    pull cgibin_home
    if cgibin_home = "" then cgibin_home = "c:\servers\web\cgi-bin"
    say
    say
    say "Ok, now we'll start copying files. Just make sure the following"
    say "directories exists already, prior to continuing:"
    say
    say injoy_home
    say base_home
    say datafiles_home
    say cgibin_home
    say
    say "If they do, press ENTER to start copying files, or"
    say "type EXIT and press ENTER to quit now."
    pull continue
    if continue = "EXIT" then exit
    say
    'unzip logread.zip -d 'base_home
    'unzip cgibin.zip -d 'cgibin_home
    say "Do you want to copy a sample users file to the datafile directory?"
    say "Type YES and press enter for yes, anything else (or nothing) for no."
    say "(Note: YES will OVERWRITE any existing userfile in this dir!!)"
    pull copyyesno
    if substr(copyyesno,1,1) = "Y" then do
        'copy sample.usr 'datafiles_home'\users.lst'
    end
    say
    say
    say "All files should be in place now. If anything went wrong, blame"
    say "someone else. Now let's get the last piece of information..."
    say
    say "How many currency units do you wish to charge per time unit?"
    say "Remember to use . as floating point..."
    say "(Read README.TXT to understand this question)"
    pull charge
    if charge = "" then charge = "1"
    say
    say
    say "Ok, now let's write the config file and distribute it to where"
    say "it's needed..."
    say
    call SysFileDelete configfile
    call stream configfile, 'command', 'open write'
    res=lineout(configfile,injoy_home)
    res=lineout(configfile,datafiles_home)
    res=lineout(configfile,charge)
    call stream configfile, 'command', 'close'
    say "Settings saved."
    say
    'copy 'configfile' 'base_home
    'copy 'configfile' 'cgibin_home
    'copy 'configfile' 'cgibin_home'\..\'
    say
    say "All done. If you haven't already, RTFM!! (readme.txt)"
    say "Bye."
    exit
return

configure:
    say
    say
    say "You will now be asked a few questions about where files are to be found."
    say "All questions are to be answered with FULLY QUALIFIED path names, but"
    say "WITHOUT trailing backslash ( \ ). All paths must also exist."
    say
    say "Enter the directory containing In-Joy 2.0."
    say "(default: c:\in-joy)"
    pull injoy_home
    if injoy_home = "" then injoy_home = "c:\in-joy"
    say
    say "Enter the full path to where you stored the base program"
    say "and the HTML files."
    say "(default: "injoy_home"\logread)"
    pull base_home
    if base_home = "" then base_home = injoy_home'\logread'
    say
    say "Enter the directory where you stored the datafiles."
    say "(default: "injoy_home"\logread\data)"
    pull datafiles_home
    if datafiles_home = "" then datafiles_home = injoy_home'\logread\data'
    say
    say "Enter the full path to the cgi-bin directory of the web server"
    say "running on this machine."
    say "(default: c:\servers\web\cgi-bin)"
    pull cgibin_home
    if cgibin_home = "" then cgibin_home = "c:\servers\web\cgi-bin"
    say
    say
    say "How many currency units do you wish to charge per time unit?"
    say "Remember to use . as floating point..."
    say "(Read README.TXT to understand this question)"
    pull charge
    if charge = "" then charge = "1"
    say
    say
    say "Ok, now let's write the config file and distribute it to where"
    say "it's needed..."
    say
    call SysFileDelete configfile
    call stream configfile, 'command', 'open write'
    res=lineout(configfile,injoy_home)
    res=lineout(configfile,datafiles_home)
    res=lineout(configfile,charge)
    call stream configfile, 'command', 'close'
    say "Settings saved."
    say
    'copy 'configfile' 'base_home
    'copy 'configfile' 'cgibin_home
    'copy 'configfile' 'cgibin_home'\..\'
    say
    say "All done. If you haven't already, RTFM!! (readme.txt)"
    say "Bye."
    exit
return


