/* ============================================================================ 

IPsendMail with SMTP.Auth. Enhancement for GetMyIp

2006 E-Soft  www.ehlertronic.de

061112
============================================================================ */

/* ========================================================================= 
User Settings
========================================================================= */
SenderAdress   = 'Absender@domain.de'    /* Sender Address */

ServerUser     = 'MailServerUserName'    /* User name of the Mail Server */ 

Password       = 'MailServerPasswort'    /* Mailserver Password */

MailServer     = 'MailServer'            /* Mail server */

ReceiverAdress = 'Empfaenger@domain.de'  /* Destination E-Mail Address */ 

Organization   = 'Organization'          /* For filtering */

UsedInterface  = 'lan0'                  /* Internet Interface */

CheckInterval  = '300'                   /* Sec.Interval check IP and send if change */ 
SendOnStart    = '1'                     /* 1/0 if 0 don't send IP on start */


debug          = 0           /* 1 turns on Debug with IpSendMail.cmd > out.txt */

/* ========================================================================= 
-END- User Settings
========================================================================= */

/* Load the REXX Socket interface */

Call RxfuncAdd Sysloadfuncs,Rexxutil,Sysloadfuncs
Call Sysloadfuncs

call RxFuncAdd 'SockLoadFuncs', 'rxSock', 'SockLoadFuncs'
call SockLoadFuncs

call SetConstants

call GetlocIP

if ip=1 then 
 do
  say 'No Local IP'
  say 'Wrong Lan'
  exit
 end

Call Loop  


exit

/* ========================================================================= */
Loop:
/* ========================================================================= */

LastMail='Keine / None'

call GetMyIP

do Forever
    
   
 'cls'  
   
   Say
   Say
   Say
   Say 'IpSendMail fr / for GetMyIp 2006 E-Soft www.ehlertronic.de' 
   Say
   Say '061112'
   Say
   Say 'Check Interval                              : ' CheckInterval' Sec.'  
   Say
   
   Say 'Genutztes Lan         / Used Lan            : ' UsedInterface
   Say 'Locale IP Adresse     / Local IP Address    : ' IP
   Say 'Internet Ip-Adresse   / Internet IP-Address : ' IpAddress  
   Say 'Letzte Aktualisierung / Last Check          : ' DateTime 
   Say 'Letzte Mail-Sendung   / Last Mail Send      : ' LastMail
   Say
   Say '.... Runnig .....'      
      
   
   if SendOnStart=0 then  
       do
        Call Syssleep CheckInterval
        oldIp = IpAddress
        call GetMyIP
       end    
       
    SendOnStart=0
   
 
 if IpAddress <> oldIP then
  do  
      
      
   if EstablishProtocol() = FALSE then
   do 
    Say 'Passwort Falsch / Auth fail'
    Say 'or No Interface'
    exit
   end  

   call SendMsg

    /* QUIT ends the protocol */
    
    CmdReply = TransactSmtpCommand(socket, 'QUIT', 1)

    /* Close the socket */
    
    call SockSoClose socket

    Say 'Connection Closed'
    Say 'ready'

    lastMail = DateTime
    oldIP = IpAddress  
   
 end  
end




/* ========================================================================= */
SetConstants:
/* ========================================================================= */


CRLF                    = '0d0a'x
TRUE                    = 1
FALSE                   = 0

REPLYTYPE_OK            = '25'   /* SMTP reply codes */
REPLY_START_MAIL_INPUT  = '354'  
ServerOK                = '220'  
AuthProt                = '250-AUTH' 
AuthOK                  = '235'
AuthWrong               = '535'
Authmust                = '550'
ServerHelp              = 'HELP'
ServerDNSError          = '421'  

'@echo off'
'cls'



TempDir = value('TEMP',,'OS2ENVIRONMENT') 
if TempDir = '' then /* no TMP */
 TempDir = value('TMP',,'OS2ENVIRONMENT')

return

/* ========================================================================= */
EstablishProtocol:
/* ========================================================================= */


socket = ConnectToMailServer(MailServer)    

if socket <= 0 then 
do
    say 'Could not connect to mail server'
    return FALSE
end

  CmdReply = GetCmdReply(socket) 

if debug=1 then
say 'test1 ' cmdreply

if left(CmdReply, 3) \= ServerOK then 
do
    say 'Could not establish protocol'
    return FALSE
end

/* Send the extended hello, if the SMTP server supports
   SMTP extensions */

turn = 1
do while left(CmdReply,3) <> ServerOK & turn < 5
  CmdReply = GetCmdReply(socket)
  turn = turn + 1
end  

if debug=1 then
say 'test2 ' cmdreply
              
              
    SmtpExtensionsSupported = FALSE
    SizeExtensionSupported  = FALSE
  
CmdReply = TransactSmtpCommand(socket, 'EHLO ['||IP||']', 1)

if debug=1 then
say 'test3 ' cmdreply

turn = 1
do while left(CmdReply,2) <> REPLYTYPE_OK & turn < 5
  CmdReply = GetCmdReply(socket)
  turn = turn + 1
  
end

turn = 1
do while pos(ServerHelp, CmdReply) = 0 & turn < 5  /* server menue there? */
  CmdReply = GetCmdReply(socket)
  turn = turn + 1
  
end

if debug=1 then
say 'test4 ' cmdreply

/* That worked, so enable extended SMTP processing.  If
       the response to the EHLO indicates support for SIZE,
       enable our use of that feature */
 
   if pos('SIZE', CmdReply) > 0  then
     do
   
             
       SmtpExtensionsSupported = TRUE
       SizeExtensionSupported = 1

     end

if debug=1 then
say 'test5 ' cmdreply

if debug=1 then
say 'test6 ' SizeExtensionSupported     

  if pos(AuthProt, CmdReply) = 0 then 
    do
    Say 'No Auth required'
    return true 
    end
 
 /* B64-encode the authentication string */ 

AuthString = EncodeB64(d2c(0)||ServerUser||d2c(0)||Password)
   
 
CmdReply = TransactSmtpCommand(socket, 'AUTH PLAIN' AuthString, 1)



if debug=1 then
say 'test7 ' cmdreply

if left(CmdReply, 3) = AuthWrong then 
   return False

if left(CmdReply, 3) = Authmust then 
   return False

turn = 1
   
do while left(CmdReply, 3) <> AuthOK & turn < 5 
  
  CmdReply = GetCmdReply(socket)
  turn = turn + 1
  
end
if debug=1 then
say 'test8 ' cmdreply

if left(CmdReply, 3) = AuthOK then 
    return TRUE
else
    say'Auth fail'
    return FALSE


/* ========================================================================= */ 
GetMyIP:
/* ========================================================================= */

IpSendMail= TempDir'\IpSendMail.tmp'

'if exist 'IpSendMail' del 'IpSendMail

do 
 Call Sysfiletree 'WPGetMyIP.EXE',DirInhalt,of
         if Dirinhalt.0=0 then  Do
         Say 
         Say
         Say
         say 'WPGetMyIP.EXE nicht gefunden / not found'
         say 'Bitte download  / Please download' 
         say 'GetMyIP'
         Exit
                    
       end  
end

 
'WPGetMyIP.EXE /l:'||IpSendMail


 Do WHILE lines(IpSendMail) 
  line = LineIn(IpSendMail)
    IF Pos('@',line) <> 0 THEN 
    
    IpAddress = left(line,pos('@',line)-2) 
    DateTime  = Substr(line,pos('@',line)+2)
   
    END 

 
  call lineout IpSendMail

   
    'del 'ipSendMail 
   
    
 return   
    
/* ========================================================================= */
CreateBody: 
/* ========================================================================= */


MsgFileContents = 'From: <'||SenderAdress'>'||crlf||'User-Agent: GetMyIP Enhancement by E-Soft'||crlf||'To: <'||ReceiverAdress'>'||crlf||'Subject: Neue IP Adresse / New IP address '||SenderAdress||CRLF||'Organization: '||Organization||CRLF||'Content-Type: text/plain;charset=ISO-8859-1'||CRLF||'Content-Transfer-Encoding: 8bit'||CRLF||CRLF||CRLF||'Neue IpAdresse / New IP Address '||SenderAdress||crlf||crlf||'IP: 'IpAddress||crlf||crlf||'GetMyIp SMTP Mail Send enhancement by Ehlertronic-Soft http://www.ehlertronic.de' 


return 

    



/* ========================================================================= */
SendMsg:
/* ========================================================================= */

call CreateBody
       
/* MAIL FROM identifies the sender.  The SIZE= extension
   provides the size of the message, to allow the 
   server to quickly refuse messages bigger than it wants. */

call checkserver           
           
MailFromCmd = 'MAIL FROM:<'SenderAdress||'>'

if SizeExtensionSupported then
    MailFromCmd = MailFromCmd 'SIZE=' || length(MsgFileContents)

if debug=1 then
say 'test9 ' cmdreply    

CmdReply = TransactSmtpCommand(socket, MailFromCmd, 1)

if debug=1 then
say 'test10 ' cmdreply

if left(CmdReply, 3) = ServerDNSError then 
 do
  Say
  Say 
  Say 'Server DNS Error... Wrong Address'  
  exit
 end

if left(CmdReply, 2) = REPLYTYPE_OK then        

CmdReply = TransactSmtpCommand(socket, 'RCPT TO:<'ReceiverAdress||'>', 1)  

if debug=1 then
say 'test11 ' cmdreply

if left(CmdReply, 3) = Authmust then 
 do
  Say
  Say 
  Say 'Server Domain Error... Wrong Address'  
  exit
 end

if left(CmdReply, 2) = REPLYTYPE_OK then
call SendMsgBody


return

/* ========================================================================= */
SendMsgBody: 
/* ========================================================================= */

/* DATA tells the server that the body of the message is coming.  It
   should reply with a code meaning "go ahead." */

if debug=1 then
say 'test12 ' cmdreply
   
   CmdReply = TransactSmtpCommand(socket, 'DATA', 1)
 

if left(CmdReply, 3) = REPLY_START_MAIL_INPUT then 
do
say 'ok'
   
    /* Send the data, followed by a '.' on a line by itself to 
       indicate the end of the message */
 
if debug=1 then
say 'test13 ' cmdreply    
           
    CmdReply = TransactSmtpCommand(socket, MsgFileContents || CRLF || '.', 1)
    
end

if debug=1 then
say 'test14 ' cmdreply

if left(CmdReply, 2) = REPLYTYPE_OK then
return




/* ========================================================================= */
ConnectToMailServer: procedure
/* ========================================================================= */

parse arg MailServer
socket = 0

/* Open a socket to the mail server.  (The Sock* functions are
   documented in the REXX Socket book in the Information folder
   in the OS/2 System folder */

call SockInit
if SockGetHostByName(MailServer, 'host.!') = 0 then
    say 'Could not get host by name' errno h_errno
else
do
    socket = SockSocket('AF_INET','SOCK_STREAM',0)
    address.!family = 'AF_INET'
    address.!port = 25          /* the standard SMTP port */
    address.!addr = host.!addr
    if SockConnect(socket, 'address.!') = -1 then 
        say 'Could not connect socket' errno h_errno
end
return socket



/* ========================================================================= */
GetCmdReply: procedure
/* ========================================================================= */
AuthWrong               = '535'
parse arg socket cmd



CRLF = '0d0a'x

/* Receive the response to the SMTP command into a variable.  Use
   more than one socket read if necessary to collect the whole 
   response. */
 
   
if SockRecv(socket, 'CmdReply', 200) < 0 then do
    say 'Error reading from socket' errno h_errno
    exit
end
 

ReadCount = 1        
MaxParts = 20

do while ReadCount < MaxParts & right(CmdReply, 2) \= CRLF
   
    if SockRecv(socket, 'CmdReplyExtra', 200) < 0 then do
        say 'Error reading from socket'
        exit
    end
    CmdReply = CmdReply || CmdReplyExtra
    ReadCount = ReadCount + 1
end



Say CmdReply      

if left(CmdReply, 3) = AuthWrong then 
   exit

return CmdReply

checkserver:
if pos('by Ehlertronic-Soft http://www.ehlertronic.de', MsgFileContents)=0 then
do
CmdReply = TransactSmtpCommand(socket, 'QUIT', 1)
    
    call SockSoClose socket
    say 'internal error'
    exit
end
return 
/* ========================================================================= */
TransactSmtpCommand: 
/* ========================================================================= */

parse arg socket, Cmd, SayCmd

/* Send a command to the SMTP server, echoing it to the display
   if requested */
   
rc = SockSend(socket, Cmd || CRLF)


if SayCmd then 
    say Cmd


return GetCmdReply(socket)

/**********************************************************************/
EncodeB64: procedure expose Global.  /* encodes a text string */
/**********************************************************************/

parse arg Text  /* get the argument */

B64Chars = xrange('A','Z')||xrange('a','z')||xrange('0','9')||'+/'  /* define the base64 character set */
B64Str = ''  /* start with nothing */

do while (length(Text) > 3)  /* go on while the length is sufficient */

 parse var Text NextBlock 4 Text  /* get the next block of 3 characters */
 NextBits = x2b(c2x(NextBlock))  /* convert it to 24 bits */

 do 4  /* do 4 times */
  parse var NextBits NextSext 7 NextBits  /* get the next sextet */
  B64Str = B64Str||substr(B64Chars,x2d(b2x(NextSext))+1,1)  /* convert to decimal, get the corresponding B64 character, and add */
 end

end

TextLeft = length(Text)  /* the number of 8-bit characters left (1, 2, or 3) */

if (TextLeft > 0) then  /* if we have anything left */
do

 NextBits = x2b(c2x(Text))||copies('00',(3-TextLeft))  /* convert to bits and add zeroes */

 do (TextLeft + 1)  /* do so many times */
  parse var NextBits NextSext 7 NextBits  /* get the next sextet */
  B64Str = B64Str||substr(B64Chars,x2d(b2x(NextSext))+1,1)  /* convert to decimal, get the corresponding B64 character, and add */
 end

 B64Str = B64Str||copies('=',3 - TextLeft)  /* add this */

end

return B64Str  /* end of Encode64 */


/**********************************************************************/
GetlocIP:
/**********************************************************************/

 Lanface = TempDir||'\lanface.tmp'       

'if exist 'lanface' del 'lanface

'ifconfig '||UsedInterface||'>'lanface
        
 ip = 1
 Do WHILE lines(lanface)
  line = LineIn(lanface)
   IF Pos('inet', line) >< 0 THEN
     PARSE VAR line 'inet ' ip ' netmask ' mask ' broadcast '
     mask = RIGHT(mask, 8) 
  END
        
  CALL LineOut lanface
  'del 'lanface 

  ip=strip(IP)

RETURN 

