/*---------------------------------------------------------------------------*\
|   Get Lan Server Token Ring Route info      (C) Alain Rykaert - APR98-MAY98 |
\*---------------------------------------------------------------------------*/
    Version = '1.03'
    Say '* GETROUTE Version' Version

    Call Init                                 /* init dll's and other stuff*/

 /*====================================*/
    OutFileName = 'GETROUTE.CSV'                /* Output file with results*/
 /*====================================*/

    Say '* Output FileName:' OutFileName

    Parse Upper Arg DCName MacAddress

    If DCName = '' | MacAddress = ''
      Then Do
             Say '*'
             Say '* Get LAN Server Token Ring Routing Information'
             Say '*'
             Say '* Usage: GETROUTE {DCName} {Destination Address}'
             Say '*'
             Say '* Sample: GETROUTE \\BEDDC01 400013203745'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName

    Call OS2Ping MacAddress          /* check if reference adapter is found*/
    If MCheck = 1
      Then Nop
      Else Do
             Say '! Destination Address' MacAddress 'not found'
             Exit
           End

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Call Logit Copies('-', 60)
               Call Logit '* ServerName:' Counter ServerName.i
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0
                 Then Do
                        Call GetInfo ServerName.i
                     /* Call SysSleep 2 */
                      End
                 Else Say '> Not found'
             End
             Call Logit Copies('-', 60)
           End
      Else Say '! Error' RC

    Exit

 GETINFO:/* -----------------------------------------------------------------*/
trace all
    Parse Arg ServerName

   'net admin \\'ServerName '/c set >' TempFile
    Call Stream  TempFile, 'C', 'Close'

    Call SysFileSearch 'COMSPEC=', TempFile, 'Stem'
    If Stem.0 = 1
      Then Parse Value Stem.1 With . '=' ServerBootDrive ':' .
      Else Do
             Say '! Error: COMPSPEC not found' '07'x
             Return
           End

    IniFileName = '\\'ServerName'\'ServerBootDrive'$\ibmcom\protocol.ini'
    If Trace Then Say IniFileName

    If Stream( IniFileName, 'C', 'Query Exists') <> ''
      Then Do
             l = 0
             s = 0
             Do While Lines(IniFileName)
               LLine = LineIn(IniFileName)
               If LLine = ''
                 Then Nop
                 Else Do
                        l = l + 1
                        LLine = Translate(LLine)
                        If Left(Strip(LLine),1) = '['
                          Then Do
                                 s = s + 1
                                 Section.s = LLine          /* section name*/
                                 Section.s.0 = l
                                 l = 0
                               End
                          Else Nop
                        LLine.s.l = Strip(LLine)    /* lines into a section*/
                     /* Say s l LLine.s.l */
                        Section.0 = s
                        LLine.s.0 = l
                      End
             End
             Say Section.0
          /* Do x = 1 to Section.0
               Parse Value Section.x With '[' NicName '_' .
               If NicName = 'IBMTOK'   |,
                  NicName = 'IBMMPC'   |,
                  NicName = 'IBMTRPO2' |,
                  NicName = 'IBMTRBM'  |,
                  NicName = 'IBMTRDB'  |,
                  NicName = 'IBM16OS2'
                 Then Do y = 1 to LLine.x.0
                        Parse Value LLine.x.y With Begin '= "' Address '"' .
                        If Begin = 'NETADDRESS'
                          Then Do
                                 Route = ''
                            /*  'os2ping /a='Address '/w=1 /r >' TempFile '2>nul'
                                 Call SysFileSearch '->', TempFile, 'Stem'
                                 If Stem.0 > 0
                                   Then Do z = 1 to Stem.0
                                          Route = Stem.z Route
                                        End
                                   Else Nop */
                                 Text = ' ' Left(NicName, 8) '-' Address Route
                                 Call Logit Text
                               End
                          Else Nop
                      End
                 Else Nop
             End */
           End
      Else Say '! Error: file' IniFileName 'not found'
trace off
    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd RxLoadFuncs, RXUTILS, RxLoadFuncs
             Call RxLoadFuncs
           End
      Else Nop

    TempFile = LSRDrive'\ibmlan\getroute.tmp'             /* Temporary file*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    Say OutFileName Log_Text
 Return
    If LineOut(OutFileName, Log_Text) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing' OutFileName '07'x

    Return

 OS2PING:/* ----------------------------------------------------------------*/

    Parse Arg Address

   '@os2ping /a='Address '/r /w=1 2>nul | Find "(" >' TempFile
    If RC = 0                          /* MAC not found                    */
      Then Do
             MCheck = 0
             Route = LineIn(TempFile)
             Call Stream TempFile, 'C', 'Close'
           End
      Else MCheck = 1

    Return

