/*---------------------------------------------------------------------------*\
|   GET all USERS from a LAN Server 3.0 and higher                            |
|   and dump it to an ASCII File                                              |
|                                   (C) Alain Rykaert IBM-Belgium SEP95-MAY96 |
|                                                                 FEB2000     |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    MaxLines = 9999            /* Number of Lines to separate with a header*/

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call ChkOpt                          /* Check Options & display Welcome*/
    Call ChkPws                               /* Check the PWS & Admin name*/
    Call Columns                        /* Read the Columns definition file*/
    Call Main                                            /* do the main job*/
    Call Quit                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' OUTF 'del' OUTF

 /* RC = NetEnumerate(280, 'USERID', '\\'SRVNAME) */
    RC = WfrxUserEnum('\\'SrvName,'UserID')
    If RC = 0
      Then Do
             Call RxStemSort 'UserID'
             Call LineOut OutF, Banner
             Do i = 1 to UserID.0
               If i // MaxLines = 0
                 Then Call LineOut OutF, Banner
                 Else Nop
               If \MUTE
                 Then Do
                        Call SysCurState Off
                        Call SysCurPos 20,0
                      End
                 Else Nop
               Say '0909'x ESC'[K Total Users =' i'/'UserID.0 UserID.i
               RC = NetGetInfo(280, 'UserInfo', '\\'SrvName, UserID.i)
               If RC = 0
                 Then Call Writeit
                 Else Call Logit 'Get NetGetInfo', UserID.i, RC
             End
           End
      Else Do
            Call LOGIT 'Get Users', SRVNAME, RC
            Call QUIT
          End

    If \Mute Then Say '0909'x ' Total Time  =' Trunc(Time('E'),2)

    Call Stream OutF, 'C', 'Close'

    Call SysSetObjectData OutF, 'ICONFILE='Directory()'\Users.Ico'

    Return

 WRITEIT:/* --------------------------------------------------- WRITEIT: ----*/

    USERINFO.OPT      = Left('',COLL.1,' ')       /* Column 1 must be BLANK*/
    USERINFO.PASSWORD = Left('****', COLL.3, ' ')

    OUT = ''
    do j = 1 to COLT
       COLNAME = COLN.j
       DATA.j = Left(USERINFO.COLNAME, COLL.j, ' ')
       OUT = OUT || DATA.j || ';'
    end
    Call LineOut OUTF, OUT
    Call Stream  OUTF, 'C', 'CLOSE'
    Return

 COLUMNS:/* --------------------------------------------------- COLUMNS: ----*/

    BANNER = ''
    i = 0
    do while Lines(COLF)
       LLINE = LineIn(COLF)
       if Left(LLINE, 1) = '*',
        | Strip(LLINE) = ''
        then iterate
        else Nop
       i = i + 1
       parse value LLINE with COLN ';' COLL
       COLN.i = Strip(COLN)
       COLL.i = Strip(COLL)
       BANNER = BANNER || Left(COLN.i, COLL.i, ' ') || ';'
    end
    COLT = i
    Call Stream COLF, 'C', 'CLOSE'

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = ''
    OUTF    = 'USERS.CSV'
    LOGF    = 'LSMT.LOG'
    PIPE    = ''
    TRACE   = 0
    MUTE    = 0

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:'  then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/OUT:'  then OUTF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:'  then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:'  then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'     then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'     then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1='GETWELCOME'
             Topic_String.Topic1.1=SRVNAME;
             Topic_String.Topic1.2=OUTF;
             Topic_String.Topic1.3=LOGF;
             Topic_String.Topic1.4=PIPE' ';
             Topic_List='WELCOMELOGO' Topic1 'GETUSERS';
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; '@Pause';
             Call SysCurPos Old_R, Old_C; say ESC'[K';
          end
     else do
             say 'ServerName =' SRVNAME
             say 'OutputFile =' OUTF
             say 'LogFile    =' LOGF
          end

    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/M'                                    /* Rexx Utilities*/
    Call RgUtils  '/M'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/M'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    Esc   = '1B'x
    Redir = '>NUL 2>NUL'

    COLF  = 'USERS.INI'                          /* Column description file*/
    Call CHKFILE COLF

    Resource_File = 'LSMT.RSC'                 /* Ansi Topics Resource File*/
    Call CHKFILE Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(Resource_File Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
       Call SysCurPos Row, Column
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
       End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1 = 'GETHELP'
             Topic_String.Topic1.1 = PRGN;
             Topic_List = Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg File

    If Stream(File, 'C', 'Query Exists') = ''
      Then Do
             say ' File' File 'not found.'
             Call Quit
           End
      Else Nop
    Call Stream File, 'C', 'Close'

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   COLF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   OUTF,      'C', 'CLOSE'

    Exit

 /*--------------------------------------------------------------------------*/
