/*---------------------------------------------------------------------------*\
|  INSTALL - Create the necessary object on the WorkPlaceShell                |
|                                             (C) Alain Rykaert - JAN96-MAR99 |
\*---------------------------------------------------------------------------*/
    Version = '2.33'
    Say '* Install Version:' Version

    Call Init                    /* Initialisation of DLL's and other stuff*/

    Call MakeObjects              /* Make LSMT Folder on the WorkPlaceShell*/

    Say '* Done.'
    Say '  Go to the Folder created on the desktop called:'
    Say ' "Lan Server Management Tools"'

    Exit

 INIT:/* --------------------------------------------------------------------*/

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    REDIR = '>nul 2>nul'
   '@echo off'

    Return

 MAKEOBJECTS:/* -------------------------------------------------------------*/

    Call SysDestroyObject '<LSMT_FOLDER>' /* delete previous version folder*/

    Class    = 'WPFolder'
    Title    = 'Lan Server^Management Tools'
    Location = '<WP_DESKTOP>'
    Setup    = 'OBJECTID=<LSMT_MAIN_FOLDER>;'                               ||,
               'ICONVIEW=FLOWED;'                                           ||,
               'ICONVIEWPOS=20,5,50,70;'                                    ||,
               'ICONFILE='Directory()'\LSMT.ICO;'                           ||,
               'ALWAYSSORT=YES;'                                            ||,
               'OPEN=DEFAULT;'                                              ||,
               'BACKGROUND='Directory()'\LSMT.BMP,S,1'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPFolder'
    Title    = 'Domain Definitions'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_DCDB>;'                                      ||,
               'ICONVIEW=FLOWED;'                                           ||,
               'ICONVIEWPOS=40,20,55,65;'                                   ||,
               'ICONFONT=10.System VIO;'                                    ||,
               'ICONFILE='Directory()'\WIZARD.ico;'                         ||,
               'ALWAYSSORT=YES;'                                            ||,
               'BACKGROUND=(none),,,C,200 255 255'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Create Domain Object'
    Location = '<LSMT_DCDB>'
    Setup    = 'OBJECTID=<LSMT_DCDB_QUERY>;'                                ||,
               'EXENAME='Directory()'\Q_DCDB.Cmd;'                          ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\db2.ico;'                            ||,
               'PARAMETERS=/SRV:[Enter the name of a PR-DC]'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPFolder'
    Title    = 'Domain Servers'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_SERVERS>;'                                   ||,
               'ICONVIEW=FLOWED;'                                           ||,
               'ICONVIEWPOS=40,20,55,65;'                                   ||,
               'ICONFONT=10.System VIO;'                                    ||,
               'ICONFILE='Directory()'\mis228.ico;'                         ||,
               'ALWAYSSORT=YES;'                                            ||,
               'BACKGROUND=(none),,,C,255 255 200'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Create Domain Object'
    Location = '<LSMT_SERVERS>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_QUERY>;'                             ||,
               'EXENAME='Directory()'\QSRVRS.Cmd;'                          ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\db2.ico;'                            ||,
               'PARAMETERS=[Enter the name of a PR-DC]'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LSMT Documentation'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_DOC>;'                                       ||,
               'EXENAME='Directory()'\T2.exe;'                              ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\view.ico;'                           ||,
               'PARAMETERS='Directory()'\lsmt.txt'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Get from DC'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_GETCMD>;'                                    ||,
               'EXENAME='Directory()'\GetCmd.cmd;'                          ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\getcmd.ico;'                         ||,
               'NOTVISIBLE=Yes;'                                            ||,
               'PARAMETERS=/M [Enter the Name of the PR-DC] %*'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Set to DC'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_SETCMD>;'                                    ||,
               'EXENAME='Directory()'\setcmd.cmd;'                          ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\SetCmd.ico;'                         ||,
               'NOTVISIBLE=Yes;'                                            ||,
               'PARAMETERS=/M [Enter the Name of the PR-DC] %*'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Get All definitions'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_GETALL>;'                                    ||,
               'EXENAME='Directory()'\GetAll.cmd;'                          ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\Brick.ico;'                          ||,
               'NOTVISIBLE=Yes;'                                            ||,
               'PARAMETERS=/M /SRV:[Enter the Name of the PR-DC]'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*T2 Editor'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_T2>;'                                        ||,
               'EXENAME='Directory()'\t2.exe;'                              ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\t2.ico;'                             ||,
               'NOTVISIBLE=Yes'
    Update   = 'Update'
    Call CreateObj

 /* TOOLS */

    Class    = 'WPFolder'
    Title    = 'Tools'
    Location = '<LSMT_MAIN_FOLDER>'
    Setup    = 'OBJECTID=<LSMT_TOOLS>;'                                     ||,
               'ICONVIEW=FLOWED;'                                           ||,
               'ICONVIEWPOS=40,20,55,65;'                                   ||,
               'ICONFONT=10.System VIO;'                                    ||,
               'ICONFILE='Directory()'\sysconfg.ico'                        ||,
               'ALWAYSSORT=YES'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'MoveStuf'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_MOVESTUF>;'                                  ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\movestuf.exe'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'NetPM'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_NETPM>;'                                     ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\netpm.exe;'                           ||,
               'STARTUPDIR='Directory()
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LAN Server Audit'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LSAUDIT>;'                                   ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\lsaudit.exe;'                         ||,
               'STARTUPDIR='Directory()
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LAN Server Error'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LSERROR>;'                                   ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\lserror.exe;'                         ||,
               'STARTUPDIR='Directory()
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'License Track Utility'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LTU>;'                                       ||,
               'PROGTYPE=PM;'                                               ||,
               'EXENAME='Directory()'\ltu.exe;'                             ||,
               'STARTUPDIR='Directory()
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LSC^Lan Server Check'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LSC>;'                                       ||,
               'EXENAME='Directory()'\lsc.cmd;'                             ||,
               'PARAMETERS=[Enter a Server Name] %* & Pause;'               ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\watson.ico;'                         ||,
               'NOTVISIBLE=No;'                                             ||,
               'NOAUTOCLOSE=No'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LSDCDB^Check Domain Controller DataBase'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LSDCDB>;'                                    ||,
               'EXENAME='Directory()'\lsdcdb.cmd;'                          ||,
               'PARAMETERS=[Enter the Name of the PR-DC] %* & Pause;'       ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\lsdcdb.ico;'                         ||,
               'NOTVISIBLE=No;'                                             ||,
               'NOAUTOCLOSE=No'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'LSHOME^Check Home Directories'
    Location = '<LSMT_TOOLS>'
    Setup    = 'OBJECTID=<LSMT_LSHOME>;'                                        ||,
               'EXENAME='Directory()'\lshome.cmd;'                          ||,
               'PARAMETERS=[Enter the Name of the PR-DC] %* & Pause;'       ||,
               'PROGTYPE=windowableVIO;'                                    ||,
               'ICONFILE='Directory()'\lshome.ico;'                         ||,
               'NOTVISIBLE=No;'                                             ||,
               'NOAUTOCLOSE=No'
    Update   = 'Update'
    Call CreateObj

    Return

 CREATEOBJ:/* ---------------------------------------------------------------*/

    Say '> Creating ...' Title

    RC = SysCreateObject(Class, Title, Location, Setup, Update)
    If RC <> 1
      Then '! Error while creating object, ReturnCode:' RC
      Else Do
             Parse Value Setup With . 'OBJECTID=' ObjectID ';' .
             If Left(ObjectID,1) = '<' & Right(ObjectID,1) = '>'
               Then Call SysSetObjectData ObjectID, 'Title=' || Title
               Else Nop
           End

    Return

