/*---------------------------------------------------------------------------*\
|   Lan Server assignments to NT server       (C) Alain Rykaert - MAY98-JUN98 |
|                                                                             |
|     Return Codes: 0 - ok                                                    |
|                   1 - file not found                                        |
|                   2 - copy error                                            |
|                   3 - create dir error                                      |
|                   4 - init error                                            |
|                   5 - write error                                           |
|                   6 - syntax error                                          |
\*---------------------------------------------------------------------------*/
    Version = '1.01'
    Say '* LS2NT Version' Version 'running at' Date('E') Time()


 /*====================================*/
    OutDirName = '\\dc01\netlogon'                      /* Output Directory*/
    OutDirName = 'x:\netlogon'                          /* Output Directory*/
 /*====================================*/

    Say '* Output Directory Name:' OutDirName

    Parse Upper Arg DCName Option

    Call Init                                 /* init dll's and other stuff*/

    If DCName = ''
      Then Do
             Say '*'
             Say '* Lan Server to NT Logon Assignments'
             Say '*'
             Say '* Usage: LS2NT {DCName} {/T]'
             Say '*'
             Say '* Sample: GETSW \\BEDDC01'
             Say '*'
             Exit 6
           End
      Else Nop

    If DCName = '*'
      Then Do
             RC = NetGetInfo(350, 'WkstaInfo','')
             If RC = 0
               Then DCName = WkstaInfo.ComputerName
               Else Exit 4
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    If Trace Then Say '* Server Name:' '\\'DCName

    Call Time('R')                                       /* Reset the timer*/

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0 |,
                WordPos('Backup', ServerRole) > 0
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit 4
                    End
           End
      Else Do
             Say '! Error:' RC
             Exit 4
           End

    If Trace Then Say '* Getting all Aliases'

    RC = NetEnumerate(20, 'Alias', '\\'DCName)
    If RC = 0
      Then Do
             If Trace Then Say '> Total number of aliases:' Alias.0
             Call RxStemSort 'Alias'
             AllAliases = ''
             Do i = 1 To Alias.0
               AllAliases = AllAliases Alias.i
               Call NetGetInfo 20, 'AliasInfo', '\\'DCName, Alias.i
               Alias.i.1 = Translate(AliasInfo.Server)
               Alias.i.2 = Translate(AliasInfo.Netname)
             End
           End
      Else Do
             Say '! Error:' RC
             Exit 4
           End

    If Trace Then Say '* Getting all users'

    RC = NetEnumerate(280, 'UserID', '\\'DCName)
    If RC = 0
      Then Do
             If Trace Then Say '> Total number of users:' UserID.0
             Call RxStemSort 'UserID'
             If Trace Then Say '* Get all users with a logon assignment'
             Do i = 1 to UserID.0
               If Trace Then Say Copies('*', 60)
               Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
               If Trace Then Say '> UserID:' Counter UserID.i
               RC = NetGetInfo(52, 'LogonAsnInfo', '\\'DCName, UseriD.i)
               If RC = 0 & LogonAsnInfo.Count > 0
                 Then Do
                        UserFileName = OutDirName'\'UserID.i'.CMD'
                       'if exist' UserFileName 'del' UserFileName
                        Call Logit UserFileName ' @ECHO OFF'

                        Call NetGetInfo 280, 'UserInfo', '\\'DCName, UserID.i
                        If UserInfo.Home_Dir = '-none-'
                          Then Nop
                          Else Do
                                 Parse Value UserInfo.Home_Dir With DriveLetter '\' HSName '\' Resource
                                 HSName = Strip(HSName,'L','\')
                                 Text = ' NET USE' DriveLetter '\\'HSName'\'Resource
                                 Call Logit UserFileName Text
                               End

                        Do j = 1 to LogonAsnInfo.Count
                          x = WordPos(LogonAsnInfo.j.Alias, AllAliases)
                          If Length(LogonAsnInfo.j.Device) = 1
                            Then Device.j = Translate(LogonAsnInfo.j.Device) || ':'
                            Else Device.j = Translate(LogonAsnInfo.j.Device)
                          Server.j = Alias.x.1
                          NetName.j = Alias.x.2
                          Text = ' NET USE' Device.j '\\'Server.j'\'NetName.j
                          Call Logit UserFileName Text
                        End
                      End
                 Else Nop
             End
           End
      Else Do
             Say '! Error:' RC
             Exit 4
           End

    Say '* LS2NT Ended:' Trunc(Time('E'),2)

    Exit 0

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Option <> '/T'                          /* if trace option specified*/
      Then Do
             Trace = 0
             Redir = '>nul 2>nul'
           End
      Else Do
             Trace = 1
             Redir = '>con 2>con'
           End

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit 4
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd RxLoadFuncs, RXUTILS, RxLoadFuncs
             Call RxLoadFuncs
           End
      Else Nop

    TempFile = LSRDrive'\ibmlan\ls2nt.tmp'                /* Temporary file*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit 1
           End
      Else Nop

    Return

 LOGIT:/* - -----------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If Trace Then Say ' ' OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Do
             Say '! Error while writing:' OutFileName '07'x
             Exit 5
           End

    Return

