/*---------------------------------------------------------------------------*\
|   Lan Server Browser                        (C) Alain Rykaert - APR95-DEC99 |
\*---------------------------------------------------------------------------*/
    Version = '2.07a (C) AR - JAN01'
    Say '* LSBROWSE Version' Version

    Call Init                                 /* init dll's and other stuff*/
    Signal On Halt Name Quit

    Parse Upper Arg DCName OutFileName

    If DCName = '' | OutFileName = ''
      Then Do
             Say '*'
             Say '* Browse LAN Server parameters'
             Say '*'
             Say '* Usage: LSBROWSE {DCName} {OutputFileName}'
             Say '*'
             Say '* Sample: LSBROWSE \\BEDDC01 LSBROWSE.CSV'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName
    Say '* Output FileName:' OutFileName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             OutText = '***' Date() Time() '*** LSBROWSE Version:' Version
             Call Logit OutFileName OutText
             Call Logit OutFileName ' '
             OutText = "SERVER  "            ';',
                       "TIME "               ';',
                       "ROLE"                ';',
                       "NET.ACC"             ';',
                       "ACTTIME            " ';',
                       "BALANCE"             ';',
                       "CACHE "              ';',
                       "UAM"                 ';',
                       "HEAP "               ';',
                       "NET1  "              ';',
                       "NET2  "              ';',
                       "NET3  "              ';',
                       "NET4  "              ';',
                       "NET5  "              ';',
                       "DISC"                ';',
                       "MAXUSERS"            ';',
                       "MAXCONN"             ';',
                       "MAXSHARES"           ';'

             Call Logit OutFileName OutText

             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Call Charout 'con', '* ServerName:' Counter ServerName.i
               OutText = Left(ServerName.i,9) || ';'
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0
                 Then Do
                        Call GetInfo ServerName.i
                        Say ''
                      End
                 Else Say '09'x '> not found'
               Call Logit OutFileName OutText
             End
           End
      Else Say RC

    Exit

 GETINFO:/* ----------------------------------------------------------------*/

    Parse Arg ServerName

 /* get server role from previous api*/
    ServerRole = Translate(Left(ServerModalInfo.Role,4))

    Balance = ''                                  /* Auto balance from MPTS*/

    Call Time('R')                                       /* Reset the timer*/

   'net admin \\'ServerName '/c set >' TempFile
    Call Stream TempFile, 'C', 'Close'

    Call SysFileSearch 'COMSPEC=', TempFile, 'Stem'
    If Stem.0 = 1
      Then Do
             Parse Value Stem.1 With . '=' ServerBootDrive ':' .
             If Trace Then Say '> Boot Drive:' ServerBootDrive
           End
      Else Do
             Say '! Error: could not determine the Bootdrive'
             Return
           End

 /* Get NET.ACC size */
    NetAccSize = Stream('\\'ServerName'\ibmlan$\Accounts\net.acc', 'C', 'Query Size')
    If Trace Then Say '> NetAccSize:' NetAccSize

 /* Get Time */
    RC = NetMisc(700, 'VarRet', '\\'ServerName)
    ActTime = ' ' ||,
              VarRet.Tod_Year  || '-' ||,
              VarRet.Tod_Month || '-' ||,
              VarRet.Tod_Day,
              VarRet.Tod_Hours || ':' ||,
              Right(VarRet.Tod_Mins,2,'0') || ':' ||,
              Right(VarRet.Tod_Secs,2,'0')
    If Trace Then Say '> ActTime:' ActTime

 /* Get HPFS386 Info */

    UseAllMem = '   '
    Cache     = '     '
    Heap      = '     '

    If SysFileSearch('useallmem', '\\'ServerName'\'ServerBootDrive'$\ibm386fs\hpfs386.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else UseAllMem = Strip(End)
             If Trace Then Say '> UseAllMem:' UseAllMem
           End
      Else Nop

    If SysFileSearch('cachesize', '\\'ServerName'\'ServerBootDrive'$\ibm386fs\hpfs386.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else Cache = Strip(End)
             If Trace Then Say '> Cache:' Cache
           End
      Else Nop

    If SysFileSearch('maxheap', '\\'ServerName'\'ServerBootDrive'$\ibm386fs\hpfs386.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else Heap = Strip(End)
             If Trace Then Say '> Heap:' Heap
           End
      Else Nop

 /* Get LAN Server Info */

    NET1 = '     '
    NET2 = '     '
    NET3 = '     '
    NET4 = '     '
    NET5 = '     '

    If SysFileSearch('NET1 =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' Stack '$,' NIC ',' . ',' Sessions ',' .
             If Left(Strip(Begin),1) <> ';'
               Then Do
                      If Left(Stack,2) = ' N'
                        Then Stack = 'NB'
                        Else Stack = 'TP'
                      NET1 = NIC || Stack || Right(Sessions,3,'0')
                      If Trace Then Say '> Net1:' Net1
                    End
               Else Nop
           End
      Else Nop

    If SysFileSearch('NET2 =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' Stack '$,' NIC ',' . ',' Sessions ',' .
             If Left(Strip(Begin),1) <> ';'
               Then Do
                      If Left(Stack,2) = ' N'
                        Then Stack = 'NB'
                        Else Stack = 'TP'
                      NET2 = NIC || Stack || Right(Sessions,3,'0')
                      If Trace Then Say '> Net2:' Net2
                    End
               Else Nop
           End
      Else Nop

    If SysFileSearch('NET3 =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' Stack '$,' NIC ',' . ',' Sessions ',' .
             If Left(Strip(Begin),1) <> ';'
               Then Do
                      If Left(Stack,2) = ' N'
                        Then Stack = 'NB'
                        Else Stack = 'TP'
                      NET3 = NIC || Stack || Right(Sessions,3,'0')
                      If Trace Then Say '> Net3:' Net3
                    End
               Else Nop
           End
      Else Nop

    If SysFileSearch('NET4 =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' Stack '$,' NIC ',' . ',' Sessions ',' .
             If Left(Strip(Begin),1) <> ';'
               Then Do
                      If Left(Stack,2) = ' N'
                        Then Stack = 'NB'
                        Else Stack = 'TP'
                      NET4 = NIC || Stack || Right(Sessions,3,'0')
                      If Trace Then Say '> Net4:' Net4
                    End
               Else Nop
           End
      Else Nop

    If SysFileSearch('NET5 =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Upper Value Stem.j With Begin '=' Stack '$,' NIC ',' . ',' Sessions ',' .
             If Left(Strip(Begin),1) <> ';'
               Then Do
                      If Left(Stack,2) = ' N'
                        Then Stack = 'NB'
                        Else Stack = 'TP'
                      NET5 = NIC || Stack || Right(Sessions,3,'0')
                      If Trace Then Say '> Net5:' Net5
                    End
               Else Nop
           End
      Else Nop

    If SysFileSearch('AUTODISCONNECT =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else AutoDisc = Strip(End)
             If Trace Then Say '> AutoDisc:' AutoDisc
           End
      Else Nop

    If SysFileSearch('MAXUSERS =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else MaxUsers = Strip(End)
             If Trace Then Say '> MaxUsers:' MaxUsers
           End
      Else Nop

    If SysFileSearch('MAXCONNECTIONS =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else MaxConn = Strip(End)
             If Trace Then Say '> MaxConn:' MaxConn
           End
      Else Nop

    If SysFileSearch('MAXSHARES =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else MaxShares = Strip(End)
             If Trace Then Say '> MaxShares:' MaxShares
           End
      Else Nop

 /* Get MPTS Balance parameter */

    If SysFileSearch('BALANCE', '\\'ServerName'\'ServerBootDrive'$\ibmcom\protocol.ini', 'Stem') = 0
      Then Do j = 1 to Stem.0
             Parse Value Stem.j With Begin '=' End
             If Left(Strip(Begin),1) = ';'
               Then Nop
               Else Balance = Strip(End)
             If Trace Then Say '> Balance:' Balance
           End
      Else Nop

    OutText = OutText Right(Trunc(Time('E'),2),5) ';' ||,
                      Right(ServerRole,5)         ';' ||,
                      Right(NetAccSize,8)         ';' ||,
                      Left(ActTime,20)            ';' ||,
                      Center(Balance,8)           ';' ||,
                      Right(Cache,7)              ';' ||,
                      Right(UseAllMem,4)          ';' ||,
                      Right(Heap,6)               ';' ||,
                      Right(Net1,7)               ';' ||,
                      Right(Net2,7)               ';' ||,
                      Right(Net3,7)               ';' ||,
                      Right(Net4,7)               ';' ||,
                      Right(Net5,7)               ';' ||,
                      Right(AutoDisc,5)           ';' ||,
                      Right(MaxUsers,9)           ';' ||,
                      Right(MaxConn,8)            ';' ||,
                      Right(MaxShares,10)         ';'

   'net use \\'ServerName'\'Left(ServerBootDrive,1)'$ /d >nul'
   'net use \\'ServerName'\ipc$ /d >nul'
   'net use \\'ServerName'\ibmlan$ /d >nul'

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    TempFile = LSRDrive'\ibmlan\lsbrowse.tmp'             /* Temporary file*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say '...Interupted by User...'

    Exit X2D('1604')

