/*---------------------------------------------------------------------------*\
|  Check Lan Server Open Files                (C) Alain Rykaert - MAR96-FEB98 |
\*---------------------------------------------------------------------------*/
    Version = '2.01'
    Say '* LSFILES Version' Version

    Parse Upper Arg ServerName Option

    Call Init                                   /* load DLL's & other stuff*/

    If ServerName = ''
      Then Do
             Say '*'
             Say '* LAN Server Files'
             Say '*'
             Say '* Usage: LSFILES {*} {ServerName}'
             Say '*'
             Say '* Sample: LSFILES \\BEDDC2'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    If ServerName = '*'
      Then Do
             RC = NetGetInfo(350, 'WkstaInfo','')
             If RC = 0
               Then ServerName = WkstaInfo.ComputerName
               Else Call ChkError RC
           End
      Else ServerName = ServerName

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName

    RC = NetEnumerate(60, 'FileInfo', '\\'ServerName)
    If RC = 0
      Then Do i = 1 to FileInfo.Count
             Counter = '('Right(i,Length(FileInfo.0))'/'Right(FileInfo.0,Length(FileInfo.0))')'
             UserID = Left(FileInfo.i.UserName,8)
             If Length(FileInfo.i.PathName) < 50
               Then FileName = Left(FileInfo.i.PathName,50)
               Else FileName = Left(FileInfo.i.PathName,17) || '...' || Right(FileInfo.i.PathName,30)
             Say Counter Right(FileInfo.i.ID,4) UserID FileName Right(FileInfo.i.Permissions,3) FileInfo.i.Num_Locks
           End
      Else Call ChkError

    Exit X2D('FE00')

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('Path',,'OS2Environment')
    x = Pos('IBMLAN\NETPROG', PPath) -3
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit X2D('1600')

    Return

