/*---------------------------------------------------------------------------*\
|   LAN Server Presence Check                 (C) Alain Rykaert - MAR96-APR00 |
\*---------------------------------------------------------------------------*/

    Parse Arg ServerName

    Call Init                                   /* load DLL's & other stuff*/

    If ServerName = ''
      Then Do
             Say '*'
             Say '* LAN Server Presence Check'
             Say '*'
             Say '* Usage: LSPRES {ServerName}'
             Say '*'
             Say '* Sample: LSPRES \\DC02'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    ServerName = Strip(ServerName,'L','\')

    Call CharOut,'* Server Name:' '\\'ServerName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
             Say ' : OK'
             Exit X2D('FE00')
           End
      Else Do
             Say ' : Not OK'
             Exit X2D('0800')
           End

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Return

