/*---------------------------------------------------------------------------*\
|   Get Software levels                       (C) Alain Rykaert - AUG95-OCT00 |
\*---------------------------------------------------------------------------*/
    Version = '3.15a (C) AR - DEC2000'
    Say '* LSSYSLVL Version' Version

    Call Init                                 /* init dll's and other stuff*/

   'if not exist' LSRDrive'\ibmlan\tmp md' LSRDrive'\ibmlan\tmp'
    TempFile = LSRDrive'\ibmlan\tmp\lssyslvl.tmp'         /* Temporary file*/

    Parse Upper Arg DCName OutFileName

    If DCName = '' | OutFileName = ''
      Then Do
             Say '*'
             Say '* Get LAN Server Software inventory'
             Say '*'
             Say '* Usage: LSSYSLVL {DCName} {OutputFileName}'
             Say '*'
             Say '* Sample: LSSYSLVL \\BEDDC01 LSSYSLVL.CSV'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')
    Say '* Server Name:' '\\'DCName
    Say '* Output FileName:' OutFileName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Say RC

    RC = NetGetInfo(340, 'ServerName', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             OutText = '***' Date() Time() '*** LSSYSLVL Version:' Version
             Call Logit OutFileName OutText
             Call Logit OutFileName ' '
             OutText = "SERVER  " ';',
                       "TIME "    ';',
                       "INST    " ';',
                       "OS2    "  ';',
                       "FIX "     ';',
                       "MPTS   "  ';',
                       "SERVER "  ';',
                       "TCPIP  "  ';',
                       "TCPSTCK"  ';',
                       "CM2    "  ';',
                       "PCOMM"    ';',
                       "NETFIN"   ';',
                       "ADSM   "  ';',
                       "DB2    "  ';',
                       "FFST   "  ';',
                       "SD     "  ';'
             If Trace Then Say OutText
             Call Logit OutFileName OutText

             Call RxStemSort 'ServerName'
             Say '* Total defined servers:' ServerName.0
             Do i = 1 to ServerName.0
               Counter = '('Right(i,Length(ServerName.0))'/'Right(ServerName.0,Length(ServerName.0))')'
               Say '* ServerName:' Counter ServerName.i
               OutText = Left(ServerName.i,9) || ';'
               If NetGetInfo(370, 'ServerModalInfo', '\\'ServerName.i) = 0 &,
                 Stream('\\'ServerName.i'\ibmlan$\ibmlan.ini', 'C', 'Query Exists') <> ''
                 Then Call GetInfo ServerName.i
                 Else Say '09'x '> not found'
               Call Logit OutFileName OutText
             End
           End
      Else Say RC

    Exit

 GETINFO:/* ----------------------------------------------------------------*/

    Parse Arg ServerName

    CSD_OS2    = ''                                                  /* os2*/
    DRV_OS2    = ''
    VER_OS2    = ''
    FIX_OS2    = ''

    CSD_MPTS   = ''                                                 /* mpts*/
    DRV_MPTS   = ''
    VER_MPTS   = ''
    TCPSTCK    = ''                                         /* TCP/IP Stack*/

    CSD_LSR    = ''                                           /* lan server*/
    DRV_LSR    = ''
    VER_LSR    = ''

    CSD_TCP    = ''                                               /* tcp/ip*/
    DRV_TCP    = ''
    VER_TCP    = ''

    CSD_CM2    = ''                                                 /* cm/2*/
    DRV_CM2    = ''
    VER_CM2    = ''

    CSD_PCOM   = ''                                                /* pcomm*/
    DRV_PCOM   = ''
    VER_PCOM   = ''

    CSD_NETFIN = ''                                            /* netfinity*/
    DRV_NETFIN = ''
    VER_NETFIN = ''

    CSD_ADSM   = ''                                                 /* adsm*/
    DRV_ADSM   = ''
    VER_ADSM   = ''

    DRV_DB2    = ''                                                 /* db/2*/
    CSD_DB2    = ''
    VER_DB2    = ''

    DRV_FFST   = ''                                               /* FFST/2*/
    CSD_FFST   = ''
    VER_FFST   = ''

    DRV_SD     = ''                                             /* softdist*/
    CSD_SD     = ''
    VER_SD     = ''

    Call Time('R')                                       /* Reset the timer*/

    BatchFile = '\\'ServerName'\ibmlan$\netprog\batch.cmd'/* make a batch file*/
   'if exist' BatchFile 'del' BatchFile
   'if exist' TempFile  'del' TempFile

    Call LineOut BatchFile, '@echo off'
    Call LineOut BatchFile, 'set'
    Call LineOut BatchFile, 'ver /r'
    Call LineOut BatchFile, '\mptn\bin\inetver'
    Call Stream  BatchFile, 'C', 'Close'
    Call ChkFile BatchFile

   'net admin \\'ServerName '/c batch >' TempFile
    Call Stream TempFile, 'C', 'Close'
    If Stream(TempFile, 'C', 'Query Size') > 0
      Then Nop
      Else Do
             Say '! Error: tempfile' TempFile 'is not valid' '07'x
             Return
           End

 /* Get all Syslevels */

    Call SysFileSearch 'COMSPEC=', TempFile, 'Stem'
    If Stem.0 = 1
      Then Do
             Parse Var Stem.1 . '=' ServerBootDrive ':' .
             If Trace Then Say '> Boot Drive:' ServerBootDrive
             LibPath = ''
             Call SysFileSearch 'LIBPATH=', '\\'ServerName'\'ServerBootDrive'$\config.sys', 'Stem'
             Do j = 1 to Stem.0
               Stem.j = Translate(Stem.j)
               If Left(Strip(Stem.j), 8) = 'LIBPATH='
                 Then Parse Value Stem.j With . '=' LibPath
                 Else Nop
             End
             If LibPath = ''
               Then Do
                      Say '! Error: could not determine LibPath' '07'x
                      Return
                    End
               Else If Trace Then Say '> LibPath:' LibPath
           End
      Else Do
             Say '! Error: could not determine ComSpec' '07'x
             Return
           End

    Call SysFileSearch 'Inet Version:', TempFile, 'Stem'    /* TCP/IP Stack*/
    If Stem.0 = 1
      Then Do
             Parse Var Stem.1 . ':' TcpStck .
             If Trace Then Say '> TCP/IP Stack:' TcpStck
           End
      Else Nop

    Call SysFileSearch 'SOCKETS.SYS:', TempFile, 'Stem'     /* TCP/IP Stack*/
    If Stem.0 = 1
      Then Do
             Parse Var Stem.1 . ':' TcpStck .
             If Trace Then Say '> TCP/IP Stack:' TcpStck
           End
      Else Nop

    Do While LibPath <> ''
      DriveLetter = ''
      Parse Upper Value LibPath With QPath ';' LibPath
      If Pos(':',QPath) > 0
        Then Parse Var QPath DriveLetter ':' QPath
        Else Nop
      Select
       When QPath = '\IBMLAN\NETLIB'                          /* Lan Server*/
         Then Do
                DRV_LSR = '\\'ServerName'\'DriveLetter'$'
                CSD_LSR = RxSysLevel(DRV_LSR'\ibmlan\syslevel.req', 'Level')
                VER_LSR = RxSysLevel(DRV_LSR'\ibmlan\syslevel.req', 'Ver')
              End
       When QPath = '\IBMCOM\DLL'                                   /* MPTS*/
         Then Do
                DRV_MPTS = '\\'ServerName'\'DriveLetter'$'
                CSD_MPTS = RxSysLevel(DRV_MPTS'\ibmcom\syslevel.trp', 'Level')
                VER_MPTS = RxSysLevel(DRV_MPTS'\ibmcom\syslevel.trp', 'Ver')
              End
       When QPath = '\TCPIP\DLL'                                  /* TCP/IP*/
         Then Do
                DRV_TCP = '\\'ServerName'\'DriveLetter'$'
                CSD_TCP = RxSysLevel(DRV_TCP'\tcpip\bin\syslevel.tcp', 'Level')
                VER_TCP = RxSysLevel(DRV_TCP'\tcpip\bin\syslevel.tcp', 'Ver')
                If CSD_TCP = 'ERROR'
                 Then CSD_TCP = RxSysLevel(DRV_TCP'\tcpip\syslevel.tcp', 'Level')
                 Else Nop
              End
       When QPath = '\CMLIB\DLL'                                    /* CM/2*/
         Then Do
                DRV_CM2 = '\\'ServerName'\'DriveLetter'$'
                CSD_CM2 = RxSysLevel(DRV_CM2'\cmlib\syslevel.acs', 'Level')
                VER_CM2 = RxSysLevel(DRV_CM2'\cmlib\syslevel.acs', 'Ver')
              End
       When QPath = '\PCOMOS2'                                     /* PCOMM*/
         Then Do
                DRV_PCOM = '\\'ServerName'\'DriveLetter'$'
                CSD_PCOM = RxSysLevel(DRV_PCOM'\pcomos2\syslevel.pcs', 'Level')
                VER_PCOM = RxSysLevel(DRV_PCOM'\pcomos2\syslevel.pcs', 'Ver')
                Parse Var VER_PCOM Begin '.' Between '.' Rest
                VER_PCOM = Begin || '.' || Between
              End
       When QPath = '\SQLLIB\DLL'                                   /* DB/2*/
         Then Do
                DRV_DB2 = '\\'ServerName'\'DriveLetter'$'
                If Stream(DRV_DB2'\sqllib\syslevel.ce2', 'C', 'Query Exists') <> ''
                  Then Do
                         CSD_DB2 = RxSysLevel(DRV_DB2'\sqllib\syslevel.ce2', 'Level')
                         VER_DB2 = RxSysLevel(DRV_DB2'\sqllib\syslevel.ce2', 'Ver')
                       End
                  Else Do
                         CSD_DB2 = RxSysLevel(DRV_DB2'\sqllib\syslevel.dba', 'Level')
                         VER_DB2 = RxSysLevel(DRV_DB2'\sqllib\syslevel.dba', 'Ver')
                       End
              End
       When QPath = '\NETFIN'                                  /* NetFinity*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\netfin\syslevel.snf', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\netfin\syslevel.snf', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = 'N' || Begin || '.' || Between
             /*
                QNetfin = Stream(DRV_NETFIN'\netfin\syslevel.snf', 'C', 'Query DateTime')
                Say QNetfin
                Parse Var QNetfin . '-' . '-' . '0' Time1 ':' Time2 ':' .
                VER_NETFIN = 'N' || Time1 || '.' || Time2
                Say Ver_Netfin
              */
              End
       When QPath = '\SYSVIEW2\BIN'                           /* SystemView*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\sysview2\bin\syslevel.svc', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\sysview2\bin\syslevel.svc', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = 'S' || Begin || '.' || Between
              End
       When QPath = '\TME10\BIN'                                  /* TME 10*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\tme10\bin\syslevel.svc', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\tme10\bin\syslevel.svc', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = 'T' || Begin || '.' || Between
              End
       When QPath = '\ADSM' | QPath = '\ADSM\API'                   /* ADSM*/
         Then Do
                DRV_ADSM = '\\'ServerName'\'DriveLetter'$'
                If Stream(DRV_ADSM'\adsm\read.me', 'C', 'Query Exists') <> ''
                  Then Do                             /* This is a verion 2*/
                         If SysFileSearch('Version', DRV_ADSM'\adsm\read.me', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer ',' . ARel ',' . ALvl
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                       End
                  Else Do                            /* This is a version 3*/
                         If SysFileSearch('Version', DRV_ADSM'\adsm\readme.txt', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer . ARel ',' . ALvl .
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                   End
              End
       When QPath = '\ADSMCV3\API'                                  /* ADSM*/
         Then Do
                DRV_ADSM = '\\'ServerName'\'DriveLetter'$'
                If Stream(DRV_ADSM'\adsmcv3\read.me', 'C', 'Query Exists') <> ''
                  Then Do                             /* This is a verion 2*/
                         If SysFileSearch('Version', DRV_ADSM'\adsmcv3\read.me', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer ',' . ARel ',' . ALvl
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                       End
                  Else Do                            /* This is a version 3*/
                         If SysFileSearch('Version', DRV_ADSM'\adsmcv3\readme.txt', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer . ARel ',' . ALvl .
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                   End
              End
       When QPath = '\SOFTDIST\BIN'                                   /* SD*/
         Then Do
                DRV_SD = '\\'ServerName'\'DriveLetter'$'
                CSD_SD = RxSysLevel(DRV_SD'\softdist\bin\syslevel.fnd', 'Level')
                VER_SD = RxSysLevel(DRV_SD'\softdist\bin\syslevel.fnd', 'Ver')
              End

       When QPath = '\PGMS\PCOMOS2'                      /* PCOMM at Morgan*/
         Then Do
                DRV_PCOM = '\\'ServerName'\'DriveLetter'$'
                CSD_PCOM = RxSysLevel(DRV_PCOM'\pgms\pcomos2\syslevel.pcs', 'Level')
                VER_PCOM = RxSysLevel(DRV_PCOM'\pgms\pcomos2\syslevel.pcs', 'Ver')
                Parse Var VER_PCOM Begin '.' Between '.' Rest
                VER_PCOM = Begin || '.' || Between
              End
       When QPath = '\PGMS\NETFIN'                   /* NetFinity at Morgan*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\pgms\netfin\syslevel.snf', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\pgms\netfin\syslevel.snf', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = 'N' || Begin || '.' || Between
              End
       When QPath = '\PGMS\SYSVIEW2\BIN'            /* SystemView at Morgan*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\pgms\sysview2\bin\syslevel.svc', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\pgms\sysview2\bin\syslevel.svc', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = 'S' || Begin || '.' || Between
              End
       When QPath = '\PGMS\ADSM'                          /* ADSM at Morgan*/
         Then Do
                DRV_ADSM = '\\'ServerName'\'DriveLetter'$'
                If Stream(DRV_ADSM'\pgms\adsm\read.me', 'C', 'Query Exists') <> ''
                  Then Do                             /* This is a verion 2*/
                         If SysFileSearch('Version', DRV_ADSM'\pgms\adsm\read.me', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer ',' . ARel ',' . ALvl
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                       End
                  Else Do                            /* This is a version 3*/
                         If SysFileSearch('Version', DRV_ADSM'\pgms\adsm\readme.txt', 'Stem') = 0
                           Then Do
                                  Parse Var Stem.1 . AVer . ARel ',' . ALvl .
                                  VER_ADSM = 'V' || AVer || 'R' || ARel || 'L' || Space(Translate(ALvl, '','.'), 0)
                               End
                           Else Nop
                   End
              End
       When QPath = '\PGMS\SOFTDIST\BIN'                    /* SD at Morgan*/
         Then Do
                DRV_SD = '\\'ServerName'\'DriveLetter'$'
                CSD_SD = RxSysLevel(DRV_SD'\pgms\softdist\bin\syslevel.fnd', 'Level')
                VER_SD = RxSysLevel(DRV_SD'\pgms\softdist\bin\syslevel.fnd', 'Ver')
              End
       When QPath = '\NF'                             /* NetFinity at Anhyp*/
         Then Do
                DRV_NETFIN = '\\'ServerName'\'DriveLetter'$'
                CSD_NETFIN = RxSysLevel(DRV_NETFIN'\nf\syslevel.snf', 'Level')
                VER_NETFIN = RxSysLevel(DRV_NETFIN'\nf\syslevel.snf', 'Ver')
                Parse Var VER_NETFIN Begin '.' Between '.' Rest
                VER_NETFIN = Begin || '.' || Between
              End
       When QPath = '\PCOM'                               /* PCOMM at Anhyp*/
         Then Do
                DRV_PCOM = '\\'ServerName'\'DriveLetter'$'
                CSD_PCOM = RxSysLevel(DRV_PCOM'\pcom\syslevel.pcs', 'Level')
                VER_PCOM = RxSysLevel(DRV_PCOM'\pcom\syslevel.pcs', 'Ver')
                Parse Var VER_PCOM Begin '.' Between '.' Rest
                VER_PCOM = Begin || '.' || Between
              End
       OtherWise Nop
      End
    End

 /* Get the Sys & Buildlevel of base OS/2 */

    Call SysFileSearch 'REVISION', TempFile, 'Stem'
    If Stem.0 = 1
      Then Do
             Parse Var Stem.1 . BLD_OS2 .
             If Trace Then Say '> Build OS2:' BLD_OS2
           End
      Else Nop

    Build_List = '9.035 9.034 9.033 9.032 9.031 9.030 9.029 9.028 9.027 9.026 9.025 9.023',
                 '8.266 8.265 8.264 8.263 8.262 8.261 8.260 8.259 8.258 8.257 8.256 8.255',
                 '8.254 8.253 8.252 8.251 8.250 8.249 8.248 8.247 8.246 8.245 8.244 8.243',
                 '8.242 8.241 8.240 8.239 8.238 8.237 8.236 8.235 8.234 8.232 8.200 8.169',
                 '8.168 8.167 8.162'
                                                /* List the known FixPaks */
    Fix_Paks = 'M011  M010  M009  M008  M007  M006  M005  M004  M003  M002  M001  None',
               'W042  W041  W040  W039  W038  W037  W036  W035  W034  W033  W032  W031',
               'W030  W029  W028  W027  W026  W025  W024  W023  W022  W021  W020  W019',
               'W018  W017  W016  W015  W014  W013  W012  W011  W010  W010  None  W008',
               'W008  W5/6  None'

    z = Wordpos(BLD_OS2, Build_List)              /* Is this a known Build?*/
    If z <> 0
      Then FIX_OS2 = Word(Fix_Paks, z)            /* Yes, find FixPak level*/
      Else Nop

    CSD_OS2 = RxSysLevel('\\'ServerName'\'ServerBootDrive'$\os2\install\syslevel.os2', 'Level')
    VER_OS2 = RxSysLevel('\\'ServerName'\'ServerBootDrive'$\os2\install\syslevel.os2', 'Ver')

    If Stream('\\'ServerName'\'ServerBootDrive'$\os2\syslevel.epw', 'C', 'Query Exists') <> ''
      Then Do
             CSD_FFST = RxSysLevel('\\'ServerName'\'ServerBootDrive'$\os2\syslevel.epw', 'Level')
             VER_FFST = RxSysLevel('\\'ServerName'\'ServerBootDrive'$\os2\syslevel.epw', 'Ver')
           End
      Else CSD_FFST = 'N/A'

 /* Get the OS/2 installation date */
    GetInstall = Stream('\\'ServerName'\'ServerBootDrive'$\os2\ini.rc', 'C', 'Query TimeStamp')
    Parse Var GetInstall Year '-' Month '-' Day .
    Install = Year || Month || Day
    If Trace Then Say '> Install Date:' Install

 /* Build all together */
    OutText = OutText Right(Trunc(Time('E'),2),5) ';',
                      Left(Install,8)             ';',
                      Left(CSD_OS2,7)             ';',
                      Left(FIX_OS2,4)             ';',
                      Left(CSD_MPTS,7)            ';',
                      Left(CSD_LSR,7)             ';',
                      Left(CSD_TCP,7)             ';',
                      Left(TCPSTCK,7)             ';',
                      Left(CSD_CM2,7)             ';',
                      Left(VER_PCOM,5)            ';',
                      Left(VER_NETFIN,6)          ';',
                      Left(VER_ADSM,7)            ';',
                      Left(CSD_DB2,7)             ';',
                      Left(CSD_FFST,7)            ';',
                      Left(CSD_SD,7)              ';'

    If Trace Then Say OutText

   'net use \\'ServerName'\'Left(ServerBootDrive,1)'$ /d >nul 2>nul'
   'net use \\'ServerName'\ipc$ /d >nul 2>nul'
   'net use \\'ServerName'\ibmlan$ /d >nul 2>nul'

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    If Value('TREES',,'OS2Environment') = ''           /* Check for Tracing*/
      Then Trace = 0
      Else Trace = 1

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('PATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '! Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg OutFileName OutText

    If LineOut(OutFileName, OutText) = 0
      Then Call Stream OutFileName, 'C', 'Close'
      Else Say '! Error while writing:' OutFileName '07'x

    Return

