/*---------------------------------------------------------------------------*\
|   Query DCDB Info from a Domain                                             |
|                                               (C) Alain Rykaert AUG96-JAN99 |
\*---------------------------------------------------------------------------*/
    Version = '1.12'

 /*- Start of Variables -----------------------------------------------------*/

    Output.0  =  10            ; Ico.0  = Output.0
    Output.1  = 'Servers.CSV'  ; Ico.1  = 'servers.ico'
    Output.2  = 'Users.CSV'    ; Ico.2  = 'users.ico'
    Output.3  = 'Groups1.CSV'  ; Ico.3  = 'groups1.ico'
    Output.4  = 'Groups2.CSV'  ; Ico.4  = 'groups2.ico'
    Output.5  = 'Alias.CSV'    ; Ico.5  = 'alias.ico'
    Output.6  = 'Acl.CSV'      ; Ico.6  = 'acl.ico'
    Output.7  = 'Assgn.CSV'    ; Ico.7  = 'assgn.ico'
    Output.8  = 'Appl.CSV'     ; Ico.8  = 'appl.ico'
    Output.9  = 'Selector.CSV' ; Ico.9  = 'selector.ico'
    Output.10 = 'Users.PWD'    ; Ico.10 = 'userspw.ico'

 /*- End of Variables -------------------------------------------------------*/

    Parse Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call Chkopt                          /* Check Options & display Welcome*/
    Call Main                                            /* do the main job*/
    Exit

 MAIN:/* ----------------------------------------------------- MAIN: -------*/

    Call ChkServer DCName                /* Check if this is the Primary DC*/

 /* Get the Domain name from the DC-PR */

    Call SysFileSearch 'DOMAIN =', '\\'DCName'\ibmlan$\ibmlan.ini', 'File.'
    If File.0 > 0
      Then Do j = 1 to File.0
             Parse Value File.j With Begin '=' Rest .
             If Left(Begin,1) = ';'
               Then Nop
               Else DomainName = Rest
           End
      Else Do
             Say '! Unable to determine the Domains name' '07'x
             Say '! from the Primary Domain Controller' DCName
             Say '* Press any key to continue'
             Pull
             Exit
          End
    Say '  The name of the Domain is:' DomainName
    Say

 /* Check if a directory exist for this domain. If needed, create it */

    Call ChkDir Directory()'\'DomainName

    Call MakeObjects                           /* make a folder, GETALL, T2*/

    Call MakeOutputs                /* make shadows of existing *.CSV files*/

    Say
    Say '* Done. Press any key to Exit'
    Pull

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    DCName = ''

    Option = Translate(Option)
    Do While Option <> ''
       Parse Value Option With Argument ' ' Option
       Select
        When Left(Argument,5) = '/SRV:' Then DCName = Substr(Argument,6)
        Otherwise Nop
       End
    End

    If DCName = ''
      Then signal GetHelp
      Else Nop

    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/M'                                    /* Rexx Utilities*/
    Call RgUtils  '/M'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/M'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    Redir = '>NUL 2>NUL'
    TempFile = 'Temp.Tmp'             /* Temporary file used in the program*/

    ResourceFile = 'LSMT.RSC'                  /* Ansi Topics Resource File*/
    Call Chkfile ResourceFile

    HW_File = 'HW.CSV'
    SW_File = 'SW.CSV'

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(ResourceFile Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
      Parse Value Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
      Call SysCurPos Row, Column
      Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
    End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    Topic1 = 'Q_SERVERS_DCDB'
    Topic_String.Topic1.1 = PRGN
    Topic_List = Topic1

    Call GetAns

    Exit

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg File

    RC = Stream(File, 'C', 'Query Exists')
    If RC = ''
      Then Do
             Say '! File' File 'not found' '07'x
             Exit
           End
      Else Nop
    Call Stream File, 'C', 'Close'

    Return

 CHKSERVER:/* ------------------------------------------------- CHKSERVER: --*/

    Parse Arg Server

    Say
    Say '* Check if' Server 'is a Primary Domain Controller ...'

    Parse Value SysCurPos() With Row Col
    Call SysCurPos Row -1, 47 + Length(Server)

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'Server)

    If RC = 0 & ServerModalInfo.Role = 'Primary server in the domain'
      Then Say 'OK'
      Else Do
             Say '! Not OK' '07'x
             Say
             Say '* Done. Press any key to Exit'
             Pull
             Exit
           End

    Return

 MAKEOBJECTS:/* ----------------------------------------------- MAKEOBJECTS*/

    Class    = 'WPFolder'
    Title    =  DomainName
    Location = '<LSMT_DCDB>'
    Setup    = 'OBJECTID=<LSMT_DCDB_'DomainName'>;'                ||,
               'ICONVIEW=FLOWED;'                                  ||,
               'ICONVIEWPOS=40,20,55,65;'                          ||,
               'ICONFONT=10.System VIO;'                           ||,
               'ICONFILE='Directory()'\domain.ico;'                ||,
               'ALWAYSSORT=YES'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPShadow'
    Title    = '*Get from DC'
    Location = '<LSMT_DCDB_'DomainName'>'
    Setup    = 'SHADOWID=<LSMT_GETCMD>'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPShadow'
    Title    = '*Set to DC'
    Location = '<LSMT_DCDB_'DomainName'>'
    Setup    = 'SHADOWID=<LSMT_SETCMD>'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPShadow'
    Title    = '*Get All definitions'
    Location = '<LSMT_DCDB_'DomainName'>'
    Setup    = 'SHADOWID=<LSMT_GETALL>'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPShadow'
    Title    = '*T2 Editor'
    Location = '<LSMT_DCDB_'DomainName'>'
    Setup    = 'SHADOWID=<LSMT_T2>'
    Update   = 'Update'
    Call CreateObj

    Return

 MAKEOUTPUTS:/* -------------------------------------------------------------*/

    Location = '<LSMT_DCDB_'DomainName'>'

 /* prepare text in case the output file does not exist */

    Text = '0A'x ' Just Drag & Drop me on the "<Get> from DC" Object'

    Do i = 1 to OUTPUT.0
      FileName = Directory()'\'DomainName'\'Output.i
      If Stream(FileName, 'C', 'Query Exists') = ''
        Then Do
               Call LineOut FileName, Text
               Call Stream  FileName, 'C', 'Close'
             End
        Else Nop
      Call SysSetObjectData FileName, 'ICONFILE='Directory()'\'ICO.i
    /* Make Shadow of OutputFiles */
      Call MakeShadow Output.i FileName Location
    End

    LogFile = Directory()'\'DomainName'\LSMT.LOG'
    If Stream(LogFile, 'C', 'Query Exists') = ''
      Then Do
             Call LineOut LogFile, '*** LSMT Installed on' Date('E') Time()
             Call Stream  LogFile, 'C', 'Close'
           End
      Else Nop

    Call SysSetObjectData LogFile, 'ICONFILE='Directory()'\LOG.ICO'

 /* Make Shadow of LSMT.LOG */
    Call MakeShadow 'LSMT.LOG' LogFile Location

    Return

 CHKDIR:/* ---------------------------------------------------- CHKDIR: ---*/

    Parse Arg Dir_Name

    RCode = 0                                      /* Reset the Return Code*/

    If Stream(Dir_Name, 'C', 'Query Exists') <> ''      /* is this a file ?*/
      Then RCode = 1   /* Bad RC, there already exist a file with this name*/
      Else Do
             Call SysFileTree Dir_Name, 'DirExist', 'DO'/* does this DIR exist ?*/
             If DirExist.0 = 0
               Then Do
                      RC = SysMKDir(Dir_Name)
                      If RC <> 0
                        Then RCode = 1
                        Else Nop
                    End
               Else Nop
           End

    If RCode = 1
      Then Do
             Say '! Error while creating' Dir_Name '07'x
             Pull
             Exit
           End
      Else Nop

    Return

 MAKESHADOW:/* --------------------------------------------------------------*/

    Parse Arg Title FileName Location

    If Stream(FileName, 'C', 'Query Exists') = ''
      Then Nop
      Else Do
             Class    = 'WPShadow'
             Title    =  Title
             Location =  Location
             Setup    = 'SHADOWID='FileName
             Update   = 'Update'
             Call CreateObj
          End

    Return

 CREATEOBJ:/* ------------------------------------------------- CREATEOBJ: --*/

    Say '* Creating ...' Title
 /*
    Say 'Class    =' Class
    Say 'Title    =' Title
    Say 'Location =' Location
    Say 'Setup    =' Setup
    Say 'Update   =' Update
  */
    RC = SysCreateObject(Class, Title, Location, Setup, Update)
    If RC <> 1
      Then '! ErrorCode' RC Title '07'x
      Else Nop

    Return

