/*---------------------------------------------------------------------------*\
|  LAN Server APPLY procedure                 (C) Alain Rykaert - MAR96-SEP97 |
\*---------------------------------------------------------------------------*/
    Version = '2.03'
    Say '* RXAPPLY Version' Version

 /*====================================*/
    LogFileName = 'RXAPPLY.LOG'
 /*====================================*/

    Call Init

    Parse Upper Arg ServerName Resource .

    If ServerName = ''
      Then Do
             Say '*'
             Say '* Apply the ACLs from the root of the resource'
             Say '* to all the subdirectories below'
             Say '*'
             Say '* Usage: RXAPPLY {ServerName} {Resource}'
             Say '*'
             Say '* Sample: RXAPPLY \\BEDDC1 E:\OS2APPL'
             Say '*'
             Exit
           End
      Else Nop

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName

 /* Make an UNC name of the resource */
    Parse Value Resource With Drive ':' Rest
    Resource = '\\'ServerName'\'Drive'$'Rest

 /* Check if the resource exist */
    Call SysFileTree Resource, 'Stem', 'DO'
    If Stem.0 = 0
      Then Do
             Say '! Resource:' Resource 'not found' '07'x
             Exit
           End
      Else Nop

    Say '* Getting the ACL from:' Resource
    RC = NetGetInfo(10, 'Access', '\\'ServerName, Resource)
    If RC = 0
      Then Do i = 1 to Access.Count
             Say '  ACL on' Resource '=' Access.i.UgName Access.i.Access
           End
      Else Call ChkError RC

    Say '* Apply this ACL to' Resource '?'
    Key = Translate(SysGetKey('ECHO'))
    If Key <> 'Y'
      Then Exit
      Else Nop

    Say '* Getting all the subdirectories'
    Call SysFileTree Resource'\', 'Stem', 'DOS'
    If Stem.0 = 0
      Then Do
             Say '! No directories found'
             Exit
           End
      Else Do i = 1 to Stem.0
             Counter = '('Right(i,Length(Stem.0))'/'Right(Stem.0,Length(Stem.0))')'
             Say Counter Stem.i
             RC = NetDelete(10, '\\'ServerName, Stem.i)
             RC = NetAdd(10, 'Access', '\\'ServerName, Stem.i)
             If RC = 0
               Then Nop
               Else Do
                      Say '! Error while setting ACL on' Stem.i '07'x
                      Call Logit '* Error' i Stem.i RC
                    End

           End

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('PATH',,'OS2ENVIRONMENT')
    Do While PPath <> ''
      Parse Upper Value PPath With Begin ';' PPath
      If SubStr(Begin,4) = 'IBMLAN\NETPROG'
        Then LSRDrive = Left(Begin,2)
        Else Nop
    End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then If RxFuncQuery('LoadLSRXUTFuncs')
             Then Do
                    Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
                    Call LoadLsRxutFuncs
                  End
             Else Nop
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg LogText

    LogText = Date('E') Time() LogText

    Call LineOut LogFileName, LogText
    Call Stream LogFileName, 'C', 'Close'

    Return

