/*---------------------------------------------------------------------------*\
|   SET all GROUPS to a LAN Server 3.0 and higher                             |
|   from an ASCII File                                                        |
|                                   (C) Alain Rykaert IBM Belgium SEP95-MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                    /* Initialisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' CHKF 'del' CHKF
    EC = 0
    ExitCode = X2D('FE00')                          /* Good CID Return code*/

    do while Lines(INPF)
       LLINE = LineIN(INPF)
       OLINE = LLINE
       parse value LLINE with OPT ';' LLINE
       select
        when OPT = '',
         | LLINE = '',
         | Left(Strip(OPT),1) = '*' then Iterate
        when Translate(OPT) = 'OPT' then Call COLUMNS
        when Translate(OPT) = 'A'   then Call UPDGROUP
        when Translate(OPT) = 'D'   then Call DELGROUP
        when Translate(OPT) = 'U'   then Call UPDGROUP
        otherwise Iterate
       end
       if EC
        then do
                 Call LineOut CHKF, OLINE
                 EC = 0
                 ExitCode = X2D('1604')              /* Bad CID return code*/
             end
        else Nop
    end
    say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return

 ADDGROUP:/* -------------------------------------------------- ADDGROUP: ---*/

    /* Goto the UPDGROUP section */

 DELGROUP:/* -------------------------------------------------- DELGROUP: ---*/

    EC = 0                                    /* Reset the Error Check Flag*/
    Parse Value LLINE with USERID ';' LLINE
    USERID = Strip(USERID)

    i = 1
    do while LLINE <> ''
       i = i + 1
       parse value LLINE with FLAG ';' LLINE
       FLAG = Translate(Strip(FLAG))
       GROUP = COLNAME.i           /* Reminder : COLNAME = GroupName */
       select

        when GROUP = 'ADMINS',
           | GROUP = 'GUESTS',
           | GROUP = 'USERS'
         then Nop

        when FLAG = 'X'
         then do
                RC = NetDelete(340, '\\'SRVNAME, GROUP, USERID)
                if RC = 0
                 then RC = ''
                 else Nop
                Call LOGIT 'Del User from Group', USERID'-'GROUP, RC
             end

        otherwise Nop

       end
    end

    Return

 UPDGROUP: /*-------------------------------------------------- UPDGROUP: ---*/

    EC = 0       /*  Reset the Error Check Flag  */
    Parse Value LLINE with USERID ';' LLINE
    USERID = Strip(USERID)
    if \MUTE
     then do
             Call SysCurState OFF
             Call SysCurPos 20,16
             say ESC'[K'
             Call SysCurPos 20,16
          end
     else Nop
    say ' Update User =' USERID

    i = 1
    do while LLINE <> ''
       i = i + 1
       parse value LLINE with FLAG ';' LLINE
       FLAG = Translate(Strip(FLAG))

       GROUP = COLNAME.i           /* Reminder : COLNAME = GroupName */

       if GROUP = 'ADMINS',
        | GROUP = 'GUESTS',
        | GROUP = 'USERS'
        then Iterate
        else Nop

       if FLAG = 'X'
         then do
                 CHKGRP = ''        /* Get old Info */
                 RC = NetGetInfo(330, 'USERGROUPS', '\\'SRVNAME, USERID)
                 if RC = 0
                  then do
                          Call RxStemSort 'USERGROUPS'
                          do j = 1 to USERGROUPS.0
                             CHKGRP = CHKGRP USERGROUPS.j
                          end
                      /*  say '-' USERID 'is member of  :' CHKGRP */
                          if Wordpos(GROUP,CHKGRP) > 0
                           then Nop
                           else do
                                   RC = NetAdd(340, '\\'SRVNAME, GROUP, USERID)
                                   if RC = 0
                                     then RC = ''
                                     else Nop
                                   Call LOGIT 'Add User to Group', USERID'-'GROUP, RC
                                end
                       end
                  else Nop
              end
         else do
                 CHKGRP = ''        /* Get old Info */
                 RC = NetGetInfo(330, 'USERGROUPS', '\\'SRVNAME, USERID)
                 if RC = 0
                  then do
                          Call RxStemSort 'USERGROUPS'
                          do j = 1 to USERGROUPS.0
                             CHKGRP = CHKGRP USERGROUPS.j
                          end
                      /*  say '-' USERID 'is member of  :' CHKGRP */
                          if Wordpos(GROUP,CHKGRP) > 0
                           then do
                                   RC = NetDelete(340, '\\'SRVNAME, GROUP, USERID)
                                   if RC = 0
                                    then RC = ''
                                    else Nop
                                   Call LOGIT 'Del User from Group', USERID'-'GROUP, RC
                                end
                           else Nop
                       end
                  else Nop
              end
    end

    Return

 SETINFO: /*--------------------------------------------------- SETINFO: ----*/

    RC = NetSetInfo(70, COLNAME, GROUPINFO.COLNAME, '\\'SRVNAME, GROUPINFO.NAME)
     if RC = 0
      then RC = ''
      else EC = 1
    if COLNAME = 'PASSWORD'
     then Call LOGIT 'Update Groups', GROUPINFO.NAME '-' '****', RC
     else Call LOGIT 'Update Groups', GROUPINFO.NAME '-' GROUPINFO.COLNAME, RC

    Return

 COLUMNS: /*--------------------------------------------------- COLUMNS: ----*/

    BANNER = 'OPT'
    i = 0
    do while LLINE <> ''
       i = i + 1
       parse value LLINE with COLNAME.i ';' LLINE
       BANNER = BANNER';'COLNAME.i
    end

    COLT = i                      /* Total numbers of columns */
    Call LineOut CHKF, BANNER

    Return

 CHKOPT: /*---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = '';
    INPF = 'GROUPS2.CSV';
    LOGF = 'LSMT.LOG';
    CHKF = 'GROUPS2.CHK';
    PIPE = '';
    TRACE = 0;
    MUTE = 0;

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:' then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'    then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1='SETWELCOME'
             Topic_String.Topic1.1=SRVNAME;
             Topic_String.Topic1.2=INPF;
             Topic_String.Topic1.3=LOGF;
             Topic_String.Topic1.4=CHKF;
             Topic_String.Topic1.5=PIPE' ';
             Topic_List='WELCOMELOGO' Topic1 'SETGRPS';
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'InputFile  =' INPF
             say 'LogFile    =' LOGF
             say 'CheckFile  =' CHKF
          end

    Return

 CHKPWS: /*---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'WKSTAINFO' USERID.i ':' RC
            Call Quit
          end
    Return

 INIT: /*------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m' /* Rexx Utilities        */
    Call RgUtils  '/m' /* Rexx Utilities        */
    Call RgLSRXUT '/m' /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP: /*--------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1='SETHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT: /*----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT: /*------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   INPF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   CHKF,      'C', 'CLOSE'
    Exit ExitCode

 /*--------------------------------------------------------------------------*/
