/************************************************************************/
/*                                                                      */
/*         REXX Mail processor for use with aPOP3d                      */
/*                                                                      */
/* (C) 1996,1997 Axel Mueller (amueller@stargate.rz.fh-offenburg.de)    */
/*     Version 1.20                                                     */
/************************************************************************/

/* Note that the functions of RxPRF.DLL have to be already registered!  */

parse arg MailInFile

call on NOTREADY name eof_reached


/*#################################################*/
/*#              set up                           #*/
/*#################################################*/

True					= 1
False				= 0

ETCPath				= value('ETC',,'OS2ENVIRONMENT')
MAILPath				= value('MAILDIR',,'OS2ENVIRONMENT')
MailOutFile			= left(MailInFile, (length(MailInFile)-4))'.rsp'
LogFile				= ETCPath'\mailproc.log'
ContactAddress		= 'postmaster@isan.troitsk.ru'
Hostname				= value('HOSTNAME',,'OS2ENVIRONMENT')
Domain				= RxPrfGetDomain()

if pos(Hostname, ".") == 0 then
	HostDomain = Hostname'.'Domain
else
	HostDomain = Hostname



/*#################################################*/
/*#              main routine                     #*/
/*#################################################*/

ReturnPath = ''

Line = linein(MailInFile)
do while length(Line) > 0

	if left(Line,8) == 'Subject:' then
	 do
		parse value Line with Subject User Password CommandArguments
		parse value CommandArguments with Command Arguments
		parse value Arguments with Argument1 Argument2
		if User=="HELP" | User=="help" then
			Command = "HELP"
		parse upper value Command with Command
	 end

	if left(Line,12) == 'Return-Path:' then
		do
		 parse value Line with . ReturnPath
		 if left(ReturnPath, 1) == '<' then
			ReturnPath = substr(ReturnPath, 2, length(ReturnPath)-2)
		end

	if left(Line,5) == 'From:' then
		do
		 parse var Line NameOrAddress1 NameOrAddress2
		 if(pos(NameOrAddress1, "@") > 0) then
			do
			 FromName = NameOrAddress2
			 FromAddress = NameOrAddress1
			end
		 else
			do
			 FromName = NameOrAddress1
			 FromAddress = NameOrAddress2
			end
		end

	Line = linein(MailInFile)

end

if length(ReturnPath) > 0 then
	FromAddress = ReturnPath

call log('Received mail from ' FromAddress)


select
	when (Command='CHANGE_PASSWORD') & (Argument2=="") then
		call change_password
	when (Command='FORWARD_MAIL') & (Argument2=="") then
		call forward_mail('1')
	when (Command='FORWARD_COPY') & (Argument2=="") then
		call forward_mail('2')
	when (Command='STOP_FORWARD') & (Arguments=="") then
		call stop_forward
	when (Command='SEND_NOTIFICATION') then
		call send_notification
	when (Command='STOP_NOTIFICATION') & (Argument2=="") then
		call stop_notification
	when (Command='GET_STATUS') & (Arguments=="") then
		call get_status
	when Command='HELP' then
		call help
	otherwise
		call unknown_command
end

rc = lineout(MailInFile)

call log('Finished mail processing')


exit


/*#################################################*/
/*#          mail processor commands              #*/
/*#################################################*/


/*****************************/
/* change_password           */
/*****************************/

change_password:

	call log('... password change request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 rc = RxPrfSetPassword(User, Argument1, Argument1, Password)
		 call write_robot_header
		 rc = lineout(MailOutFile, '*** Password has been successfully changed.')
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... password has been changed')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return


/*****************************/
/* get_status                */
/*****************************/

get_status:

	call log('... status requested')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 call write_robot_header
		 rc = lineout(MailOutFile)
		 'accounts -d 'User' >>'MailOutFile
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... user status displayed')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* forward_mail              */
/*****************************/

forward_mail:

	parse arg ForwardCopy

	call log('... mail forward request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 call write_robot_header
		 OwnAddress = User'@'HostDomain
		 if(Argument1 <> OwnAddress) then
			 do
			  rc = RxPrfSetForwardAddress(User, Argument1, ForwardCopy,1)
			  rc = lineout(MailOutFile, '*** Mail forwarding has been activated.')
			  if (ForwardCopy == 2) then
				do
				  rc = lineout(MailOutFile, '*** A copy of every incoming mail will be forwarded to 'Argument1 )
				  rc = lineout(MailOutFile, '*** The original mails will be keep for POP3 retrieval on this system.' )
				  call log('... copy forward has been activated')
				end
			  else
				do
				  rc = lineout(MailOutFile, '*** Every incoming mail will be forwarded to 'Argument1 )
				  rc = lineout(MailOutFile, '*** No incoming mail be kept on this system.' )
				  call log('... mail forward has been activated')
				end
			  call write_contact
			  rc = lineout(MailOutFile)
			 end
		 else
			 do
			  rc = lineout(MailOutFile, '*** Mail forwarding has NOT been activated.')
			  rc = lineout(MailOutFile, '*** The forward address specified would create a loop.')
			  call write_contact
			  rc = lineout(MailOutFile)
			  call log('... forward has not been activated in order to avoid loop')
			 end
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* stop_forward              */
/*****************************/

stop_forward:

	call log('... stop forward request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 rc = RxPrfSetForwardAddress(User, " ", 1,-2)
		 rc = RxPrfSetForwardAddress(User, " ", 2,-2)

		 call write_robot_header
		 rc = lineout(MailOutFile, '*** Mail forwarding has been deactivated.')
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... mail forward has been deactivated')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* send_notification         */
/*****************************/

send_notification:

	call log('... request: sent_notification')

	if RxPrfCheckPassword(User, Password) then
		do
		 NotificationFile = MAILPath'\'User'\notify.txt'
		 rc = SysFileDelete(NotificationFile)
		 eof = FALSE
		 do while (\ eof)
			Line = linein(MailInFile)
			rc = lineout(NotificationFile, Line)
		 end

		 call write_robot_header
		 rc = RxPrfSetNotification(User, Arguments)
		 rc = lineout(MailOutFile, '*** Email sender notification has been activated.')
		 rc = lineout(MailOutFile, '*** Everyone sending an email to you will receive')
		 rc = lineout(MailOutFile, '*** a notification email from you with subject:')
		 rc = lineout(MailOutFile, '*** 'Arguments)
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... sender notification is active now')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* stop_notification         */
/*****************************/

stop_notification:

	call log('... request: stop_notification')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 NotificationFile = MAILPath'\'User'\notify.txt'
		 rc = SysFileDelete(NotificationFile)
		 call write_robot_header
		 rc = RxPrfSetNotification(User, "")
		 rc = lineout(MailOutFile, '*** Email sender notification stopped.')
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... sender notification was stopped')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* help                      */
/*****************************/

help:

	call write_robot_header
	call write_help
	call write_contact
	rc = lineout(MailOutFile)
	call log('... help requested has been answered')

	return



/*****************************/
/* unknown_command           */
/*****************************/

unknown_command:

	call write_robot_header
	rc = lineout(MailOutFile, '*** Command/Parameter error: 'CommandArguments)
	rc = lineout(MailOutFile, '')
	call write_help
	call write_contact
	rc = lineout(MailOutFile, '   ----- Original message follows -----')
	rc = lineout(MailOutFile, '')
	call write_original_mail
	rc = lineout(MailOutFile)
	call log('... command/parameter error: 'CommandArguments)

	return



/*#################################################*/
/*#              sub procedures                   #*/
/*#################################################*/


/*****************************/
/* write_robot_header        */
/*****************************/

write_robot_header:

	rc = lineout(MailOutFile, 'This mail was created by an automatic mail processor.')
	rc = lineout(MailOutFile, 'PLEASE DO NOT REPLY TO THIS MAIL.')
	rc = lineout(MailOutFile, '')

	return


/*****************************/
/* write_contact             */
/*****************************/

write_contact:

	rc = lineout(MailOutFile, '')
	rc = lineout(MailOutFile, 'If you have any questions, suggestions or problems - please contact:')
	rc = lineout(MailOutFile, ContactAddress)
	rc = lineout(MailOutFile, '')

	return



/*****************************/
/* write_help                */
/*****************************/

write_help:

	 HelpFile = ETCPath'\mailproc.hlp'
	 eof = FALSE
	 do while (\ eof)
		Line = linein(HelpFile)
		rc = lineout(MailOutFile, Line)
	 end

	return



/*****************************/
/* write_original_mail       */
/*****************************/

write_original_mail:

	MailInFilePos = 0
	MailInFileSize = stream(MailInFile, 'c', 'query size')
	do while (MailInFilePos<MailInFileSize)
		rc = lineout(MailOutFile, Line)
		Line = linein(MailInFile)
		MailInFilePos=MailInFilePos+length(Line)+1
	end
	rc = lineout(MailInFile)

	return


/*****************************/
/* refuse_action             */
/*****************************/

refuse_action:

	call write_robot_header
	rc = lineout(MailOutFile, '*** You are not authorized for the requested action!')
	call log('... no authorization for requested action')

	return



/*****************************/
/* log                       */
/*****************************/

log:

	parse arg LogString

	rc = lineout( LogFile, date(european)' 'time(normal)'' LogString )

	return


/*****************************/
/* not_ready                 */
/*****************************/

eof_reached:

	eof = TRUE
	return