/* X500 look up (LDAPSearch wrapper) */
/* by Christopher McRae, 1997        */

Parse arg Name

if Name='' then do
 say 'Syntax: lookup <name>'
 exit
end /* if */

Item.=''
Item.cn =                      'Name'
Item.SN =                      "Surname"
Item.personalTitle=            "Personal Title"
Item.title=                    "Position"
Item.postalAddress=            "Postal Address"
Item.telephoneNumber=          "Telephone Number"
Item.facsimileTelephoneNumber= "Fax"
Item.mail=                     "E-Mail Address"
Item.roomNumber=               "Room Number"
Item.otherMailbox=             "Alternate Email Address"
Item.labeledURI=               "More Info (URL)"
Item.lastModifiedTime=         "Last Modified"
Item.lastModifiedBy=           "Modified By"
Item.acl=                      "Access Control List"
Item.phoneBookVersion=         "Phonebook Version"

Blue='1b'x||'[47m'
Default='1b'x||'[0m'


/* Default Parameters */
LDAPServer='x500.mq.edu.au'
LDAPPort='389'
BaseDN='o=Macquarie University, c=AU'
BaseDN2='ou=School of Chemistry, o=Macquarie University, c=AU'
DisplayFields='cn title postalAddress telephoneNumber facsimileTelephoneNumber mail roomNumber otherMailbox lastModifiedTime'
DisplayFields2='cn'

/*
newq = RXQUEUE('Create')       /* create a unique queue */
oq = RXQUEUE('Set',newq)       /* establish new queue */
*/

/*
'@ldapsearch -h 'LDAPServer' -p 'LDAPPort' -b "'BaseDN'" "cn=*'Name'*" 'DisplayFields
*/


'@ldapsearch -L -u -h 'LDAPServer' -p 'LDAPPort' -b "'BaseDN2'" "cn=*'Name'*" 'DisplayFields' |rxqueue'

i=1
do queued()
   parse pull X500data.i
   i=i+1
end  /* Do */

X500Data.0=i-1

/*
call RXQUEUE 'Delete',newq     /* destroy unique queue created  */
call RXQUEUE 'Set',oq          /* reset to default queue (not required)*/
*/
/*
say Default
say Blue||copies(' ',length(substr(X500Data.2,6)))||Default
say Blue||substr(X500Data.2,6)||Default
say Blue||copies(' ',length(substr(X500Data.2,6)))||Default
*/

say
say '1b'x||'[5m'substr(X500Data.2,6)||Default
say
do i=3 to X500Data.0
  parse var X500Data.i AttributeName ':' AttributeData
  AttributeName=translate(strip(AttributeName))
  if AttributeName=LastAttributeName then
     AttributeName=''
  else
     LastAttributeName=AttributeName

  if pos('$',AttributeData)>0 then do
       parse var AttributeData temp '$' AttributeData
       say overlay(Item.AttributeName,' ',,25)': 'strip(temp)
       do while pos('$',AttributeData)>0
          parse var AttributeData temp '$' AttributeData
          say copies(' ',25)': 'strip(temp)
       end /* while */
       say copies(' ',25)': 'strip(AttributeData)
     end
  else do
     say overlay(Item.AttributeName,' ',,25)': 'Strip(AttributeData)
  end /* if */
end i

