/* REXX */

/*
 *  File     : TS_TUNE
 *  Purpose  :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app = 'TS_TUNE'
interface.0 = 0


/* look for the interfaces */

rc = status(app, 'INFO', 'Looking for interfaces')
DO QUEUED() ; PULL message ; END
'@netstat -r | rxqueue'
PULL crap
PULL crap
PULL crap
DO QUEUED()

   PARSE PULL destination router netmask refcnt use flags metric intrf

   intrf = STRIP(intrf)

   IF LENGTH(intrf) > 0 THEN DO

      found = 0
      IF interface.0 > 0 THEN DO
         DO loop = 1 TO interface.0
            IF interface.loop = intrf THEN found = 1
         END
      END

      IF \ found THEN DO
         rc = status(app, 'INFO', 'Found interface:' intrf)
         temp           = interface.0 + 1
         interface.0    = temp
         interface.temp = intrf
      END

   END

END


/* tune the interfaces */

/* load the REXX utility package */

CALL RXFuncAdd SysSleep, RexxUtil, SysSleep
rc = SysSleep(5)


/* tune the interfaces */

rc = status(app, 'INFO', 'Tuning interface MTUs')
DO loop = 1 TO interface.0

   mtu = 4096
   IF SUBSTR(interface.loop, 1, 5) = 'slave' THEN mtu = mtu - 44
   '@ifconfig' interface.loop 'mtu' mtu

END

RETURN 0
