/*
 * Cirrus Technology, Inc.      1995
 *
 * install.cmd - Determines the product being installed based on the 
 *               .TXT file it finds in the current area or on the current
 *               diskette.  Passes the install program info for generating 
 *               .err & .log files of the installation.
 *
 */

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

/* trace ?all */

starting_dir = directory()

rc = SysFileTree('cirrus.exe', found., 'FO')
do while found.0 = 0
   say
   say "*** ATTENTION ***"
   say "Install files not found in current directory."
   say "Enter the location of the Cirrus Technology product install files"
   say " (full drive and path name)"
   say
   say "Enter X to exit this install"
   say
   pull thislocation

   xx = pos(":",thislocation)
   if xx = 0 then do
      say
      say "No drive specified."
      say
      found.0 = 0
   end
   else do
      /* parse out the drive and then set the default to that drive */
      thisdrive = substr(thislocation,1,xx)
      cmdstr = thisdrive
      address cmd cmdstr
      thisdir = substr(thislocation,xx+1)
      cmdstr = "cd "thisdir
      address cmd cmdstr
      rc = SysFileTree('cirrus.exe', found., 'FO')
   end 
end /* do */

rc = SysFileTree('*.txt', found., 'FO')

if found.0 = 1 then do
   /* remove the drive designation from the filename */
   x = (pos('\',found.1)) + 1
   filename = substr(found.1,x,length(found.1))
end  /* Do */

/* get the current directory and then force it to uppercase */
curdir = DIRECTORY();
curdir = translate(curdir)

filename = strip(filename)
filename = substr(filename,1,length(filename)-4)
errfile = "c:\"filename".err"
logfile = "c:\"filename".log"
/*
rc = SysFileTree(errfile, found.0, 'F')
if found.0 = 1 then do
   cmdstr = "del "errfile
   address cmd cmdstr
end
*/  /* Do */

cmdstr = "cirrus /L1:"errfile" /L2:"logfile" /s:"curdir
address cmd cmdstr

xx = pos(":",starting_dir)
/* parse out the drive and then set the default back to the original area */
thisdrive = substr(starting_dir,1,xx)
cmdstr = thisdrive
address cmd cmdstr
thisdir = substr(starting_dir,xx+1)
cmdstr = "cd "thisdir
address cmd cmdstr

