/* W. Gregg, Address.cmd (Rexx/os2 Jan. 2003) */
/* Manually type #10 envelopes on certain HP Deskjets (e.g. 930c) */
call initialize
parse arg RAFile .
call GetReturnAddress
call GetSubject
call CapSubject
call GetNotation
call GetAddressee
call Showit
call GetPrintYN
if print='N' then exit
call InsertEnv
call PrintEnv
exit

showit:
/* Make all envelope lines blank */
   do i=1 to 18
     line.i=''
   end /* do */
/* Draw line */
   line.1=copies('_',screenwidth)
/* Place return address, nominally lines 3-5 */
   do j=1 to ra.0
     i=topmargin+j
     line.i=ra.j
   end /* do */
/* Place subject two lines below return address, nominally line 8 */
   i=topmargin+ra.0+3
   line.i=subject
/* Place notation flushright one line below notation, nominally line 9 */
   i=i+1
   line.i=copies(' ',screenwidth)
   line.i=overlay(notation,line.i,screenwidth-length(notation)+1)
/* Place addressee on line 14, nominally 4 inches from left */
   do j=1 to ad.0
     i=13+j
     line.i=copies(' ',40)||ad.j
   end /* do */
/* Draw line */
   line.18=copies('_',screenwidth)
do i=1 to 18
  say line.i
end /* do */
return

GetReturnAddress:
/* Returns data in varible ra.1 to ra.0, where ra.0 is the linecount. */
/* We can enter with rafile nul or data that may be a valid filename. */
  if rafile\='' then rafile=stream(rafile,'c','query exists')
  i=0
  ra.0=0
  if rafile\=''
    then
      do forever
        string=linein(rafile)
        if string='' then leave
        Say string
        i=i+1
        ra.0=i
        ra.i=string
      end /* do */
    else
      Say 'Return address?'
      Do forever
        parse pull string
        if string='' then leave
        i=i+1
        ra.0=i
        ra.i=string
      End /* do */
  /* End if then else */
return ra.0

GetSubject:
/* Returns data in variable 'subject'. */
  Say 'Subject or notation to addressee?'
  subject=''
  parse pull subject
  say
return subject

GetNotation:
/* Returns data in variable 'notation'. */
  Say 'Notation to post office?'
  notation=''
  parse upper pull notation
  say
return notation

GetAddressee:
/* Returns data in variable ad.1 to ad.0, where ad.0 is the linecount. */
  Say 'Addressee?'
  i=0
  ad.0=0
  do forever
    parse pull string
    if string='' then leave
    i=i+1
    ad.0=i
    ad.i=string
  end /* do */
return ad.0

GetPrintYN:
  do forever
    say 'Print (Y/N)?'
    pull print
    print=substr(print,1)
    if print='Y' then leave
    if print='N' then leave
  end /* do */
return

InsertEnv:
  Say
  Say 'If envelope has a triangular flap, tuck it in.'
  Say 'Insert envelope with flap to the RIGHT and facing UP.'
  say 'Press the 'Enter' key when ready...'
  pull .
return

initialize:
  call RxFuncAdd 'SysTempFileName','RexxUtil','SysTempFileName'
  call RxFuncAdd 'SysFileDelete','RexxUtil','SysFileDelete'
topmargin=1       /* 1 line is effectively 2 on printed envelope */
  screenwidth=78
  printwidth=84     /* To pull margin back appropriately, use 84, not 87 */
  esc=d2c(27)
  reset=esc||'E'
  landscape=esc||'&l1O'
  fixedpitch=esc||'(s0P'
  cpi10=esc||'(s10H'
  pts12=esc||'(s12V'
  courier=esc||'(s3T'
  courier2=esc||'(s4099T'
  draft=esc||'(s1Q'
  final=esc||'(s2Q'
  lpi6=esc||'&l6D'
  No10landscape=esc||'&l-81A'
  leftmargin0char=esc||'&a0L'
  rightmargin87char=esc||'&a87M'
  topmargin0lines=esc||'&l0E'
  boldon=esc||'(s3B'
  boldoff=esc||'(s0B'
return

PrintEnv:
output='c:\temp.pcl'
output=SysTempFileName(env?????.pcl)
init=reset||landscape||fixedpitch||cpi10||pts12||courier2||draft||lpi6
init=init||No10landscape||Leftmargin0char||Rightmargin87char||topmargin0lines
/* Make all envelope lines blank */
   do i=1 to 18
     line.i=''
   end /* do */
/* Initialize printer at line.1 */
   line.1=init
/* Place return address, nominally lines 3-5 */
   do j=1 to ra.0
     i=topmargin+j
     line.i=ra.j
   end /* do */
/* Place subject two lines below return address, nominally line 8 */
   i=topmargin+ra.0+3
   line.i=boldon||subject||boldoff
/* Place notation flushright one line below notation, nominally line 9 */
   i=i+1
   line.i=copies(' ',printwidth)
   line.i=overlay(notation,line.i,printwidth-length(notation)+1)
/* Place addressee on line 14, nominally 4 inches from left */
   do j=1 to ad.0
     i=13+j
     line.i=copies(' ',40)||ad.j
     if j=ad.0 then line.i=line.i||reset
   end /* do */
do i=1 to 18
  x=lineout(output,line.i)
end /* do */
x=stream(output,'c','close')
'@copy/b' output 'prn >nul'
x=SysFileDelete(output)
if x\=0 then say "Unable to delete temporary file:" output
return

CapSubject:
  string=''
    do i=1 to words(subject)
      word=word(subject,i)
      word=translate(substr(word,1,1))||substr(word,2)
      string=string||word||' '
    end /* do */
    subject=string
  string=''
return subject
