/*********************************************************************
  FX80.cmd
 *********************************************************************

   This is the GERMAN VERSION of FX80.cmd

   REXX-Script, um deutsche ASCII-Dateien 2-spaltig in kleiner
   Schrift auszudrucken.

  Untersttzte Druckeroptionen:
    SCR -- Bildschirm, 10 Zeile/Seite, Spaltenbreite 30
    FXS -- FX80, 150 Zeilen/Seite, Spaltebreite 79
    FXE -- FX80, 1-Spaltig, Elite

  Der OS/2 Druckerspooler sollte ausgeschaltet sein, es kann aber auch
  sein, dass es mit dem Spooler funktioniert.

 *********************************************************************

  Dieses REXX-Script ist FREEWARE. Benutzung und Anpassung ausdrcklich
  erlaubt, solange u.a. CopyRight-Nachricht im Source verbleibt.

  Falls jemand Funktionalitt hinzufgt, bitte ich darum, die modifizierte
  Quelle zugeschickt mit einem kurzen Kommentar zugeschickt zu bekommen.
  Adresse:  Ralf Grohmann, Winterlinger Weg 8, 70567 Stuttgart, Germany
            oder per email: ralf@ubka.uni-karlsruhe.de

   (c) Ralf Grohmann 8/93, 1/94
 *********************************************************************/
ARG DATEI MODE opt1 opt2

say '**** ASCII-Datei - Drucker V 1.0                   (c) 1993 Ralf Grohmann ****'

IF mode<>'FXS' & mode <>'FXE' & mode<>'SCR' then do
    call help
    EXIT
    END
IF datei='/h' | datei='/?' | datei='-?' | datei='-h' then do
    call help
    EXIT
    END

IF lines(datei)=0 then do
    say 'Fehler Datei <' datei '> nicht gefunden!'
    EXIT
    END

/* Parse Options */
pagepause=no
test=no
opt1=left(opt1,2)
opt2=left(opt2,2)
if opt1='/P' | opt2='/P' then pagepause=yes
if opt1='/T' | opt2='/T' then test=yes



/****  Druck-Parameter: *****
  initstring : Initialisierungs-String fr Ausgabemedium (binaer)
  sep:         Separator (Zwischen den Spalten, Breite:2)
  cret:        Newline (Um eine neue Zeile zu beginnen)
  ffeed:       FormFeed (Am Ende jeder Seite gesendet)
  pglen:       Seitenlaenge
  maxzl:       Spaltenbreite
  pageno:      Anfangs-Seitennummer
  protocol:    yes|no (ob eine Zustandsanzeige generiert werden soll)
  dest:        Ziel der Ausgabe, 'prn:' oder 'stdout:' oder so
  dotrans:     yes|no (Ob eine Zeichenumsetzung durchgefhrt werden soll)
  columns:     Anzahl Spalten pro Zeile, 1 oder 2
*/

IF MODE='FXS' THEN DO
/*****  EPSON FX80+ kleinst-modus ********
   Printer auf Deutsch, kleine Schrift, kein Rand schalten.
     ESC @        Reset
     ESC R (2)    Deutsch
     ESC 6        allow Chars > 127
     ESC (15)     Schmalschrift
     ESC M        Elite
     ESC 3 (15)   15/216 inch line spacing
     ESC S 0      Superscript
     ESC Q (160)  Max Rechter Rand
*/
initstring='@R6M3S0Q'
sep='  '
cret = D2C(13) D2C(10)
ffeed = D2C(12)
pglen=150
maxzl=79
pageno=1
protocol=YES
dest='prn:'
dotrans=yes
columns=2
END

IF MODE='FXE' THEN DO
/*****  EPSON FX80+ Elite, 1spaltig ********
   Printer auf Deutsch, Elite, Rand 5 schalten.
     ESC @        Reset
     ESC R (2)    Deutsch
     ESC 6        allow Chars > 127
     ESC M        Elite
     ESC l (5)    Linker Rand 5
     ESC 0        Zeilenabstand 1/8 Zoll
*/
initstring='@R6Ml0'
sep=''
cret = D2C(13) D2C(10)
ffeed = D2C(12)
/* 85 Zeilen sind fr 12" Endlos-Papier */
pglen=85
maxzl=90
pageno=1
protocol=YES
dest='prn:'
dotrans=yes
columns=1
END

/***** Preview auf Screen ******/
IF mode='SCR' THEN DO
initstring='';
sep='  '
cret = D2C(13) || D2C(10);
ffeed = '************---- NAECHSTE SEITE -----****************'
pglen=10
maxzl=38
pageno=1
protocol=no
dest='stdout:'
dotrans=no
columns=2
END


/* HeaderString */
if columns=2 then do
hstr='Ausdruck Datei <' right(datei,min(length(datei),30)) '> am ' DATE(E)
hstr=left(hstr,maxzl*2-10) ' Seite: '
hstr2=right('',maxzl*2+length(sep),'-')
end
else do
hstr='Ausdruck Datei <' right(datei,min(length(datei),30)) '> am ' DATE(E)
hstr=left(hstr,maxzl-12) ' Seite: '
hstr2=right('',maxzl,'-')
end

/* Drucker initialisieren */
r=out(initstring);

/***** EINLESEN **********/
i=1
side=0
aktzl=0
DO WHILE lines(datei)
  instring=LINEIN(datei)
  if length(instring)>maxzl then
       in.i.side=LEFT(instring,maxzl-1) || '>'
  else in.i.side=LEFT(instring,maxzl)
  aktzl=aktzl+1
  i=i+1
  IF i=pglen+1 & side=0 THEN DO
          side=1
          if columns=1 then DO
            CALL printside
            side=0
            DROP in.
            END
          i=1
          END
  IF i=pglen+1 & side=1 THEN DO
          CALL printside
          side=0
          i=1
          DROP in.
          END
END /* DO WHILE LINES */

/* DEBUG: SAY 'xxxx' i side columns */
if i >= 1 THEN DO
          CALL printside
          DROP in.
          END

if test=no then SAY 'Datei ' datei ' gedruckt (' aktzl ' Zeilen, ' pageno-1' Seiten ).'
 else SAY 'Datei ' datei ' getestet (' aktzl ' Zeilen, ' pageno-1' Seite(n) ).'
r=out('')
EXIT


/*********************************************************************/
/* Prozedur um eine Seite zu drucken */
/* printside: PROCEDURE EXPOSE pglen in. sep cret */
printside:
/* DEBUG say '***** i= ' i ' side= ' side */

IF protocol=yes THEN say 'Drucke Seite ' pageno
r=out(hstr || format(pageno,3) || cret || hstr2 )
pageno=pageno+1
if columns=2 then DO pr_t = 1 TO pglen BY 1
  DROP temp
  IF side=0 & i > pr_t THEN temp=in.pr_t.0 || sep
  IF side=0 & i <= pr_t THEN leave
  IF side=1 & i > pr_t THEN temp=in.pr_t.0 || sep || in.pr_t.1
  IF side=1 & i <= pr_t THEN temp=in.pr_t.0 || sep
  r=out(temp)
 END
ELSE DO pr_t = 1 TO pglen BY 1
 if pr_t < i then r=out(in.pr_t.0)
 END
r=out(ffeed)
if pagepause=yes then do
   say 'Return fr nchste Seite'
   parse pull arg
   end
RETURN

/*********************************************************************/
/* Prozedur zum Ausdrucken
   Ruft evtl. vorher die Zeichenumsetzungsroutine auf */
out:
PARSE ARG string

if dotrans=yes then outstring = deutsch(string) || cret
   else outstring = string || cret
if test=no then do
    res=CHAROUT(dest , outstring )
    if res <> 0 THEN
        SAY 'Fehler! ' res ' Zeichen konnten nicht ausgegeben werden.'
    END
RETURN 0

/*********************************************************************/
/* Setze alle Spezialzeichen um */
deutsch: PROCEDURE
parse arg str
/* Syntax Translate(str, to, from) */
str=TRANSLATE(str,'{','')
str=TRANSLATE(str,'|','')
str=TRANSLATE(str,'}','')
str=TRANSLATE(str,'[','')
str=TRANSLATE(str,'\','')
str=TRANSLATE(str,']','')
str=TRANSLATE(str,'~','')
RETURN str

/*********************************************************************/
/* Hilfe-Ausgabe */
help: PROCEDURE
SAY
SAY 'Aufruf: fx80 <Name-of-file-to-be-printed> <mode> [opts]'
SAY
SAY 'mode: FXS|FXE|SCR  (Ausgabemedium angeben)'
SAY '       FXS - Kleinstschrift auf FX'
SAY '       FXE - 1spaltig, Elite auf FX'
SAY '       SCR - Testausgabe auf Bildschirm'
SAY 'opts:  /Test - Ausgabe nicht ausfhren.'
SAY '       /Pagepause  - Warten nach jeder Seite?'
RETURN
