:userdoc.
:title.Help for Print Envelope
:body.

:h1 res=1. Extended Help for Print Envelope
:p.The Print Envelopes program helps you print
envelopes, using any printer supported by OS/2 which
can print envelopes.

:p.You type the address and return address
in easy-to-use multi-line edit fields.  You may save them to avoid
retyping during subsequent envelope printing runs.

:p.This is a free program,
and full C language
:link reftype=hd refid=srccode.source code:elink.
is provided.

:p.:link reftype=fn refid=db.Dave Briccetti &amp. Associates:elink.
.br
P.O. Box 1713
.br
Lafayette, CA  94549-7013
.br
USA
:p.CompuServe: 74475,1072
:p.Copyright (c) 1990, David C. Briccetti
.br
All rights reserved.

:fn id=db.
:p.Dave Briccetti is an independent OS/2 programming consultant.
He has been working with OS/2 since 1987.  He has one software
product, :hp3.MsgVu:ehp3., a tool for managing files of
electronic correspondence.  For clients, he has developed OS/2
software for the data communications and mechanical engineering
fields.
:efn.

:h1 id=srccode.Source Code
:i1.Source code
:p.The PMEnv source code contains
examples of the following:
:ul.
:li.Multi-threaded printing, including multiple instances
of a second thread function
:i1.Multi-threaded printing
:li.Queued device contexts
:i1.Queued device contexts
:li.Device-independent printing
:i1.Device-independent printing
:li.Graphics text output using GPI
:i1.Graphics text output using GPI
:li.Profile management
:i1.Profile management
:li.Dialog box handling
:i1.Dialog box handling
:li.Multi-line edit controls
:i1.Multi-line edit controls
:li.Online help using IPF
:i1.Online help using IPF
:eul.

:h1 res=12. Return Address
:i1. Return Address
:p.The :hp2.Return Address:ehp2. multi-line edit
field is where you type the
return address to be printed in the upper-left
corner of the envelope.

:h1 res=13. Address
:i1. Address
:p.The :hp2.Address:ehp2. multi-line edit field is where you type the
address to be printed on the envelope.

:h1 id=prt res=20.Printer
:i1 id=iprt.Printer
:p.The :hp2.Printer:ehp2. radio buttons let you select how PMENV
controls the printer.

:h4.HP LaserJet
:i2 refid=iprt.HP LaserJet
:p.If you select :hp2.HP LaserJet:ehp2., PMENV will command the printer
with Hewlett Packard Printer Control Language (PCL).  By using PCL, PMENV
can send the commands to put the printer into landscape mode and to
cause the printer to prompt you to insert an envelope.

:h4.Generic
:i2 refid=iprt.Generic
:p.If you select :hp2.Generic:ehp2., PMENV will use standard,
device-independent Presentation Manager facilities to access the
printer.

:h1 res=22.Top Margin
:i1.Margin, top
:p.The :hp2.Top Margin:ehp2. is the number of blank lines printed
above the return address.
.im marnote.hlp

:h1 res=23.Left Margin
:i1.Margin, left
:p.The :hp2.Left Margin:ehp2. is the number of columns of
blank space preceding the return address.
.im marnote.hlp

:h1 res=17. Print
:i1 id=iprtbut.Print
:p.The :hp2.Print:ehp2. button causes an
envelope to be printed, using the
return address and address which are currently displayed.

:h4.Multi-threaded Printing
:i2 refid=iprtbut.Multi-threaded
:p.It may take several seconds for each envelope to be spooled
for printing after you press the Print button.  But since PMENV
is
:link reftype=fn refid=thread.
multi-threaded
:elink.
, you may continue to interact with
it while the spooling takes place.  You may type another address,
use any of the controls,
and even press the Print button again.
PMENV will create as many threads
as necessary to satisfy your print requests,
and will spool multiple envelopes concurrently.

:fn id=thread.
A :hp3.multi-threaded:ehp3. application is one that can perform
more than one task concurrently, such as producing print output
while continuing to interact with the user.
:efn.

:h1 res=16. Save
:i1. Save
:p.The :hp2.Save:ehp2. button saves the following in the OS/2
user profile:
:ul.
:li.Address
:li.Return address
:li.Printer type
:li.Margins
:eul.
:p.These values will be automatically restored when you
next run the program.

:h1 res=15.Defaults
:i1. Defaults
:p.The :hp2.Defaults:ehp2. button restores all controls to their
default values.  The address and return address fields
are cleared to blanks.

:index.

:euserdoc.
