/* PRTUP v 2.01 */
Say "PRTUP Version 2.01"
Say "by Albert Crosby  -- Freely redistributable"
Say
/* Print 1 or 2 UP on IBM PPDS or HP PCL printer */
/* <<Created by Albert Crosby 12-03-92>> */

/* Default values */
mode='I'   /* Default printer */
nup=2      /* Default number up */
tabs=4     /* Default tab expansion size */
wrap=9999  /* Default line wrap size */
/* True (1) or False (0) Defaults */
frame=1    /* Framed Output */
ans=0      /* ANSI CC support */
num=0      /* Numbered lines */
xpand=0    /* Expand tabs */


/* Initialize variables */
file=''
formchar=''
pgsep=''
outf=''

parse arg line
if line='?'|line='' then signal tell

param=''
rest=''
do while line\=''
   select
       when left(line,1)='/' then do
           /* A FLAG */
           parse var line '/' +1 flag +1 line
           if left(line,1)='"' then parse var line '"' param '"' line
           else if left(line,1)\=' ' then do
               parse var line param line
               if pos('/',param)>0 then do
                   parse var param param '/' +0 extra
                   line=extra||' '||line
               end
               if pos('"',param)>0 then do
                   parse var param param '"' +0 extra
                   line=extra||' '||line
               end
               flag=flag||param
           end
           /* Add code here for interpreting flags */
           flag=translate(flag)
           str=''
           select
               when flag='1' then nup=1
               when flag='2' then nup=2
               when abbrev('ANSI',flag) then ans=\ans
               when abbrev('FRAMED',flag) then frame=\frame
               when abbrev('NUMBERED',flag) then num=\num
               when abbrev('WRAP',flag) then do
                   Call GetStr
                   if datatype(str,'W') then wrap=str
                   else do
                       line=str||' '||line
                       wrap=0
                   end
               end
               when left(flag,1)='W' then do
                   if datatype(param,'W') then wrap=param
                   else wrap=0
               end
               when abbrev('EXPAND',flag) then do
                   xpand\=xpand
                   Call GetStr
                   if datatype(str,'W') then tabs=str
                   else do
                       line=str||' '||line
                   end
               end
               when left(flag,1)='E' then do
                   xpand\=xpand
                   if datatype(param,'W') then tabs=param
               end
               when abbrev('PRINTER',flag) then do
                   Call GetStr
                   mode=translate(left(str,1))
               end
               when left(flag,1)='P' then mode=translate(left(param,1))
               when abbrev('OUTPUT',flag) then do
                   Call GetStr
                   outf=str
               end
               when left(flag,1)='O' then outf=param
               when abbrev('SEPERATOR',flag) then do
                   Call GetStr
                   pgsep=str
                   if pgsep='' then pgsep='='
               end
               when left(flag,1)='S' then do
                   pgsep=param
                   if pgsep='' then pgsep='='
               end
               when abbrev('BOXCHARS',flag) then do
                   Call GetStr
                   formchar=str
               end
               when left(flag,1)='B' then formchar=param
               otherwise Signal UNKPARM
           end
           /* End code for interpreting flags */
           param=''
           rest=''
       end
       when left(line,1)=' ' then line=strip(line)
       otherwise do
           Call GetSTR
           file=str
           If Verify(file,"*?","M")\=0 Then Signal NOWC /* No wildcards! */
           If Stream(file,'C','QUERY EXISTS')='' Then Signal NEXST
           Call PRINTFILE
       end
   end
end

if file='' then signal TELL

exit

PRINTFILE:
/* See PRTUP.DOC for instructions on modifying this section to include
   new printer definitions */

if ans then do
   ans.frame=frame
   frame=0
   ans.num=num
   num=0
end

Select /* Initialize variables based on mode and number up */
 When mode='H' Then
  do
   prn='LPT1:' /* Default printer port for HP mode */
   ff=0
   boxdef='ɻȼͺ'
   if nup=1 then 
    do
     cpl=129     /* Char/Line  */
     lpp=78      /* Lines/Page */
     ext=X2C(1B45)
     ini=X2C(1B451B266C31451B287330541B283130551B287331362E36481B2873382E35561B28733438501B266C3844)
    end
   else
    do
     cpl=84      /* Char/Line  */
     lpp=118     /* Lines/Page */
     ext=X2C(1B45)
     ini=X2C(1B451B266C314F1B266C31451B287330541B283130551B287331362E36481B2873382E35561B28733438501B266C3844)
    end
  end
 When mode='L' Then
  do
   prn='LPT1:' /* Default Printer port for EPSON Lext mode */
   ff=1
   boxdef='++++-|'
   if nup=1 then
    do
     cpl=160     /* Char/Line */
     lpp=115     /* Lines/Page*/
     ext=X2C(1B40)
     ini=X2C(1b401b78001b4e001b4d0f1b53011b41051b437f)
    end
   else 
    do
     cpl=79     /* Char/Line */
     lpp=230     /* Lines/Page*/
     ext=X2C(1B40)
     ini=X2C(1b401b78001b4e001b4d0f1b53011b41051b437f)
    end
  end
 When mode='I' then
  do
   prn='LPT1:' /* Default Printer port for IBM mode */
   ff=0
   boxdef='ɻȼͺ'
   if nup=1 then
    do
     cpl=132     /* Char/Line */
     lpp=121     /* Lines/Page*/
     ext=X2C(1B5B4B0300063101)
     ini=X2C(0F1B41061B321B5B53080000003B0000143BF6)
    end
   else
    do
     cpl=87      /* Char/Line  */
     lpp=184     /* Lines/Page */
     ext=X2C(1B5B4B0300063101)
     ini=X2C(1B6C0F1B41061B321B5B53080000003B0000143BF6)
    end
  end
 When mode='W' Then /* A "Wide" printer - modify as appropriate */
  do
   prn='LPT1:' /* Default Printer port for Wide mode */
   ff=1
   boxdef='++++-|'
   ini=''
   ext=''
   if nup=1 then
    do
     cpl=132     /* Char/Line */
     lpp=55      /* Lines/Page*/
    end
   else 
    do
     cpl=65      /* Char/Line */
     lpp=110     /* Lines/Page*/
    end
  end
 Otherwise
  do
   if mode\='O' then Say 'WARNING: Unknown printer.  Formatting Output for 80 cols, 55 lines'
   prn='LPT1:'
   ff=1
   boxdef='++++-|'
   ini=''
   ext=''
   if nup=1 then do
      cpl=80
      lpp=55
   end
   else do
     cpl=40
     lpp=110
   end
  end
end

If outf\='' then prn=outf

If pgsep\=''&length(pgsep)<pcpl then pgsep=left(copies(pgsep,pcpl),pcpl)

/* Top_Left Top_Right Bot_Left Bot_Right Middle Bar */
If formchar='' Then formchar=boxdef
formchar=substr(formchar,1,6)
bar=substr(formchar,6,1)

If frame Then Do
 hll=(cpl*2)+7
 if nup=1 Then ql=copies(substr(formchar,5,1),cpl+2)
 Else  ql=copies(substr(formchar,5,1),hll-2)
 tl=substr(formchar,1,1)||ql||substr(formchar,2,1)
 bl=substr(formchar,3,1)||ql||substr(formchar,4,1)
End
Else Do
 cpl=cpl+4/nup
 lpp=lpp+2/nup
 hll=(cpl*2)+3
 if nup=1 then tl=copies(substr(formchar,5,1),cpl)
 else tl=copies(substr(formchar,5,1),hll)
End
pcpl=cpl
If num Then pcpl=pcpl-4
x=1
no=1
pg=0
sw=0
swl=0
np=D2C(12)
tab=D2C(9)
lphp=lpp%2
Call charout prn,ini
Call HDR
Do Forever
 If lines(file)<1 Then Signal FIN
 ln=linein(file)
 If ans Then Do
  lns=substr(ln,1,1)
  ln=substr(ln,2,cpl)
 End
 If substr(ln,1,1)=np Then do
  ln=substr(ln,2)
  if pgsep\='' Then Do
   l.x=pgsep
   lprt=2
   Call CPG
   x=x+1
  End
 End
 if pgsep\='' then do
  sv=''
  t=pos(np,ln)
  do while t>0
   sv=ln
   ln=left(ln,t-1)
   Call PRTLN
   l.x=pgsep
   lprt=2
   Call CPG
   x=x+1
   ln=substr(sv,t+1)
   t=pos(np,ln)
  end
  if sv=''|ln\='' then Call PRTLN
 end
 Else do
  ln=translate(ln,' ',np)
  Call PRTLN
 End
End

PRTLN:
 If \xpand then ln=translate(ln,' ',tab)
 Else If pos(tab,ln)\=0 Then do
  t=pos(tab,ln)
  do while t>0
   ln=insert(' ',delstr(ln,t,1),t-1,tabs-t//tabs)
   t=pos(tab,ln)
  end
 End
 If ln=''&swl=1 Then sw=1
 if sw=0|ans Then do
  Do lprt=1 to length(ln)%pcpl+1
   if (lprt>1)&(wrap<1) then Leave
   if lprt>(wrap+1) then Leave
   l.x=substr(ln,1+((lprt-1)*pcpl),pcpl)
   If num&lprt=1 Then l.x=right(no,3)||' '||l.x
   If num&lprt>1 Then l.x='   '||l.x
   Call CPG
   x=x+1
   if lprt=1 then no=no+1
  End
  swl=0
 End
 If ln='' Then swl=1
 sw=0
 if ans then do
  frame=ans.frame
  num=ans.num
 end
Return

FIN:
Call PPG
Call charout prn,ext
Call stream file,'C','close'
Return

CPG:
if nup=1 then do /* 1UP CPG */
 If lprt=1&ans&(lns='0'|lns='-'|lns='1') Then Do
  sv=l.x
  l.x=' '
  Call CPG1
  If lns='1' Then Do
   x=lpp
   k=1
  End
  If lns\='1' Then x=x+1
  If lns='-' Then Do
   l.x=' '
   Call CPG1
   x=x+1
  End
  l.x=sv
 End
 Call CPG1
 Return
End
Else Do /* 2UP CPG */
 If lprt=1&ans&(lns='0'|lns='-'|lns='1') Then Do
  sv=l.x
  l.x=' '
  Call CPG1
  If lns='1' Then Do
   If x<=lphp Then x=lphp+1
   Else Do
    x=lpp
    k=1
   End
  End
  If lns\='1' Then x=x+1
  If lns='-' Then Do
   l.x=' '
   Call CPG1
   x=x+1
  End
  l.x=sv
 End
 Call CPG1
 Return
End

CPG1:
l.x=left(l.x,cpl,' ')
If x=lpp Then Do
 If k=1 Then Do
  sv=l.x
  l.x=' '
 End
 Call PPG
 Call HDR
 If k=1 Then Do
  k=0
  x=1
  l.x=sv
 End
 Else x=0
End
Return

PPG:
If nup=1 Then Do z=1 To lpp
 If frame Then l.z=bar||' '||l.z||' '||bar
 Call lineout prn,l.z
End
Else Do z=1 To lphp
 w=z+lphp
 xz=l.z||' '||bar||' '||l.w
 If frame Then xz=bar||' '||xz||' '||bar
 Call lineout prn,xz
End
If frame Then Call lineout prn,bl
Return

HDR:
pg=pg+1
if ff&pg>1 then Call Charout prn, np
if nup=1 then do
 /* 1UP Header Code */
 If frame Then Do
  dl=copies(' ',cpl+4)
  hl=strip(right(date('U'),cpl+4),'t')
 End
 Else Do
  dl=copies(' ',cpl)
  hl=strip(right(date('U'),cpl),'t')
 End
 hl=overlay(hl,dl)
 hl=overlay(file,hl)
 If frame Then hl=overlay('Page 'pg,hl,((cpl+4)%2)-2)
 Else hl=overlay('Page 'pg,hl,(cpl%2)-2)
 If mode='H' Then Call lineout prn,''
End
Else do
 /* 2up header code */
 dl=copies(' ',hll)
 hl=strip(right(date('U'),hll),'t')
 hl=overlay(hl,dl)
 hl=overlay(file,hl)
 If frame Then hl=overlay('Page      'pg,hl,cpl-1)
 Else hl=overlay('Page      'pg,hl,cpl-3)
End

/* Same for 1UP and 2UP */
If \ans then Do
 Call lineout prn,hl
 Call lineout prn,tl
End
Else if pg>1 Then Call charout prn,np
Do z=1 To lpp
 l.z=copies(' ',cpl)
End
Return

GETSTR:
line=strip(line)
if left(line,1)='/' then str=''
else if left(line,1)='"' then do
   parse var line '"' str '"' line
end
else do
   parse var line str line
   if pos('/',str)>0 then do
       parse var str str '/' +0 extra
       line=extra||' '||line
   end
   if pos('"',param)>0 then do
       parse var str str '"' +0 extra
       line=extra||' '||line
   end
end
Return

NEXST:                                                                 

Say 'The file you specified does not exist!'
Say
Signal TELL

NO2UP:
Say 'The printer you selected does not support 2 up printing.'
Say
Signal TELL

NOWC:
Say 'PRTUP cannot (presently) handle wildcards!'
Say
Signal TELL

UNKPARM:
Say 'Unknown parameter: 'flag
Say

TELL:
Say 'SYNTAX: PRTUP filespec'
Say '                [parameters]Ĵ <Ĵ '
Say '                <             '
Say '               <<< '
Say 
Say ' [parameters] are:'        
Say '        /1                  - Print 1 UP'
Say '        /2                  - Print 2 UP'
Say '        /N[umber]           - Number lines'
Say '        /A[nsi]             - ANSI controls'
Say "        /F[rame]            - don't framee page"
Say "        /P[rinter] printer  - Specify the printer to use"
Say "                              Values: IBM,HP,LQ,WIDE,OTHER"
Say "        /S[eperator] string - Specify seperator string to replace ff"
Say "        /B[oxchars] string  - Specify framing characters (default: ɻȼͺ)"
Say "        /O[utput] file      - Specify destination for output"
Say "        /W[rap] [number]    - Disable wrap or specify max wraps"
Say "        /E[xpand] [tabsize] - Expand tabs by tabsize - default 4"
