/*
 * page.h - page definitions for 'nup' program
 */

#ifndef _PAGE_H
#define _PAGE_H

#include "nup.h"

/*
 * Window Varibales
 */
 
extern  HAB     habPrinter ;
extern  HMQ     hmqPrinter ;
extern  HDC     hdcPrinter ;
extern  HPS     hpsPrinter ;

/*
 * Size of Form (Paper)
 */

extern  SIZEL   formSize  ;     /* Size of Paper            */
extern  RECTL   formClip  ;     /* Clip of Paper            */
extern  SIZEL   drawSize  ;     /* Size of Drawing Area     */
extern  RECTL   drawRect  ;     /* Drawing Area             */

extern  int     widFrame  ;     /* Slack for Page Frame     */
extern  int     widMarker ;     /* Length for Center Marker */

/*
 * Pages on a Paper
 */

#define MAXPAGES    4           /* Maximum 4 pages on a paper   */

extern  int     pagePerForm ;       /* Pages in a paper     */
extern  RECTL   pageRect[]  ;       /* Page Regions         */
extern  SIZEL   pageSize    ;       /* Page Size            */
extern  int     pageLins    ;       /* Number of lines      */
extern  int     pageCols    ;       /* Number of columns    */

/*
 * Character Cell
 */

extern  SIZEL   cellSize1 ;         /* Size of SBCS Cell    */
extern  SIZEL   cellSize2 ;         /* Size of DBCS Cell    */
extern  SIZEL   charSize  ;         /* Size of Char Box     */

/*
 * drawing options
 */

extern  BOOL    pageFrame  ;
extern  BOOL    pageMarker ;

/*
 * pageLayout - layout pages
 */

void    pageLayout(LAYPTR lay) ;

/*
 * page drawing functions
 */

int     drawOpen(PPRQINFO3 pprq, LAYPTR lay, DOCPTR doc) ;
void    drawClose(BOOL ok) ;
int     drawChar(int page, int ch) ;

#endif  /* _PAGE_H */
