/*
 * print.c - print documents
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_DOSPROCESS

#include "nup.h"
#include "page.h"
#include "resource.h"

/*
 * Controlling / Caller window
 *      control window starts print thread
 *      caller  window is caller of control window
 */

static  HWND    hwndControl = NULLHANDLE ;  /* controlling window */
static  HWND    hwndCaller  = NULLHANDLE ;  /* caller window      */

/*
 * Notify to Controlling Dialog
 */

static  void    notifyFile(DOCPTR dp)
{
#ifdef DEBUG
    printf("notifyFile %s\n", dp->fname) ; fflush(stdout) ;
#endif

    if (hwndControl != NULLHANDLE) {
        WinPostMsg(hwndControl, WM_USER_PRINT_FILE, MPFROMP(dp), NULL) ;
    }
    if (hwndCaller  != NULLHANDLE) {
        WinPostMsg(hwndCaller,  WM_USER_PRINT_FILE, MPFROMP(dp), NULL) ;
    }
}

static  void    notifyPage(int page)
{
#ifdef DEBUG
    printf("notifyPage %d\n", page) ; fflush(stdout) ;
#endif

    if (hwndControl != NULLHANDLE) {
        WinPostMsg(hwndControl, WM_USER_PRINT_PAGE, MPFROMLONG(page), NULL) ;
    }
    if (hwndCaller  != NULLHANDLE) {
        WinPostMsg(hwndCaller,  WM_USER_PRINT_PAGE, MPFROMLONG(page), NULL) ;
    }
}

static  void    notifyDone(PSZ msg)
{
#ifdef DEBUG
    printf("notifyDone %s\n", msg) ; fflush(stdout) ;
#endif

    if (hwndControl != NULLHANDLE) {
        WinPostMsg(hwndControl, WM_USER_PRINT_DONE, MPFROMP(msg), NULL) ;
    }
    if (hwndCaller  != NULLHANDLE) {
        WinPostMsg(hwndCaller,  WM_USER_PRINT_DONE, MPFROMP(msg), NULL) ;
    }
}

static  void    notifySusp(void)
{
#ifdef DEBUG
    printf("notifySusp\n") ; fflush(stdout) ;
#endif

    if (hwndControl != NULLHANDLE) {
        WinPostMsg(hwndControl, WM_USER_PRINT_SUSP, NULL, NULL) ;
    }
    if (hwndCaller  != NULLHANDLE) {
        WinPostMsg(hwndCaller,  WM_USER_PRINT_SUSP, NULL, NULL) ;
    }
}

/*
 * flag to stop printing
 */

static  BOOL    stopPrinting = FALSE ;

/*
 * printThread - print document in thread
 */

#define STKSIZ  (1024 * 32)

void    printThread(void *arg)
{
    DOCPTR  dp  ;
    FILE    *fp ;
    int     rc, ch, pg, newpg ;
    
    DosSetPriority(PRTYS_THREAD, PRTYC_NOCHANGE, -31, 0) ;
    
    habPrinter = WinInitialize(0) ;
    hmqPrinter = WinCreateMsgQueue(habPrinter, 0) ;
    
    for (dp = docFirst(&theDoc) ; dp != NULL ; dp = docNext(&theDoc, dp)) {

        if ((fp = fopen(dp->fname, "r")) == NULL) {
	    printf("printThread - file open %s\n", dp->fname) ; fflush(stdout) ;
	    continue ;
	}
	if ((rc = drawOpen(thePrt, theLay, dp)) != 0) {
	    printf("printThread - draw open %d\n", rc) ; fflush(stdout) ;
	    fclose(fp) ;
	    continue ;
	}

	notifyFile(dp) ;        /* Start New File           */
        pg = newpg = 0 ;
	
	while ((ch = fgetc(fp)) != EOF) {
	    if (stopPrinting) {
	        break ;
	    }
	    if ((newpg = drawChar(pg, ch)) != pg) {
	        notifyPage(pg = newpg) ;    /* Start of new  page   */
                DosSleep(200) ;             /* Chance to show       */
            }
	}

        if (stopPrinting == FALSE) {
            drawClose(TRUE)  ;          /* normal end   */
        } else {
	    drawClose(FALSE) ;          /* aborted      */
	}
	fclose(fp)  ;
	
	if (stopPrinting) {
	    break ;
	}
    }
    
    WinDestroyMsgQueue(hmqPrinter) ;
    WinTerminate(habPrinter) ;
    
    notifyDone(NULL) ;
}

/*
 * set printing file name
 */

static  void    setName(HWND hwnd, DOCPTR dp)
{
    HWND    hwndName = WinWindowFromID(hwnd, IDP_NAME) ;

    if (dp != NULL && dp->title != NULL) {
        WinSetWindowText(hwndName, dp->title) ;
	WinSendMsg(hwndName, EM_SETFIRSTCHAR, MPFROMSHORT(0), NULL) ;
    }
}

/*
 * set printing page number
 */

static  void    setPage(HWND hwnd, int page)
{
    UCHAR   buff[32] ;
    
    sprintf(buff, "%5d", page) ;
    WinSetWindowText(WinWindowFromID(hwnd, IDP_PAGE), buff) ;
}

/*
 * printProc - dialog procedure for print document
 */

static  BOOL    tracking = FALSE ;
static  SWP     swpCaller  ;    /* Caller's Position        */
static  SWP     swpControl ;    /* Controller's Position    */

MRESULT EXPENTRY printProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    PSZ     pStat ;
    DOCPTR  pDoc  ;
    SWP     swp   ;
    LONG    x, y  ;
    
    hwndControl = hwnd ;        /* This dialog controls print thread */
    
    switch (msg) {
    
    case WM_INITDLG :
        /*
	 * place dialog if called direct
	 */
	if (hwndCaller == NULLHANDLE) {
	    dialogAtMouse(hwnd) ;
	} else {
            dialogAtWindowBottom(hwnd, hwndCaller) ;
	}

	WinSendMsg(WinWindowFromID(hwnd, IDP_NAME),
	                EM_SETTEXTLIMIT, MPFROMSHORT(256), NULL) ;
	/*
	 * Start Print Thread
	 */
	stopPrinting = FALSE ;
	_beginthread(printThread, 0, STKSIZ, NULL) ;

        return (MRESULT) 0 ;

    case WM_USER_PRINT_FILE :
        setName(hwnd, (DOCPTR) mp1) ;
	return (MRESULT) 0 ;

    case WM_USER_PRINT_PAGE :
        setPage(hwnd, (int) mp1) ;
	return (MRESULT) 0 ;
	
    case WM_USER_PRINT_DONE :
        if ((pStat = (PSZ) mp1) != NULL) {
	    nupMessage(pStat) ;
	}
        WinDismissDlg(hwnd, TRUE) ;
	return (MRESULT) 0 ;

    case WM_COMMAND :
        switch (SHORT1FROMMP(mp1)) {
        case IDP_STOP :
	    notifySusp() ;
	    stopPrinting = TRUE ;
        }
        return (MRESULT) 0 ;

    case WM_CONTROL :
        return (MRESULT) 0 ;
    
    case WM_BUTTON1DOWN :
    case WM_BUTTON2DOWN :
        WinSendMsg(hwndControl, WM_TRACKFRAME, MPFROMSHORT(TF_MOVE), NULL) ;
	return (MRESULT) 0 ;
#if 0 
    case WM_BUTTON1DOWN :
	tracking = TRUE ;
        WinQueryWindowPos(hwndControl, &swpControl) ;
        WinSendMsg(hwndControl, WM_TRACKFRAME, MPFROMSHORT(TF_MOVE), NULL) ;
	return (MRESULT) 0 ;

    case WM_MOVE :
        if (tracking && hwndCaller != NULLHANDLE) {
	    tracking = FALSE ;
	    WinQueryWindowPos(hwndControl, &swp)      ;
	    WinQueryWindowPos(hwndCaller, &swpCaller) ;
	    if (swp.x != swpControl.x || swp.y != swpControl.y) {
                x = swpCaller.x + (swp.x - swpControl.x) ;
	        y = swpCaller.y + (swp.y - swpControl.y) ;
	        WinSetWindowPos(hwndCaller, NULLHANDLE, x, y, 0, 0, SWP_MOVE) ;
	    }
        }
        return (MRESULT) 0 ;
#endif
    }
    return WinDefDlgProc(hwnd, msg, mp1, mp2) ;
}

/*
 * printDocument - print document in 'theDoc' with 'theLay' to 'thePrt'
 */

void    printDocument(HWND hwnd)
{
    HWND    owner ;

    hwndCaller = hwnd ;

    if (hwndCaller == NULLHANDLE) {
        owner = HWND_DESKTOP ;
    } else {
        owner = hwnd ;
    }
    WinDlgBox(HWND_DESKTOP, owner, printProc, NULLHANDLE, ID_PRINT, NULL) ;
}
