#define INCL_WINSWITCHLIST
#include <os2.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

class SwitchList{
  int count;
  PSWBLOCK pswblock;
public:
  SwitchList();
  ~SwitchList(){ free(pswblock); }
  
  SWENTRY &operator[] (int n){ return pswblock->aswentry[n]; }
  int N() const { return count; }
  
  static int is_hab_initd;
  static HAB hab;
};

int SwitchList::is_hab_initd=0;
HAB SwitchList::hab;

SwitchList::SwitchList()
{
  if( ! is_hab_initd ){
    hab = WinInitialize(0);
    is_hab_initd = 1;
  }
  count = WinQuerySwitchList(hab,NULL,0);
  int size = count*sizeof(SWENTRY) + sizeof( ULONG );
  
  pswblock = (PSWBLOCK)malloc( size );
  if( pswblock != NULL ){
    WinQuerySwitchList(hab,pswblock,size);
  }else{
    count = 0;
  }
}

int main( int argc , char **argv  , BOOL fSuccess )
{
  SwitchList slist;
  
  BOOL default_value=TRUE;
  if( tolower(argv[0][0])=='b' )
    default_value = FALSE;
  
  if( argc < 2 ){
    
    const static char *progtype[] = {
      "DEF" , "FUL" , "VIO/W" , "PM" ,
      "VDM" , "???" , "???"   , "VDM/W",
    };
    
    printf("%2s%5s%4s %-3s %-5s Title\n"
	  , "No" , "PID" , "SID" , "VIS" , "TYPE" );
    
    for(int i=0; i<slist.N() ; i++ ){
      if( slist[i].swctl.fbJump == SWL_NOTJUMPABLE )
	continue;
      
      int top=
	printf("%2d%5d%4d %-3s %-5s "
	       , i
	       , slist[i].swctl.idProcess
	       , slist[i].swctl.idSession
	       , ( slist[i].swctl.uchVisibility == SWL_VISIBLE 
		  ? "YES"
		  : (slist[i].swctl.uchVisibility == SWL_INVISIBLE
		     ? "NO" : "???" ) )
	       , (  slist[i].swctl.bProgType > 8 
		  ? "???" : progtype[ slist[i].swctl.bProgType ] )
	       );
      
      for(const char *p=slist[i].swctl.szSwtitle ; *p != '\0' ; p++ ){
	putchar( *p );
	if( *p == '\n' )
	  for(int j=0;j<top;j++)
	    putchar( ' ' );
      }
      putchar( '\n' );
    }
  }

  for(int i=1 ; i<argc ; i++ ){
    BOOL fSucess=default_value;
    const char *name=argv[i];
    if( *name == '+' ){
      fSuccess = TRUE;
      name++;
    }else if( *name == '-' ){
      fSuccess = FALSE;
      name++;
    }

    if( isdigit(*name & 255) ){
      int x=atoi(name);
      if( x < slist.N() ){
	if( fSuccess != FALSE )
	  WinSwitchToProgram(slist[x].hswitch);
	WinShowWindow( slist[x].swctl.hwnd , fSuccess );
      }    
    }else{
      for(int j=0;j<slist.N();j++){
	if( strstr( slist[j].swctl.szSwtitle , name ) != NULL ){
	  if( fSuccess != FALSE )
	    WinSwitchToProgram(slist[j].hswitch);
	  WinShowWindow( slist[j].swctl.hwnd , fSuccess );
	  break;
	}
      }
    }
  }
  return 0;
}
