/*--------------------------------------------------------------------
*
*   This following items are a group of Attribute masks that are intended to
*   be used with the IS and ISNOT operators in conjunction with the ATTRIBUTE
*   function.
*
* For example:
*
*     IF ATTRIBUTE AT 10,1 IS _PROTECTED GOTO label:
*     IF ATTRIBUTE AT 1, 1 ISNOT _BRIGHT DISPLAY "NOT BRIGHT"
*
* Refering to the above examples, the IS operator does the following
*
*   1.  Converts both operands to 16 bit unsigned integer quantities
*
*   2.  Does a logical AND between the low order 8 bits of operand 1
*       (the ATTRIBUTE character) and the high order 8 bits of operand 2
*       (the attribute mask -- "_PROTECTED" in the above example).
*
*   3.  Compares the result of this value with the low order 8 bits of 
*       the operand 2 (the attribute mask).
*
*   4.  If the comparison is equal then the condition is TRUE for IS
*       and FALSE for ISNOT.  If the comparison is not equal, the 
*       condition is TRUE for ISNOT and FALSE for IS.
* 
*
* Attributes for 327x terminals are defined as follows:
*
*   7   6   5   4   3   2   1  0   Bit Number
*   --------------------------------------------------
*   1   1   a   b   c   c   d  e   Attribute Character
*
*           1,1  =  Attribute Identifier
*            a   =  0 Unprotected
*                   1 Protected
*            b   =  0 Alphanumeric
*                   1 Numeric
*           c,c  =  00 Normal Display, non-detectable
*                   01 Normal Display, detectable
*                   10 Bright Display, detectable
*                   11 Non Display, non-detectable
*            d   =  Reserved, Always Zero
*            e   =  Modified Data Tag
*                   0 Field not modified
*                   1 Field Modified
*
*/

GLOBAL _PROTECTED   = ^hE0E0  
GLOBAL _UNPROTECTED = ^hE0C0  
GLOBAL _NORMAL      = ^hC8C0
GLOBAL _BRIGHT      = ^hCCC8
GLOBAL _NONDISPLAY  = ^hCCCC
GLOBAL _MDT         = ^hC1C1

