/************************************************************************\
*                                                                        *  
*         Microsoft C  Language Interface Module (CLIM)                  *
*                                                                        *  
*       (C) Copyright Software Corporation of America, Inc. 1989.        *
*       All Rights Reserved.                                             *
*                                                                        *  
\************************************************************************/


/************************************************************************\
*                                                                        *  
*               CLIM Function Prototype                                  *
*                                                                        *  
\************************************************************************/

extern void clim_hllapi( int *, void *, int *, int * );
extern void clim_gpcapi( int *, void *, int *, int * );




/************************************************************************\
*                                                                        *  
*               IBM HLLAPI Compatible Functions                          *
*                                                                        *  
\************************************************************************/

#define PCB_CONNECT              1
#define PCB_DISCONNECT           2
#define PCB_SEND_KEY             3
#define PCB_WAIT                 4
#define PCB_COPYPS               5
#define PCB_SEARCHPS             6
#define PCB_GET_POSITION         7
#define PCB_COPY_STRING          8
#define PCB_SET_SESSION_PARMS    9
#define PCB_QUERY_SESSIONS      10
#define PCB_RESERVE             11
#define PCB_RELEASE             12
#define PCB_COPYOIA             13
#define PCB_QUERY_FIELD_ATTR    14
#define PCB_COPY_TO_PS          15
#define PCB_PAUSE               18
#define PCB_RESET_SYSTEM        21
#define PCB_QUERY_SESS_STATUS   22
#define PCB_START_HOST_NOTE	  23
#define PCB_QUERY_HOST_UPDATE	  24
#define PCB_STOP_HOST_NOTE		  25
#define PCB_SEARCH_FIELD        30
#define PCB_FIND_FIELD_POS      31
#define PCB_FIND_FIELD_LEN      32
#define PCB_COPY_STR_TO_FIELD   33
#define PCB_COPY_FIELD_TO_STR   34
#define PCB_SEND_FILE           90
#define PCB_RECV_FILE           91
#define PCB_INVOKE_PGM          92
#define PCB_DOS_REDIRECT        93
#define PCB_CONVERT             99
#define PCB_QUERY_BUTTON_INFORMATION 5011


/************************************************************************\
*                                                                        *  
*               Gateway HLLAPI Specific Functions                        *
*                                                                        *  
\************************************************************************/


#define COM_START_EMULATION      1
#define COM_END_EMULATION        2
#define COM_UNLOAD_GPCHAPI       3
#define COM_UNLOAD_DRIVERS       4
#define COM_LINK_CONNECT         5
#define COM_LINK_DISCONNECT      6
#define COM_SESSION_CALL         7
#define COM_SESSION_CALL_CLEAR   8
#define COM_READ_DATA           10
#define COM_WRITE_DATA          11
#define COM_WAIT_FOR            12
#define COM_WAIT_FOR_LIST       13
#define COM_RUN_SCRIPT          14
#define COM_FILE_TRANSFER       15



/************************************************************************\
*                                                                        *  
*               PCB Return Code Definitions                              *
*                                                                        *  
\************************************************************************/


#define RC_OK                      0
#define RC_BAD_SESSION             1
#define RC_BAD_PARMS               2
#define RC_OK_BUSY                 4
#define RC_OK_LOCKED               5
#define RC_OK_TRUNCATED            6
#define RC_BAD_POSITION            7
#define RC_BAD_NO_NOTIFY           8
#define RC_SYSTEM_ERROR	         9

#define RC_OIA_UPDATED            21
#define RC_PS_UPDATED             22
#define RC_OIA_PS_UPDATED         23
#define RC_NOT_FOUND              24
#define RC_OK_HOST_NOTIFY         26     


#define RC_DOS_BAD_FUNCTION      301 
#define RC_DOS_FILE_NOT_FOUND    302
#define RC_DOS_PATH_NOT_FOUND    303
#define RC_DOS_ACCESS_DENIED     305
#define RC_DOS_NO_MEMORY         308
#define RC_DOS_BAD_ENVIRONMENT   310
#define RC_DOS_BAD_FORMAT        311

#define RC_CONVERT_BAD_SESSION  9998
#define RC_CONVERT_BAD_PARMS    9999



/************************************************************************\
*                                                                        *  
*               COM Return Code Definitions                              *
*                                                                        *  
\************************************************************************/


#define RCOM_OK                     0			 /* Common Codes          */
#define RCOM_BAD_SESSION            1
#define RCOM_BAD_PARMS              2
#define RCOM_BAD_POSITION           7
#define RCOM_SYSTEM_ERROR           9
#define RCOM_NOT_FOUND             24

#define RCOM_SE_OK                  0			 /* Start Emulation Codes */
#define RCOM_SE_OK_BUT              1
#define RCOM_SE_NO_DRIVER           2
#define RCOM_SE_NO_SESSION          3

#define RCOM_EE_OK                  0			 /* End Emulation Codes   */
#define RCOM_EE_NO_ACTIVE           1

#define RCOM_UL_OK                  0			 /* Unload Codes          */
#define RCOM_UL_FAILED              1

#define RCOM_LC_OK                  0			 /* Link Connect Codes    */
#define RCOM_LC_NO_CONNECT          1

#define RCOM_LD_OK                  0			 /* Link Disconnect Codes */
#define RCOM_LD_NO_DISCONNECT       1

#define RCOM_SC_OK                  0			 /* Session Call Codes    */
#define RCOM_SC_FAILED              1

#define RCOM_SD_OK                  0			 /* Session Clear Codes   */
#define RCOM_SD_FAILED              1

#define RCOM_RD_OK                  0			 /* Read Data Codes       */

#define RCOM_WD_OK                  0			 /* Write Data Codes      */

#define RCOM_WF_OK                  0			 /* Wait For Codes        */
#define RCOM_WF_NOT_FOUND          24

#define RCOM_WL_OK                  0			 /* Wait For List Codes   */
#define RCOM_WL_NOT_FOUND          24
