/************************************************************************\
*                                                                        *
*         Microsoft C  Language Sample Gateway HLLAPI Module             *
*                                                                        *
*       (C) Copyright Software Corporation of America, Inc. 1989.        *
*       All Rights Reserved.                                             *
*                                                                        *
\************************************************************************/
 
#include "stdio.h"
 
#include "clim.h"                     /* Include the CLIM header        */
#include "hapi.h"                     /* Include sample subs. header    */
 
 
void pascal hllapi();
 
/************************************************************************\
*                                                                        *
*        Global Variables                                                *
*                                                                        *
\************************************************************************/
 
extern int CLIMFunction;              /* API function                   */
extern int CLIMLength;                /* API string length              */
extern int CLIMReturnCode;            /* API return code                */
 
 
/************************************************************************\
*                                                                        *
*  HapiCopyPSString - Function to issue HLLAPI call #8                   *
*                                                                        *
\************************************************************************/
 
int HapiCopyPSString(pszDestination, Size, Position)
char * pszDestination;
int    Size, Position;
{
 
    CLIMFunction   = PCB_COPY_STRING;            /* Set Function Code   */
    CLIMLength     = Size;                       /* Set Length          */
    CLIMReturnCode = Position;                   /* Initialize Ret. Code*/
 
    hllapi(&CLIMFunction, pszDestination, &CLIMLength, &CLIMReturnCode);
 
    return(CLIMReturnCode);                      /* Return to Caller    */
}
 
