/* =========================================================================
							   TEST SCA REXX hllapi Interface
							Args s/S = SCA,   i/I = IBM    hllapi
========================================================================== */

	LF = x2c('0A')

	connectedPS = 0
	connectedPM = 0
	startClose  = 0
	startHost   = 0
  startKey		= 0
	showWho		= 0
	numList		= 0
	isEAB			= 0

   arg session
   
   signal off SYNTAX					/* Trap ALL Errors */

   if RxFuncQuery('SysLoadFuncs') <> 0 then do
     say 'Loading REXXUTILS .....'
     call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
     call SysLoadFuncs
   end

   if RxFuncQuery('hllapi') <> 0 then	do
      say 'Loading SAAHLAPI .....'
		call SysSleep 2
		call RxFuncAdd 'hllapi', 'saahlapi', 'hllapisrv'
   end 

	do forever

		if numList = 0 then
			rc = ALPHALIST()
		else 
			rc = NUMLIST()

		if rc = 255 then leave

		if rc = 1 then do
			numList = 1
			showWho = 0
			iterate
		end

		if rc = 2 then do
			numList = 0
			showWho = 0
			iterate
		end

		call SysCls
		if numList = 0 then	do
			select
				when test = '1'  then call SETSWITCHLIST
				when test = '2'  then call SETWINDOWTITLE
				when test = '3'  then call CONNECTPS
				when test = '4'  then call CONNECTPM
				when test = '5'  then call CONVERT
				when test = '6'  then call COPYFIELDTOSTR
				when test = '7'  then call COPYOIA
				when test = '8'  then call COPYPS
				when test = '9'  then call COPYPSTOSTR
				when test = '10' then call COPYSTRTOFIELD
				when test = '11' then call COPYSTRTOPS
				when test = '12' then call DISCONNECTPS
				when test = '13' then call DISCONNECTPM
				when test = '14' then call FIELDLEN
				when test = '15' then call FIELDPOS
				when test = '16' then call GETKEY
				when test = '17' then call GETWINDOWSTATUS
				when test = '18' then call INTSTATUS
				when test = '19' then call LOCKPMSVC
				when test = '20' then call LOCKPS
				when test = '21' then call PAUSE
				when test = '22' then call QUERYBUTTONS
				when test = '23' then call QUERYCLOSEINT
				when test = '24' then call QUERYCURSORPOS
				when test = '25' then call QUERYFIELDATTR
				when test = '26' then call QUERYHOSTUPDATE
				when test = '27' then call QUERYWINDOWCOORD
				when test = '28' then call QUERYSESSSTATUS
				when test = '29' then call QUERYSESSIONS
				when test = '30' then call QUERYSYSTEM
				when test = '31' then call RECEIVEFILE
				when test = '32' then call RELEASE
				when test = '33' then call RESERVE
				when test = '34' then call RESETSYSTEM
				when test = '35' then call SEARCHFIELD
				when test = '36' then call SEARCHPS
				when test = '37' then call SENDFILE
				when test = '38' then call SENDKEY
				when test = '39' then call SETCURSORPOS
				when test = '40' then call SETSESSPARMS
				when test = '41' then call STARTCLOSEINT
				when test = '42' then call STARTHOSTNOTE
				when test = '43' then call STARTKEYINT
				when test = '44' then call STOPCLOSEINT
				when test = '45' then call STOPKEYINT
				when test = '46' then call STOPHOSTNOTE
				when test = '47' then call WAIT
				when test = '99' then call GETEXTWINDOWSTATUS
				otherwise do
					say 'Invalid selection ...'
					call ENTER
					iterate
				end
			end
		end
		else do
			select
				when test = '1'   then call CONNECTPS
				when test = '2'   then call DISCONNECTPS
				when test = '3'   then call SENDKEY
				when test = '4'   then call WAIT
				when test = '5'   then call COPYPS
				when test = '6'   then call SEARCHPS
				when test = '7'   then call QUERYCURSORPOS
				when test = '8'   then call COPYPSTOSTR
				when test = '9'   then call SETSESSPARMS
				when test = '10'  then call QUERYSESSIONS
				when test = '11'  then call RESERVE
				when test = '12'  then call RELEASE
				when test = '13'  then call COPYOIA
				when test = '14'  then call QUERYFIELDATTR
				when test = '15'  then call COPYSTRTOPS
				when test = '18'  then call PAUSE
				when test = '20'  then call QUERYSYSTEM
				when test = '21'  then call RESETSYSTEM
				when test = '22'  then call QUERYSESSSTATUS
				when test = '23'  then call STARTHOSTNOTE
				when test = '24'  then call QUERYHOSTUPDATE
				when test = '25'  then call STOPHOSTNOTE
				when test = '30'  then call SEARCHFIELD
				when test = '31'  then call FIELDPOS
				when test = '32'  then call FIELDLEN
				when test = '33'  then call COPYSTRTOFIELD
				when test = '34'  then call COPYFIELDTOSTR
				when test = '40'  then call SETCURSORPOS
				when test = '41'  then call STARTCLOSEINT
				when test = '42'  then call QUERYCLOSEINT
				when test = '43'  then call STOPCLOSEINT
				when test = '50'  then call STARTKEYINT
				when test = '51'  then call GETKEY
				when test = '52'  then call INTSTATUS
				when test = '53'  then call STARTKEYINT
				when test = '60'  then call LOCKPS
				when test = '61'  then call LOCKPMSVC
				when test = '90'  then call SENDFILE
				when test = '91'  then call RECEIVEFILE
				when test = '99'  then call CONVERT
				when test = '101' then call CONNECTPM
				when test = '102' then call DISCONNECTPM
				when test = '103' then call QUERYWINDOWCOORD
				when test = '104' then call GETWINDOWSTATUS
				when test = '104' then call GETWINDOWSTATUS
				when test = '105' then call SETSWITCHLIST
				when test = '106' then call SETWINDOWTITLE
				when test = '999' then call GETEXTWINDOWSTATUS
				when test = '5011' then call QUERYBUTTONS
				otherwise do
					say 'Invalid selection ...'
					call ENTER
					iterate
				end
			end
		end
	end

	call RxFuncDrop 'hllapi'
	call SysCls
  exit

/* ====================================================================== */
 SETSWITCHLIST:
/* ====================================================================== */

	function = 'SETSWITCHLIST'		
	say 'Start Change Switch Name ... (105)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	do forever
		say '<S>et Switch List Name,  <R>eset Switch List Name,  <Q>uit'
		pull ans
		if left(ans,1) = 'Q' then return
		if left(ans,1) = 'R' then leave
		if left(ans,1) = 'S' then leave
	end

	if left(ans,1) = 'S' then do
	   do forever
	     say 'Enter the new Switch List Name,  Q to quit ...'
	     parse pull listname
	     if listname = '' then iterate
	     if listname = 'Q' | listname = 'q' then leave
	     rc = hllapi('Change_Switch_Name',session, 'Set', listname)
	     if rc <> 0 then do
			 call SHOWRC rc
	     end
		  else do 	
			 say 'Set Switch List Name OK'
			 call SLEEP
		  end	
	     leave
	   end
	end
	else do
	   rc = hllapi('Change_Switch_Name',session, 'Reset')
	   if rc <> 0 then do
			 call SHOWRC rc
	   end
		else	do
			say 'Reset Switch List Name OK'
			call SLEEP
		end
	end

   return 

/* ====================================================================== */
 SETWINDOWTITLE:
/* ====================================================================== */

	function = 'SETWINDOWTITLE'		
	say 'Start Change Window Title ... (106)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	do forever
		say '<S>et Window Name,  <R>eset Window Name,  <Q>uit'
		pull ans
		if left(ans,1) = 'Q' then return
		if left(ans,1) = 'R' then leave
		if left(ans,1) = 'S' then leave
	end

	if left(ans,1) = 'S' then do
	   do forever
	     say 'Enter the new Window Name,  Q to quit ...'
	     parse pull listname
	     if listname = '' then iterate
	     if listname = 'Q' | listname = 'q' then leave
	     rc = hllapi('Change_Window_Name',session, 'Set', listname)
	     if rc <> 0 then do
			 call SHOWRC rc
	     end
		  else do
	       say 'Set Window Name OK'
			 call SLEEP
		  end
		  leave
	   end
	end
	else do
	   rc = hllapi('Change_Window_Name',session, 'Reset')
	   if rc <> 0 then do
			 call SHOWRC rc
	   end
		else do
	     say 'Reset Window Name OK'
		  call SLEEP
	   end
	end

   return 

/* ====================================================================== */
 CONNECTPS:
/* ====================================================================== */

	function = 'CONNECTPS'			
	if connectedPS = 1 then do
		say 'You are already Connected ... (1)'
		call SLEEP
		return
	end

  if session = '' then do
		do forever
			say
			say 'Enter Session ID... or 0 to quit'
			pull session
			session = left(session,1)
			if session = 0 then return
			if session = '' then iterate
			if datatype(session) <> 'CHAR' then iterate
			leave
		end
	end

  say 'Start Connecting to Session ... (1)'
	rc = hllapi('Connect',session)
	if rc <> 0 then do
		call SHOWRC rc
	end		
	else do
		connectedPS = 1
		say 'Connect OK'
		call SLEEP
	end

	return

/* ====================================================================== */
 CONNECTPM:
/* ====================================================================== */

	function = 'CONNECTPM'			
	if connectedPM = 1 then do
		say 'You are already Connected ... (101)'
		call SLEEP
		return
	end

   say 'Connecting to PM Services ... (101)'
   rc = hllapi('Connect_PM',session)
   if rc <> 0 then do
		call SHOWRC rc
	end	
	else do
		connectedPM = 1
		say 'Connect_PM OK'
		call SLEEP
	end
		
	return

/* ====================================================================== */
 CONVERT:
/* ====================================================================== */

	function = 'CONVERT'				
	say 'Starting Convert Pos or Row/Col ... (99)'

	do forever
		RowCol = ''
		pos    = ''
		say 'Enter Row Col  or  Position  or  Q  to quit...'
		pull RowCol Pos .
		if left(RowCol,1) = 'Q' then leave
		if datatype(rowcol) <> 'NUM' then iterate 	
		if pos = '' then
			rc = hllapi('Convert_Pos',session,RowCol)
		else do
			if datatype(pos) <> 'NUM' then iterate 	
			rc = hllapi('Convert_Pos',session,RowCol,Pos)
		end
		if rc = 0 then
			 call SHOWRC rc
		else do
			say 'Row/Col or Pos: ' rc
			call ENTER
		end
	end

	return

/* ====================================================================== */
 COPYFIELDTOSTR:
/* ====================================================================== */

	function = 'COPYFIELDTOSTR'		
	say 'Start Copy Field To String ... (34)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		do forever
			say 'Enter pos and len  or  Q to quit...'
			pull ans
			if left(ans,1) = 'Q' then leave
			parse value ans with pos len
			if datatype(pos) <> 'NUM' then iterate
			if datatype(len) <> 'NUM' then iterate
			leave
		end
		if left(ans,1) = 'Q' then leave
		rc = hllapi('Copy_Field_To_Str',pos,len)
		if rc = '' then do
			 call SHOWRC '""'
		end
		else
		if isEAB = 0 then do
			say rc
		end
		else	do
			len = length(rc)
			text = ''
			i = 1
			do while i < len
				text = text||substr(rc,i,1)
				i = i + 2
			end
			say text
		end
 		call ENTER
	end			

	return

/* ====================================================================== */
 COPYOIA:
/* ====================================================================== */

	function = 'COPYOIA'				
	say 'Start Copy OIA ... (13)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	rc = hllapi('Copy_OIA')
	if rc = '' then do
		 call SHOWRC '""'
	end		
	else do
		say 'Format Byte: ' left(rc,1)
		line = substr(rc,2,80)
		say line
		call ENTER
	end

	return

/* ====================================================================== */
 COPYPS:
/* ====================================================================== */

	function = 'COPYPS'				
	say 'Start Copy PS ... (5)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	rc = hllapi('Copy_PS')
	if rc = '' then do
		 call SHOWRC '""'
	end
	if isEAB = 0 then do
		call SysCls
		say rc
	end
	else do
		len = length(rc)
		text = ''
		i = 1
		do while i < len
			text = text||substr(rc,i,1)
			i = i + 2
		end
		call SysCls
		say text
	end
	pull a

	return

/* ====================================================================== */
 COPYPSTOSTR:
/* ====================================================================== */

	function = 'COPYPSTOSTR'			
	say 'Start Copy PS To String ... (8)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter  pos and len  or Q to quit...'
		pull ans
		if left(ans,1) = 'Q' then leave
		parse value ans with pos len
		if datatype(len) <> 'NUM' then iterate
		if datatype(pos) <> 'NUM' then iterate
		rc = hllapi('Copy_PS_To_Str',pos,len)
		if rc = '' then do
			 call SHOWRC '""'
		end
		if isEAB = 0 then do
			say rc
		end
		else do
			len = length(rc)
			text = ''
			i = 1
			do while i < len
				text = text||substr(rc,i,1)
				i = i + 2
			end
			say text
		end
		call ENTER
	end

	return


/* ====================================================================== */
 COPYSTRTOFIELD:
/* ====================================================================== */

	function = 'COPYSTRTOFIELD'		
	say 'Start Copy Str To Field ... (33)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter string  or Q to quit...'
		parse pull str
		if left(str,1) = 'Q' | left(str,1) = 'q' then leave
		if str = '' then iterate
		do forever
			say 'Enter field pos or  Q to quit...'
			pull pos
			if left(pos,1) = 'Q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if left(pos,1) = 'Q' then leave
		rc = hllapi('Copy_Str_To_Field',str,pos)
      say 'Copy Str To Field RC: ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 COPYSTRTOPS:
/* ====================================================================== */

	function = 'COPYSTRTOPS'			
	say 'Copy Str To PS ... (15)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter string  or Q to quit... eg: Hello World'
		parse pull str
		if str = 'Q' | str = 'q' then leave
		if str = '' then iterate
		do forever
			say 'Enter PS pos or  Q to quit...'
			pull pos
			if pos = 'Q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if pos = 'Q' then leave
		rc = hllapi('Copy_Str_To_PS',str,pos)
      say 'Copy Str To PS RC: ' rc
		say 'press enter to continue ...'
		pull a
	end

   say 'Disconnecting from Session ...'
	rc = hllapi('Disconnect')
	if rc <> 0 then do
      say 'Copy Str To PS Disconnect'
		signal SYNTAX
	end		

	return

/* ====================================================================== */
 DISCONNECTPS:
/* ====================================================================== */

	function = 'DISCONNECTPS'		
   say 'Start Disconnect from Session ... (2)'
	rc = hllapi('Disconnect')
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
		connectedPS = 0
		say 'Disconnect OK'
		call SLEEP
	end
	return

/* ====================================================================== */
 DISCONNECTPM:
/* ====================================================================== */

	function = 'DISCONNECTPM'		
   say 'Start Disconnect from PM Services ... (102)'
	rc = hllapi('Disconnect_PM',session)
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
		connectedPM = 0
		say 'Disconnect_PM OK'
		call SLEEP
	end

	return

/* ====================================================================== */
 FIELDLEN:
/* ====================================================================== */

	function = 'FIELDLEN'				
	say 'Start Find Field Length ... (32)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		call SysCls
		say 'Enter Search Option VALUE...'
		say
		say '   T  = Current Field'
		say '   N  = Next Field'
		say '   P  = Previuos Field'
		say '   NP = Next Protected'
		say '   NU = Next Unprotected'
		say '   PP = Previous Protected'
		say '   PU = Previous Unprotected'
		say
		say 'Q to Quit...'
		say
		parse pull type
		if left(type,1) = 'Q' | left(type,1) = 'q' then leave
		if type = '' then iterate
		type = left(type||'  ',2)    
		do forever
			say
			say 'Enter field position  or Q to quit...'
			pull pos
			if pos = '' then iterate
			if left(pos,1) = 'Q' | left(pos,1) = 'q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if left(pos,1) = 'Q' | left(pos,1) = 'q' then iterate
		rc = hllapi('Find_Field_Len',type,pos)
		if rc = 0 then do
			 call SHOWRC rc
		end
		else do
			say 'Field Length: ' rc
			call ENTER
		end
	end

	return

/* ====================================================================== */
 FIELDPOS:
/* ====================================================================== */

	function = 'FIELDPOS'				
	say 'Start Find Field Position ... (31)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

   do forever
		call SysCls
		say 'Enter Search Option VALUE...'
		say
		say '   T  = Current Field'
		say '   N  = Next Field'
		say '   P  = Previuos Field'
		say '   NP = Next Protected'
		say '   NU = Next Unprotected'
		say '   PP = Previous Protected'
		say '   PU = Previous Unprotected'
		say
		say 'Q to Quit...'
		say
		parse pull type
		if left(type,1) = 'Q' | left(type,1) = 'q' then leave
		if type = '' then iterate
		type = left(type||'  ',2)    
		do forever
			say
			say 'Enter field position  or Q to quit...'
			pull pos
			if pos = '' then iterate
			if left(pos,1) = 'Q' | left(pos,1) = 'q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if left(pos,1) = 'Q' | left(pos,1) = 'q' then iterate
		rc = hllapi('Find_Field_Pos',type,pos)
		if rc = 0 then do
			 call SHOWRC rc
		end
		else do
			say 'Find Field Len: ' rc
			call ENTER
		end
	end

	return

/* ====================================================================== */
 GETKEY:
/* ====================================================================== */

	function = 'GETKEY'				
   say 'Start Get Key ... (51)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end
	if startKey = 0 then do
		call MUSTSTARTKEY
		return
	end

	do forever
		say 'Waiting for Key ....'
		key = hllapi('Get_Key',session)
		say 
		say 'Key: ' key
		say
		say 'S=SendKey, I=Intercept Status,  Q=Quit'
		pull ans
		ans = left(ans,1)
		select
			when ans = 'Q' then leave
			when ans = 'S' then do
				rc = hllapi('SendKey',key)
				if rc <> 0 then do
					 call SHOWRC rc
				end
			end
			when ans = 'I' then do
	         do forever
					say 'A=Accept Keystroke,  R=Reject Keystroke,  Q=Quit'
					pull ans
					ans = left(ans,1)
					if ans = 'A' | ans = 'R' | ans = 'Q' then leave
				end
				if ans <> 'Q' then leave
				call INTSTATUS
			end
			otherwise iterate
		end
	end

   return

/* ====================================================================== */
 GETWINDOWSTATUS:
/* ====================================================================== */

	function = 'GETWINDOWSTATUS'	
	say 'Start Get/Set Window Status ... (104)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	do forever
		say '<S>et Window Status,  <G>et Window Status,  <Q>uit'
		pull ans
		if left(ans,1) = 'Q' then return
		if left(ans,1) = 'G' then leave
		if left(ans,1) = 'S' then leave
	end

	if left(ans,1) = 'S' then do
		do forever
			call SysCls
			say 'Enter OPTION ...'
			say 
			say 'V - Make Window Visible,     I - Make Window Invisible'
			say 'A - Make Window Active       D - Make Window Inactive'
			say 'R - Restore Window           Z - Zorder Window'
			say 'X - Maximize Window          N - Minimize Window'
			say 'M - Move Window              S - ReSize Window'
			say 'Q - Quit'
			pull ans
			if ans = 'Q' then leave
			select
				when ans = 'Z' then do
					say
					do forever
						say 'Enter <T>op  or  <B>ottom  or  <Q>uit ...'
						pull ans
						if left(ans,1) = 'Q' then leave
						if left(ans,1) = 'T' then leave
						if left(ans,1) = 'B' then leave
					end
					if ans = 'Q' then iterate
					rc = hllapi('Set_Window_Status',session,'Z',ans)
				   if rc <> 0 then do
						 call SHOWRC rc
				   end
				end
				when ans = 'M' then do
					say 
					do forever
						say 'Enter lowerx lowery  or Q to quit ... eg: 155 8'
						pull ans
						if left(ans,1) = 'Q' then leave
						parse value ans with leftx lefty
						if datatype(leftx) <> 'NUM' then iterate
						if datatype(lefty) <> 'NUM' then iterate
						leave
					end
					if ans = 'Q' then iterate
					rc = hllapi('Set_Window_Status',session,'M',leftx,lefty)
				   if rc <> 0 then do
						 call SHOWRC rc
				   end
				end
				when ans = 'S' then do
					say 
					do forever
						say 'Enter width height  or Q to quit ... eg: 155 8'
						pull ans
						if left(ans,1) = 'Q' then leave
						parse value ans with width height
						if datatype(width) <> 'NUM' then iterate
						if datatype(height) <> 'NUM' then iterate
						leave
					end
					if ans = 'Q' then iterate
					rc = hllapi('Set_Window_Status',session,'S',width,height)
				   if rc <> 0 then do
						 call SHOWRC rc
				   end
				end
				otherwise do
					rc = hllapi('Set_Window_Status',session,ans)
				   if rc <> 0 then do
						 call SHOWRC rc
				   end
				end
			end	
		end
	end
	else do
		rc = hllapi('Get_Window_Status',session)
		if rc = '' then do
			 call SHOWRC '""'
		end		
		else	do
		   say 'Window Status: ' rc
			call ENTER
		end
	end

	return

/* ====================================================================== */
 GETEXTWINDOWSTATUS:
/* ====================================================================== */

	function = 'GETEXTWINDOWSTATUS'	
	say 'Start Get Extended Window Status ... (104)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	rc = hllapi('Get_Extended_Window_Status',session)
	if rc = '' then do
		 call SHOWRC '""'
	end		
	else	do
		parse value rc with Stat FontX FontY OffsetX OffsetY FirstRow FirstCol hwndClient
	   say 'Extended Window Status: '
		say rc
		say 'Status       = ' Stat 	  
		say 'FontX        = ' FontX	  
		say 'FontY        = ' FontY	  
		say 'OffsetX      = ' OffsetX	  
		say 'OffsetY      = ' OffsetY	  
		say 'FirstRow     = ' FirstRow  
		say 'FirstCol     = ' FirstCol  
		say 'hwndClient   = ' hwndClient
		call ENTER
	end
	return

/* ====================================================================== */
 INTSTATUS:
/* ====================================================================== */

	function = 'INTSTATUS'			
	say 'Start Intercept_Status... (52)'
	if startKey = 0 then do
		call MUSTSTARTKEY
		return
	end

	do forever
		say 'A=Accept Keystroke,  R=Reject Keystroke,  Q=Quit'
		pull ans
		ans = left(ans,1)
		if ans = 'A' | ans = 'R' | ans = 'Q' then leave
	end
	if ans <> 'Q' then do 
		rc = hllapi('Intercept_Status',session,ans)
		if rc <> 0 then do
			 call SHOWRC rc
		end
	end

	return

/* ====================================================================== */
 LOCKPMSVC:
/* ====================================================================== */

	function = 'LOCKPMSVC'			
	say 'Start Lock PMSVC ... (61)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	do forever
		say 'Enter Status   L=lock, U=unlock  or Q to quit...'
		pull sts
		if sts = 'Q' then leave
		if sts = '' then iterate
		say 'Enter Queue   R=return immed,  Q=que request  or  <cr> to quit...'
		pull que
		if que = '' then iterate
		rc = hllapi('Lock_PMSVC',session,sts,que)
		if rc <> 0 then do
			 call SHOWRC rc
		end		
		pull a
	end

	return

/* ====================================================================== */
 LOCKPS:
/* ====================================================================== */

	function = 'LOCKPS'				
	say 'Start Lock PS ... (60)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	do forever
		say 'Enter Status   L=lock, U=unlock  or Q to quit...'
		pull sts
		if sts = 'Q' then leave
		if sts = '' then iterate
		say 'Enter Queue   R=return immed, Q=que request  or  <cr> to quit...'
		pull que
		if que = '' then iterate
		say 'sts: >'||sts||'<, Que: >'||que||'<'
		pull a
		rc = hllapi('Lock_PS',session,sts,que)
		if rc <> 0 then do
			 call SHOWRC  rc
		end		
	end

	return

/* ====================================================================== */
 PAUSE:
/* ====================================================================== */

	function = 'PAUSE'					
	say 'Start Pause ... (18)'
	do forever
		say 'Enter number of 1/2 second time periods or  Q to quit ...'
		pull ti
		if left(ti,1) = 'Q' then leave
		if datatype(ti) <> 'NUM' then iterate
		say 'Enter optional session ID <cr> for none,  Q to quit...'
		pull sessid
		if left(sessid,1) = 'Q' then iterate
		if sessid == '' then
			rc = hllapi('Pause',ti)
		else do
			sessid = left(sessid,1)||'#'
			rc = hllapi('Pause',ti,sessid)
		end
		if rc <> 0 then do
			 call SHOWRC rc
		end
	end			
	
	return

/* ====================================================================== */
 QUERYBUTTONS:
/* ====================================================================== */

	function = 'QUERYBUTTONS '		
	say 'Start Query Button Information ... (5011)'
	drop buttons.

	do forever
		say 'Enter Session ID ... or <cr> currently connected PS .. or 0 to quit..'
		ID = ""
		pull ID
		if left(ID,1) = '0' then return
		if ID <> "" then do
			if datatype(ID) <> 'CHAR' then iterate
		end
		leave
	end
	buttons.0 = ID

	do forever
		say 'Enter Query Type.. 1 = Query Number of Buttons, 2 = Query Button Text or Q to quit..'
		pull qtype
		if left(qtype,1) = 'Q' then return
		if datatype(qtype) <> 'NUM' then iterate
		if qtype <> 1 & qtype <> 2 then iterate
		leave
	end
	buttons.1 = left(qtype,1)		

	if left(qtype,1) = 1 then
		call QUERYBUTTONCNT
	else
		call QUERYBUTTONTEXT

	return

/* ====================================================================== */
 QUERYBUTTONCNT:
/* ====================================================================== */

	do forever
		say 'Enter Max Number of Rows.. 0 = return Number of rows only,'
		say '        other = Columns per/row,   Q to quit..'
		pull max
		if left(max,1) = 'Q' then return
		if datatype(max) <> 'NUM' then iterate
		leave
	end
	buttons.2 = max		

	rc = hllapi('Query_Button_Information','buttons')
	if rc <> 0 then do
		 call SHOWRC rc
		 return
	end

	if max = 0 then do
		say 'Number of Button Rows: ' buttons.2 
		call ENTER
		return
	end	
	x = 3

	if buttons.2 > 0 then do
		do	forever
			say 'Row: ' x - 2 ', Cols: ' buttons.x
			x = x + 1
			buttons.2 = buttons.2 - 1
			if buttons.2 == 0 then leave
		end
  end
	call ENTER
	return

/* ====================================================================== */
 QUERYBUTTONTEXT:
/* ====================================================================== */

	do forever
		say 'Enter REQUESTED ROW number.. 0 = CURRENT ROW,   Q to quit'
		pull reqrow
		if left(reqrow,1) = 'Q' then return
		if datatype(reqrow) <> 'NUM' then iterate
		leave
	end
	buttons.2 = reqrow		

	do forever
		say 'Enter REQUESTED BUTTON number.. 0 = ALL BUTTONS,   Q to quit,'
		pull reqbutt
		if left(reqbutt,1) = 'Q' then return
		if datatype(reqbutt) <> 'NUM' then iterate
		leave
	end
	buttons.3 = reqbutt

	do forever
		say 'Enter MAXIMUM number of Buttons MAX 12,   Q to quit,'
		pull maxbutt
		if left(maxbutt,1) = 'Q' then return
		if datatype(maxbutt) <> 'NUM' then iterate
		leave
	end
	buttons.4 = maxbutt

	do forever
		say 'Enter REQUESTED TEXT SIZE.. currently MAX 32,   Q to quit,'
		pull txtsize
		if left(txtsize,1) = 'Q' then return
		if datatype(txtsize) <> 'NUM' then iterate
		leave
	end
	buttons.5 = txtsize

	rc = hllapi('Query_Button_Information','buttons')
	if rc <> 0 then do
		 call SHOWRC rc
		 return
	end

  x = 6
	i = 1;
	say 'ROW: ' buttons.2 '................................'
	say
  say '       Total Buttons Retrieved: ' buttons.4
	say
	if buttons.4 > 0 then do
		do forever
			work = ''
			len = length(buttons.x)
			do y=1 to len
				if substr(buttons.x,y,1) = LF then
					work = work||' '
				else		
					work = work||substr(buttons.x,y,1)
			end
			say '   Button: ' i ' Text: ' work
			x = x + 1
			i = i + 1
			if i > buttons.4 then leave
		end
	end

	call ENTER
	return

/* ====================================================================== */
 QUERYCLOSEINT:
/* ====================================================================== */

	function = 'QUERYCLOSEINT'		
	say 'Start Query Close Intercept ... (42)'
	if startClose  = 0 then do
		call MUSTSTARTCLOSE
		return
	end

	rc = hllapi('Query_Close_Intercept',session)
  say 'Query Close Intercept RC: ' rc
	call ENTER

	return

/* ====================================================================== */
 QUERYCURSORPOS:
/* ====================================================================== */

	function = 'QUERYCURSORPOS'		
	say 'Start Query Cursor Position ... (7)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	rc = hllapi('Query_Cursor_Pos')
	if rc = 0 then 
		 call SHOWRC rc
	else	do
		say 'Cursor Location: ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 QUERYFIELDATTR:
/* ====================================================================== */

	function = 'QUERYFIELDATTR'		
	say 'Start Query Field Attribute ... (14)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter Field Position ... or Q to quit..'
		pull pos
		if left(pos,1) = 'Q' then leave
		if datatype(pos) <> 'NUM' then iterate
		rc = hllapi('Query_Field_Attr',pos)
		if rc < 'C0' then 
			 call SHOWRC rc
		else  do
			say 'Field Attribute HEXBYTE - '   rc
			call ENTER
		end
	end

	return

/* ====================================================================== */
 QUERYHOSTUPDATE:
/* ====================================================================== */

	function = 'QUERYHOSTUPDATE'	
	say 'Start Query Host Update ... (24)'
	if startHost  = 0 then do
		call MUSTSTARTHOST
		return
	end

	rc = hllapi('Query_Host_Update',session)
   say 'Query Host Update RC: ' rc
	call ENTER

	return

/* ====================================================================== */
 QUERYWINDOWCOORD:
/* ====================================================================== */

	function = 'QUERYWINDOWCOORD'	
	say 'Start Query Window Coordinates ... (103)'
	if connectedPM = 0 then do
		call MUSTCONNECTPM
		return
	end

	rc = hllapi('Query_Window_Coord',session)
	if rc = '' then 
		 call SHOWRC '""'
	else do
		parse value rc with xleft ybot xright ytop
	   say 'X left : ' xleft
		say 'Y bot  : ' ybot
		say 'X right: ' xright
		say 'Y top  : ' ytop
		call ENTER
	end

	return

/* ====================================================================== */
 QUERYSESSSTATUS:
/* ====================================================================== */

	function = 'QUERYSESSSTATUS'	
	say 'Start Query Session Status ... (22)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	rc = hllapi('Query_Session_Status',session)
	if rc = '' then do
		 call SHOWRC '""'
		return
	end		

   call SysCls
   say '========= Session Status Information ===================='
	say 
	say 'Short Sess ID  : ' substr(rc,1,1)
	say 'Long Name      : ' substr(rc,2,8)
	say 'Session Type   : ' substr(rc,10,1)
	char = substr(rc,11,1)
	say 'Session Characteristics - HEXBYTE '    C2X(char)
	if BITAND(char,'80'x) = '80'x then say '    Extended Attributes'
	else say '    Base Attributes'
	if BITAND(char,'40'x) = '40'x then say '    PSS'
	else say '    NO PSS'
	char = substr(rc,12,2)
	say 'Number of Rows : ' C2D(reverse(char))
	char = substr(rc,14,2)
	say 'Number of Cols : ' C2D(reverse(char))
	char = substr(rc,16,2)
	say 'Host Code Page : ' C2D(reverse(char))
	say
	call ENTER

	return

/* ====================================================================== */
 QUERYSESSIONS:
/* ====================================================================== */

	function = 'QUERYSESSIONS'		
	say 'Start Query Sessions ... (10)'
	rc = hllapi('Query_Sessions')
	if rc = '' then do
		 call SHOWRC '""'
		return
	end		

	call SysCls
	i = 1
   llen = length(rc)
   do forever
		if i > llen then leave
		say 'Short Sess ID  : ' substr(rc,i,1)
		say 'Long Name      : ' substr(rc,i+1,8)
		say 'Session Type   : ' substr(rc,i+9,1)
		char = substr(rc,i+10,2)
		say 'PS Size        : ' C2D(reverse(char))
	   say 'press Q to quit, any other for next session...'
		pull a
		if a = 'Q' | a = 'q' then leave
		i = i + 12
	end

	return

/* ====================================================================== */
 QUERYSYSTEM:
/* ====================================================================== */

	function = 'QUERYSYSTEM'			
	say 'Start Query System ... (20)'
	rc = hllapi('Query_System')
	if rc = '' then 
		 call SHOWRC '""'
	else do
	   say 'Query System: ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 RECEIVEFILE:
/* ====================================================================== */

	function = 'RECEIVEFILE'			
	say 'Start Receive File ... (91)'

	do forever
		say 'Enter Receive File Command  or Q to quit ...'
		parse pull str
		if str = 'Q' | str = 'q' then leave
		if str = '' then iterate
		rc = hllapi('Receive_File',str)
      say 'Receive File RC: ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 RELEASE:
/* ====================================================================== */

	function = 'RELEASE'				
	say 'Start Release ... (12)'
   rc = hllapi('Release')
   if rc <> 0 then do
		 call SHOWRC rc
	end
	else do
		say 'Release OK'
		call SLEEP
	end	

	return

/* ====================================================================== */
 RESERVE:
/* ====================================================================== */

	function = 'RESERVE'				
	say 'Start Reserve... (11)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	rc = hllapi('Reserve')
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
		say 'Reserve OK'
		call SLEEP
	emd

	return

/* ====================================================================== */
 RESETSYSTEM:
/* ====================================================================== */

	function = 'RESETSYSTEM'			
	say 'Start Reset System ... (21)'
	rc = hllapi('Reset_System')
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
 		say 'Reset System OK'
		call SLEEP
	end

	return

/* ====================================================================== */
 SEARCHFIELD:
/* ====================================================================== */

	function = 'SEARCHFIELD'			
	say 'Start Search Field ... (30)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter search string  or Q to quit...'
		parse pull str
		if str = 'Q' | str = 'q' then leave
		if str = '' then iterate
		do forever
			say 'Enter field pos or  Q to quit...'
			pull pos
			if pos = 'Q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if pos = 'Q' then leave
		rc = hllapi('Search_Field',str,pos)
      say 'Search Field RC (pos): ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 SEARCHPS:
/* ====================================================================== */

	function = 'SEARCHPS'				
	say 'Start Search PS ... (6)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter search string  or Q to quit...'
		parse pull str
		if str = 'Q' | str = 'q' then leave
		if str = '' then iterate
		do forever
			say 'Enter PS pos or  Q to quit...'
			pull pos
			if pos = 'Q' then leave
			if datatype(pos) <> 'NUM' then iterate
			leave
		end
		if pos = 'Q' then leave
		rc = hllapi('Search_PS',str,pos)
      say 'Search PS RC (pos): ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 SENDFILE:
/* ====================================================================== */

	function = 'SENDFILE'				
	say 'Start Send File ... (90)'

	do forever
		say 'Enter Send File Command  or Q to quit ...'
		parse pull str
		if str = 'Q' | str = 'q' then leave
		if str = '' then iterate
		rc = hllapi('Send_File',str)
      say 'Send File RC: ' rc
		call ENTER
	end

	return

/* ====================================================================== */
 SENDKEY:
/* ====================================================================== */

	function = 'SENDKEY'				
	say 'Start Send Key ... (3)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		say 'Enter Text to Send  or Q to quit ...'
		parse pull sendit
		if sendit = 'Q' | sendit = 'q' then leave
		rc = hllapi('SendKey',sendit)
		if rc <> 0 then do
			 call SHOWRC rc
		end
   end

	return

/* ====================================================================== */
 SETCURSORPOS:
/* ====================================================================== */

	function = 'SETCURSORPOS'		
	say 'Start Set Cursor Position... (40)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

	do forever
		do forever
			say 'Enter Cursor Pos  or  Q to Quit...'
			pull pos
	      if left(pos,1) = 'Q' then leave
	      if datatype(pos) = 'NUM' then leave
		end
      if left(pos,1) = 'Q' then leave
		rc = hllapi('Set_Cursor_Pos',pos)
		if rc <> 0 then do
			 call SHOWRC rc
		end		
	end

	return

/* ====================================================================== */
 SETSESSPARMS:
/* ====================================================================== */

	function = 'SETSESSPARMS'		
	say 'Start Set Session Parms ... (9)'
	do forever
		say 'Enter session parm string ... or Q to Quit'
		parse pull sessp
		if sessp = 'Q' then leave
		if sessp = ''  then iterate
		pp = pos('noeab',sessp)
		if pp <> 0 then 
			isEAB = 0
		else	do
			pp = pos('eab',sessp)
			if pp <> 0 then 
				isEAB = 1
		end
		rc = hllapi('Set_Session_Parms',sessp)
		if rc <> 0 then
			 call SHOWRC rc
		else do
		   say 'Sess Parms SET'
			call ENTER
		end
	end

	return

/* ====================================================================== */
 STARTCLOSEINT:
/* ====================================================================== */

	function = 'STARTCLOSEINT'		
	say 'Start Close Intercept ... (41)'
	if startClose = 1 then do
		say 'Close Intercept ALREADY started...'
		call ENTER
		return
	end

	rc = hllapi('Start_Close_Intercept',session)
	if rc <> 0 then  do
		 call SHOWRC rc
	end
	else do
      say 'Start Close Intercept OK'
		call SLEEP
		startClose = 1
	end

	return

/* ====================================================================== */
 STARTHOSTNOTE:
/* ====================================================================== */

	function = 'STARTHOSTNOTE'		
	say 'Start Host Notify ... (23)'
	if startHost = 1 then do
		say 'Host Notify ALREADY started...'
		call ENTER
		return
	end

	do forever
		say 'Enter Option   P=ps update, O=oia update, B=ps & oia update  or Q to quit...'
		pull sts
		if sts = '' then iterate
		leave
	end

	if sts <> 'Q' then do
		rc = hllapi('Start_Host_Notify',session,sts)
		if rc <> 0 then do
			 call SHOWRC rc
		end		
		else do
	      say 'Start Host Notify OK'
			call SLEEP
			startHost = 1
		end
	end

	return

/* ====================================================================== */
 STARTKEYINT:
/* ====================================================================== */

	function = 'STARTKEYINT'			
	say 'Start Key Intercept ... (50)'
	if startKey = 1 then do
		say 'Keystroke Intercept ALREADY started...'
		call ENTER
		return
	end

	do forever
		say 'Enter Option   D=AID keys only,  L=All Keystrokes  or Q to Quit...'
		pull option
		if sts = '' then iterate
	end

	if option <> 'Q' then do
	   rc = hllapi('Start_Keystroke_Intercept',session,option)
	   if rc <> 0 then do
			 call SHOWRC rc
		end
		else do		
			say 'Start Keystroke Intercept OK'
			call SLEEP
			startKey = 1
		end
	end

	return

/* ====================================================================== */
 STOPCLOSEINT:
/* ====================================================================== */

	function = 'STOPCLOSEINT'		
	say 'Start Stop Close Intercept ... (43)'
	if startClose = 0 then do
		call MUSTSTARTCLOSE
		return
	end

	rc = hllapi('Stop_Close_Intercept',session)
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
      say 'Stop Close Intercept OK'
		call SLEEP
		startClose = 0
	end		

	return

/* ====================================================================== */
 STOPHOSTNOTE:
/* ====================================================================== */

	function = 'STOPHOSTNOTE'		
	say 'Start Stop Host Notify ... (25)'
	if startHost = 0 then do
		call MUSTSTARTHOST
		return
	end

	rc = hllapi('Stop_Host_Notify',session)
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
      say 'Stop Host Notify OK'
		call SLEEP
		startHost = 0
	end		

	return

/* ====================================================================== */
 STOPKEYINT:
/* ====================================================================== */

	function = 'STOPKEYINT'			
	say 'Start Stop Key Intercept ... (53)'
	if startKey = 0 then do
		call MUSTSTARTKEY
		return
	end

	rc = hllapi('Stop_Host_Notify',session)
	if rc <> 0 then do
		 call SHOWRC rc
	end		
	else do
      say 'Stop Key Intercept OK'
		call SLEEP
		startKey = 0
	end		

/* ====================================================================== */
 WAIT:
/* ====================================================================== */

	function = 'WAIT'					
	say 'Start Wait ... (4)'
	if connectedPS = 0 then do
		call MUSTCONNECTPS
		return
	end

   rc = hllapi('Wait')
	if rc <> 0 then do
		 call SHOWRC rc
	end	
	else do
		say 'Wait OK'
		call SLEEP
	end	

   return

/* ====================================================================== */
 MUSTCONNECTPM:
/* ====================================================================== */
	say
	say 'Prerequisite Call -----------'
	say 'Connect_PM Services ... (101)'
	say
	call ENTER
	return

/* ====================================================================== */
 MUSTCONNECTPS:
/* ====================================================================== */
	say
	say 'Prerequisite Call -----------'
	say 'Connect_PS ... (3)'
	say
	call ENTER
	return

/* ====================================================================== */
 MUSTSTARTCLOSE:
/* ====================================================================== */
	say
	say 'Prerequisite Call -----------'
	say 'Start_Close_Intercept ... (43)'
	say
	call ENTER
	return

/* ====================================================================== */
 MUSTSTARTHOST:
/* ====================================================================== */
	say
	say 'Prerequisite Call -----------'
	say 'Start_Host_Notify ... (25)'
	say
	call ENTER
	return

/* ====================================================================== */
 MUSTSTARTKEY:
/* ====================================================================== */
	say
	say 'Prerequisite Call -----------'
	say 'Start_Keystroke_Intercept ... (50)'
	say
	call ENTER
	return

/* ====================================================================== */
 ENTER:
/* ====================================================================== */
	say 'press enter to continue...'
	pull a
	return

/* ====================================================================== */
 SLEEP:
/* ====================================================================== */
	call SysSleep 3
	return

/* ====================================================================== */
 HEADER:
/* ====================================================================== */

	call SysCls
	say 'SCA REXX (SAAHLAPI) hllapi Function Tester .......'
	say	
	return

/* ====================================================================== */
 ALPHALIST:
/* ====================================================================== */

	do forever			
		call HEADER
		if showWho = 0 then do
			say 'ALPHA Listing .................'
			say
			say '<1>  Change Switch List (105)       <14> Find Field Len (32)' 
			say '<2>  Change Window Title (106)      <15> Find Field Pos (31)' 
			say '<3>  Connect PS (1)                 <16> Get Key (51)'
			say '<4>  Connect PM Services (101)      <17> Get/Set Window Status (104)' 
			say '<5>  Convert Pos or Row/Col (99)    <18> Intercept Status (52)'
			say '<6>  Copy Field to Str (34)         <19> Lock PMSVC (61)'
			say '<7>  Copy OIA (13)                  <20> Lock PS (60)'
			say '<8>  Copy PS (5)                    <21> Pause (18)'
			say '<9>  Copy PS to Str (8)             <22> Query Button Information'
			say '<10> Copy Str to Field (33)         <23> Query Close Int (42)'      
			say '<11> Copy Str to PS (15)            <24> Query Cursor Position (7)' 
			say '<12> Disconnect PS (2)              <25> Query Field Attribute (14)'
			say '<13> Disconnect PM Services (102)   <26> Query Host Update (24)'     
			say
			say '<N>ext Page,  <#>Numeric List,  <Q>uit'
		end
		else	do
			say 'ALPHA Listing .................'
			say
			say '<27> Query Window Coord (103)       <38> Send Key (3)'
			say '<28> Query Session Status (22)      <39> Set Cursor Pos (40)'        
			say '<29> Query Sessions (10)            <40> Set Session Parms (9)'      
			say '<20> Query System (20)              <41> Start Close Int (41)'       
			say '<31> Receive File (91)              <42> Start Host Notify (23)'     
			say '<32> Release (12)                   <43> Start Keystroke Int (50)'   
			say '<33> Reserve (11)                   <44> Stop Close Int (43)'        
			say '<34> Reset System (21)              <45> Stop Host Notify (25)'      
			say '<35> Search Field (30)              <46> Stop Keystroke Int (53)'    
			say '<36> Search PS (6)                  <47> Wait (4)'                   
			SAY '<37> Send File (90)                 <48> GET EXTENDED Window Status' 
			say
			say '<P>revious Page,  <#>Numeric List,  <Q>uit'
		end
		pull test	
		if left(test,1) = 'Q' then return 255
		if left(test,1) = '#' then do 
			showWho = 0
			return 1
		end
		if left(test,1) = 'P' & showWho = 1 then
			showWho = 0
		else
		if left(test,1) = 'N' & showWho = 0 then 
			showWho = 1
		else
		if datatype(test) = 'NUM' then return 0
	end
	return 0

/* ====================================================================== */
 NUMLIST:
/* ====================================================================== */

	do forever			
		call HEADER
		if showWho = 0 then do
			say 'NUMERIC Listing .................'
			say
			say '<1>  Connect PS                     <14>  Query Field Attribute'
			say '<2>  Disconnect PS                  <15>  Copy Str to PS'
			say '<3>  Send Key                       <18>  Pause'
			say '<4>  Wait                           <20>  Query System'
			say '<5>  Copy PS                        <21>  Reset System'
			say '<6>  Search PS                      <22>  Query Session Status'
			say '<7>  Query Cursor Position          <23>  Start Host Notify'
			say '<8>  Copy PS to Str                 <24>  Query Host Update'
			say '<9>  Set Session Parms              <25>  Stop Host Notify'
			say '<10> Query Sessions                 <30>  Search Field'
			say '<11> Reserve                        <31>  Find Field Pos'
			say '<12> Release                        <32>  Find Field Len'
			say '<13> Copy OIA                       <33>  Copy Str to Field'
			say
			say '<N>ext Page,  <A>lpha List,  <Q>uit'
		end
		else	do
			say 'NUMERIC Listing .................'
			say
			say '<34> Copy Field to Str              <90>   Send File'
			say '<40> Set Cursor Position            <91>   Receive File'
			say '<41> Start Close Intercept          <99>   Convert Pos or Row/Col'
			say '<42> Query Close Intercept          <101>  Connect PM Services'
			say '<43> Stop Close Intercept           <102>  Disconnect PM Services'
			say '<50> Start Keystroke Intercept      <103>  Window Coordinates'
			say '<51> Get Key                        <104>  Get/Set Window Status'
			say '<52> Post Intercept Status          <105>  Change Switch List'
			say '<53> Stop Keystroke Intercept       <106>  Change Window Title'
			say '<60> Lock PS                        <999>  GET EXTENDED Window Status'
			say '<61> Lock PMSVC                     <5011> Query Button Information'
			say
			say '<P>revious Page,  <A>lpha List,  <Q>uit'
		end
		pull test
		if left(test,1) = 'Q' then return 255
		if left(test,1) = 'A' then do 
			showWho = 0
			return 2
		end
		if left(test,1) = 'P' & showWho = 1 then 
			showWho = 0
		else
		if left(test,1) = 'N' & showWho = 0 then 
			showWho = 1
		else
		if datatype(test) = 'NUM' then return  0
	end
	return 0

/* ======================================================================= */
 SHOWRC: procedure expose function
/* ======================================================================= */

	arg rc
	if rc = '' then return

	call SysCls
	say '==================================================================='
	say 'ERROR with hllapi <'||function||'>, RC is ' rc
	say '==================================================================='
	say
			say '  RC  - Description'
			say '----- -----------------------------------------------------------------'
	select
		when function = 'SETSWITCHLIST'		then do
			say '  2   - An error was made in specifing parameters'
			say '  9   - A System error occurred'
			say '  12  - The session stopped'
		end
		when function = 'SETWINDOWTITLE'		then do
			say '  2   - An error was made in specifing parameters'
			say '  9   - A System error occurred'
			say '  12  - The session stopped'
		end
		when function = 'CONNECTPS'			then do
			say '  4   - Successful connection, but the session is busy'
			say '  5   - Successful connection, but the session is locked'
			say '  9   - A System error occurred'
			say '  11  - The session is already being used'
		end
		when function = 'CONNECTPM'			then do
			say '  9   - A System error occurred'
			say '  10  - The function is not supported by your emulation program'
			say '  11  - The session is already being used'
		end
		when function = 'CONVERT'				then do
			say '  0   - The specified ROW/COl or POSITION is outside PS'
		end
		when function = 'COPYFIELDTOSTR'		then do
			say '  ""  - Null, No field data was found at POS, or invalid POS'
		end
		when function = 'COPYOIA'				then do
			say '  ""  - Null, Not Connected or other error'
		end
		when function = 'COPYPS'				then do
			say '  ""  - Null, Not Connected or other error'
		end
		when function = 'COPYPSTOSTR'			then do
			say '  ""  - Null, Not Connected or other error'
		end
		when function = 'COPYSTRTOFIELD'		then do
			say '  2   - An error was made in specifing parameters'
			say '  5   - Target field was prot or inhibit,'
			say '            or illegel data was sent to field (maybe attrib)'
			say '  6   - Copy was completed, but data was truncated'
			say '  7   - The POS parameter was invalid'
			say '  24  - The screen gas no fields (unformatted)'
		end
		when function = 'COPYSTRTOPS'			then do
			say '  2   - An error was made in specifing parameters'
			say '  5   - Target field was prot or inhibit,'
			say '            or illegel data was sent to field (maybe attrib)'
			say '  6   - Copy was completed, but data was truncated'
			say '  7   - The POS parameter was invalid'
			say '  24  - The screen gas no fields (unformatted)'
		end
		when function = 'DISCONNECTPS'		then do
			say '  9   - A System error occurred'
		end
		when function = 'DISCONNECTPM'		then do
			say '  9   - A System error occurred'
		end
		when function = 'FIELDLEN'				then do
			say '  0   - The specified field was not found'
		end
		when function = 'FIELDPOS'				then do
			say '  0   - The specified field was not found'
		end
		when function = 'GETKEY'				then do
			say '  ""  - Null, Error or not connected to session'
		end
		when function = 'GETWINDOWSTATUS'	then do
			say '  ""  - Null, Error or not connected to PM window services'
		end
		when function = 'INTSTATUS'			then do
			say '  1   - The PS was invalid'
			say '  9   - A System error occurred'
		end
		when function = 'LOCKPMSVC'			then do
			say '  1   - The PS was invalid'
			say '  2   - An error was made in specifing parameters'
			say '  9   - A System error occurred'
			say '  43  - The API is already LOCKED, or it is NOT LOCKED'
		end
		when function = 'LOCKPS'				then do
			say '  1   - The PS was invalid'
			say '  2   - An error was made in specifing parameters'
			say '  9   - A System error occurred'
			say '  43  - The API is already LOCKED, or it is NOT LOCKED'
		end
		when function = 'PAUSE'					then do
			say '  9   - A System error occurred'
			say '  26  - Host session or OIA has been updated'
		end
		when function = 'QUERYCLOSEINT'		then do
			say '  2   - An error was made in specifing parameters'
			say '  9   - A System error occurred'
			say '  12  - The session stopped'
			say '  26  - A close Intercept occcured since the last Query call'
		end
		when function = 'QUERYCURSORPOS'		then do
			say '  0   - Your program is not currently connected to the host session'
		end
		when function = 'QUERYFIELDATTR'		then do
			say '  1   - Your program is not currently connected to the host session'
		end
		when function = 'QUERYHOSTUPDATE'	then do
			say '  0   - No updates were made since last call'
			say '  1   - An invalid hos PS was specified'
			say '  9   - A System error occurred'
			say '  21  - The OIA has been updated'
			say '  22  - The PS has been updated'
			say '  23  - The OIA and PS have been updated'
		end
		when function = 'QUERYWINDOWCOORD'	then do
			say '  ""  - Null, Error or not connected to PM window services'
		end
		when function = 'QUERYSESSSTATUS'	then do
			say '  ""  - Null, Error or not connected to PM window services'
		end
		when function = 'QUERYSESSIONS'		then do
			say '  ""  - Null, Error or not connected to PM window services'
		end
		when function = 'QUERYSYSTEM'			then do
			say '  ""  - Null, Error or not connected to PM window services'
		end
		when function = 'RECEIVEFILE'			then do
			say '  2   - An error was made in specifing parameters,'
			say '         or you specified a data string length that was too'
			say '           or too long (0 or > 128)'
			say '  3   - The file Transfer was complete'
			say '  4   - The file Transfer was complete and has segmented records'
			say '  9   - A System error occurred'
			say '  27  - Either Ctrl+Break (cancel) or timeout occured'
			say ' 300+ - Error Code, subtract 300 from code for OS/2 error code'
		end
		when function = 'RELEASE'				then do
			say '  1   - Your program is not currently connected to the host session'
		end
		when function = 'RESERVE'				then do
			say '  1   - Your program is not currently connected to the host session'
			say '  5   - The PS is inhibited'
			say '  9   - A System error occurred'
		end
		when function = 'RESETSYSTEM'			then do
			say '  9   - A System error occurred'
		end
		when function = 'SEARCHFIELD'			then do
			say '  0   - The string was NOT found, or you are not connected'
		end
		when function = 'SEARCHPS'				then do
			say '  0   - The string was NOT found, or you are not connected'
		end
		when function = 'SENDFILE'				then do
			say '  2   - An error was made in specifing parameters,'
			say '         or you specified a data string length that was too'
			say '           or too long (0 or > 128)'
			say '  3   - The file Transfer was complete'
			say '  4   - The file Transfer was complete and has segmented records'
			say '  5   - The workstation name was invalid or NOT found'
			say '  9   - A System error occurred'
			say '  27  - Either Ctrl+Break (cancel) or timeout occured'
			say ' 300+ - Error Code, subtract 300 from code for OS/2 error code'
		end
		when function = 'SENDKEY'				then do
			say '  4   - The Host session was busy'
			say '  5   - Input to target was inhibited, or invalid key mnemonics'
			say '  6   - Bad Keystroke'
		end
		when function = 'SETCURSORPOS'		then do
			say '  1   - Your program is not currently connected to the host session'
		end
		when function = 'SETSESSPARMS'		then do
			say '  2   - One or more parameter errors'
			say '  9   - A System error occurred'
		end
		when function = 'STARTCLOSEINT'		then do
			say '  1   - The PS was invalid'
			say '  9   - A System error occurred'
			say '  10  - The function is not supported by your emulation program'
		end
		when function = 'STARTHOSTNOTE'		then do
			say '  1   - The PS was invalid'
			say '  2   - One or more parameter errors'
			say '  9   - A System error occurred'
		end
		when function = 'STARTKEYINT'			then do
			say '  1   - The PS was invalid'
			say '  2   - One or more parameter errors'
			say '  4   - The Resource was unavilable, the PS was in use'
			say '  9   - A System error occurred'
		end
		when function = 'STOPCLOSEINT'		then do
			say '  1   - The PS was invalid'
			say '  9   - A System error occurred'
			say '  12  - The session stopped'
		end
		when function = 'STOPKEYINT'			then do
			say '  1   - The PS was invalid'
			say '  9   - A System error occurred'
		end
		when function = 'STOPHOSTNOTE'		then do
			say '  1   - The PS was invalid'
			say '  9   - A System error occurred'
		end
		when function = 'WAIT'					then do
			say '  4   - Time-out while busy (in XSYSTEM state)'
			say '  5   - The keyboard is locked'
			say '  9   - A System error occurred'
		end
		when function = 'QUERYBUTTONS' 				then do
			say '  1   - The PS was invalid'
			say '  2   - One or more parameter errors'
			say '  9   - A System error occurred'
		end
		otherwise
			say 'Unknown Function ....'
	end				
	say
	say 'If the ERROR code is not described above, refer to the IBM manual....'
	say
	say 'IBM Extended Services for OS/2'
	say 'EHLLAPI Programming Reference'
	say 'Doc Number: S04G-1027-xx'
	say 'Appendix F, REXX EHLLAPI Functions'
	say
	call ENTER
	return

